/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.UserTask;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Engine {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/Engine.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$workflow$simple$Engine == null ? (class$com$arsdigita$workflow$simple$Engine = Engine.class$("com.arsdigita.workflow.simple.Engine")) : class$com$arsdigita$workflow$simple$Engine));
    private static Engine s_engine = null;
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$Engine;

    public static synchronized Engine getInstance() {
        if (s_engine == null) {
            s_engine = new Engine();
        }
        return s_engine;
    }

    Engine() {
        ACSObjectInstantiator instTask = new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Task(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator("com.arsdigita.workflow.simple.Task", (DomainObjectInstantiator)instTask);
        ACSObjectInstantiator instUserTask = new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new UserTask(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator("com.arsdigita.workflow.simple.UserTask", (DomainObjectInstantiator)instUserTask);
        ACSObjectInstantiator instWorkflow = new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Workflow(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator("com.arsdigita.workflow.simple.Workflow", (DomainObjectInstantiator)instWorkflow);
    }

    private void populateAssignedTaskUser(ArrayList assignedTasks, DataQuery query) {
        Session session = SessionManager.getSession();
        BigDecimal taskID = null;
        while (query.next()) {
            taskID = (BigDecimal)query.get("taskID");
            DataObject taskDataObject = session.retrieve(new OID("com.arsdigita.workflow.simple.Task", (Object)taskID));
            assignedTasks.add(DomainObjectFactory.newInstance(taskDataObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAssignedTaskGroup(ArrayList assignedTasks, DataQuery query, User user) {
        BigDecimal taskID = null;
        BigDecimal groupID = null;
        Task tempTask = null;
        Group group = null;
        Session session = SessionManager.getSession();
        try {
            while (query.next()) {
                DataObject taskDataObject;
                taskID = (BigDecimal)query.get("taskID");
                groupID = (BigDecimal)query.get("groupID");
                try {
                    group = new Group(groupID);
                }
                catch (DataObjectNotFoundException e) {
                    throw new UncheckedWrapperException("Could not create task group (" + groupID + ")", e);
                }
                if (!group.hasMember(user) || assignedTasks.contains(tempTask = (Task)DomainObjectFactory.newInstance(taskDataObject = session.retrieve(new OID("com.arsdigita.workflow.simple.Task", (Object)taskID))))) continue;
                assignedTasks.add(tempTask);
            }
        }
        finally {
            query.close();
        }
    }

    public ArrayList getEnabledTasks(User user) {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedUsers");
        Filter filter = query.addFilter("userID = :user_id");
        filter.set("user_id", user.getID());
        query.addFilter("taskState = 'enabled'");
        query.addFilter("isActive = '1'");
        ArrayList usersTask = new ArrayList();
        this.populateAssignedTaskUser(usersTask, query);
        query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedGroups");
        query.addFilter("isActive = '1'");
        query.addFilter("taskState = 'enabled'");
        this.populateAssignedTaskGroup(usersTask, query, user);
        return usersTask;
    }

    public ArrayList getEnabledTasks(User user, BigDecimal workflowId) {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedUsers");
        query.addFilter("userID = :user_id");
        Filter userWorkflowFilter = query.addFilter("parentID = :workflowId");
        userWorkflowFilter.set("user_id", user.getID());
        userWorkflowFilter.set("workflowId", workflowId);
        query.addFilter("taskState = 'enabled'");
        query.addFilter("isActive = '1'");
        ArrayList usersTask = new ArrayList();
        this.populateAssignedTaskUser(usersTask, query);
        query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedGroups");
        Filter groupWorkflowFilter = query.addFilter("parentID = :workflowId");
        groupWorkflowFilter.set("workflowId", workflowId);
        query.addFilter("isActive = '1'");
        query.addFilter("taskState = 'enabled'");
        this.populateAssignedTaskGroup(usersTask, query, user);
        return usersTask;
    }

    public ArrayList getOverdueTasks(User user) {
        ArrayList<UserTask> overdueTasks = new ArrayList<UserTask>();
        ArrayList enabledTasks = this.getEnabledTasks(user);
        Iterator itr = enabledTasks.iterator();
        UserTask tempTask = null;
        while (itr.hasNext()) {
            tempTask = (UserTask)itr.next();
            if (!tempTask.isOverdue()) continue;
            overdueTasks.add(tempTask);
        }
        return overdueTasks;
    }

    public ArrayList getFinishedTasks(User user, Date start, Date end) {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedUsers");
        Filter startDateFilter = null;
        Filter dueDateFilter = null;
        query.addFilter("taskState = 'finished'");
        query.addFilter("isActive = '1'");
        ArrayList finishedTasks = new ArrayList();
        this.populateAssignedTaskUser(finishedTasks, query);
        query = session.retrieveQuery("com.arsdigita.workflow.simple.getTaskAssignedGroups");
        query.addFilter("isActive = '1'");
        if (start != null) {
            startDateFilter = query.addFilter("taskStartDate >= :start");
            startDateFilter.set("start", start);
        }
        if (end != null) {
            dueDateFilter = query.addFilter("taskDueDate <= :end");
            dueDateFilter.set("end", end);
        }
        this.populateAssignedTaskGroup(finishedTasks, query, user);
        return finishedTasks;
    }

    public ArrayList getOverdueProcesses() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getOverDueProcesses");
        BigDecimal processID = null;
        ArrayList<Workflow> overdueProcesses = new ArrayList<Workflow>();
        try {
            while (query.next()) {
                processID = (BigDecimal)query.get("processID");
                overdueProcesses.add(new Workflow(processID));
            }
        }
        catch (DataObjectNotFoundException e) {
            s_log.error((Object)"Error loading workflow", (Throwable)e);
            throw e;
        }
        finally {
            query.close();
        }
        return overdueProcesses;
    }

    public ArrayList getActiveProcesses() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getActiveProcesses");
        BigDecimal processID = null;
        ArrayList<Workflow> activeProcesses = new ArrayList<Workflow>();
        while (query.next()) {
            processID = (BigDecimal)query.get("processID");
            try {
                activeProcesses.add(new Workflow(processID));
            }
            catch (DataObjectNotFoundException e) {
                query.close();
                throw new Error("Faled loading process");
            }
        }
        return activeProcesses;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

