/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollectionIterator;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.ProcessException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.UserTask;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Workflow
extends Task {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/Workflow.java#20 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workflow.simple.Workflow";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$workflow$simple$Workflow == null ? (class$com$arsdigita$workflow$simple$Workflow = Workflow.class$("com.arsdigita.workflow.simple.Workflow")) : class$com$arsdigita$workflow$simple$Workflow));
    private OID m_ACSObjectOID = null;
    private static final String ACS_OBJECT = "object";
    private static final String PROCESS_STATE = "processState";
    private static final String WF_TASKS = "wfTasks";
    private static final String PROCESS_DEF_ID = "processDefinitionID";
    public static final int NONE = -1;
    public static final int STARTED = 0;
    public static final int STOPPED = 1;
    public static final int DELETED = 2;
    public static final int INIT = 3;
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$Workflow;

    public Workflow(String label, String description) {
        super(BASE_DATA_OBJECT_TYPE);
        this.initAttributes(label, description);
    }

    public Workflow() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Workflow(DataObject workflowDataObject) {
        super(workflowDataObject);
    }

    protected Workflow(ObjectType type) {
        super(type);
    }

    protected Workflow(String typeName) {
        super(typeName);
    }

    public Workflow(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Workflow(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected void initialize() {
        super.initialize();
        if (!this.isNew()) {
            DataObject object = (DataObject)this.get(ACS_OBJECT);
            if (object != null) {
                this.m_ACSObjectOID = object.getOID();
            }
        } else {
            this.setProcessState(3);
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void addTask(Task task) {
        task.setParent(this);
        if (this.getProcessState() == 0) {
            task.updateState();
        }
        task.addFinishedListener(this);
        task.save();
        this.updateState();
    }

    public void removeTask(Task task) {
        this.remove(WF_TASKS, task);
    }

    public void removeAllTasks() {
        DataAssociation da = this.getTaskAssociation();
        da.clear();
        this.save();
    }

    public final TaskCollection getTaskCollection() {
        return new TaskCollection(this.getTaskAssociation().cursor());
    }

    public void save(User user) throws ProcessException {
        this.save();
    }

    public int getTaskCount() {
        return new Long(this.getTaskAssociation().cursor().size()).intValue();
    }

    public void stop(User user) {
        this.setProcessState(1);
        this.save();
    }

    public void start(User user) {
        int processState = this.getProcessState();
        this.setProcessState(0);
        if (processState == 3) {
            this.setActive(true);
            this.updateState();
            this.startInternal();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startInternal() {
        Task tempTask;
        TaskCollection tasks = this.getTaskCollection();
        try {
            while (tasks.next()) {
                tempTask = tasks.getTask();
                tempTask.setActive(true);
                tempTask.save();
            }
        }
        finally {
            tasks.close();
        }
        tasks = this.getTaskCollection();
        try {
            while (tasks.next()) {
                tempTask = tasks.getTask();
                tempTask.updateState();
            }
        }
        finally {
            tasks.close();
        }
    }

    public int getProcessState() {
        return this.getProcessStateInt((String)this.get(PROCESS_STATE));
    }

    private void setProcessState(int state) {
        this.set(PROCESS_STATE, this.getProcessStateStr(state));
        if (!this.isNew()) {
            this.save();
        }
    }

    public void setObject(ACSObject o) {
        this.m_ACSObjectOID = o.getOID();
        this.set(ACS_OBJECT, o);
    }

    public void setObjectID(BigDecimal id) {
        this.m_ACSObjectOID = new OID("com.arsdigita.kernel.ACSObject", (Object)id);
        try {
            this.set(ACS_OBJECT, DomainObjectFactory.newInstance(this.m_ACSObjectOID));
        }
        catch (DataObjectNotFoundException e) {
            s_log.error((Object)"unable to locate the ID for the workflow");
            throw new UncheckedWrapperException("Unable to locate object corresponding to ID " + id, e);
        }
    }

    private int getProcessStateInt(String state) {
        if (state.equals("stopped")) {
            return 1;
        }
        if (state.equals("started")) {
            return 0;
        }
        if (state.equals("deleted")) {
            return 2;
        }
        if (state.equals("init")) {
            return 3;
        }
        return -1;
    }

    private String getProcessStateStr(int state) {
        switch (state) {
            case 0: {
                return "started";
            }
            case 1: {
                return "stopped";
            }
            case 2: {
                return "deleted";
            }
            case 3: {
                return "init";
            }
            case -1: {
                return "none";
            }
        }
        return null;
    }

    public Iterator getTasks() {
        return new DomainCollectionIterator(this.getTaskCollection());
    }

    private DataAssociation getTaskAssociation() {
        return (DataAssociation)this.get(WF_TASKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEnabledTasks() {
        if (this.getProcessState() == 2 || this.getProcessState() == 1) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("No enabled tasks. Process state is " + this.getProcessState()));
            }
            return Collections.EMPTY_LIST.iterator();
        }
        TaskCollection tasks = this.getTaskCollection();
        try {
            FilterFactory factory = tasks.getFilterFactory();
            CompoundFilter filter = factory.and();
            filter.addFilter(factory.equals("taskState", Task.getStateString(1)));
            filter.addFilter(factory.equals("isActive", "1"));
            tasks.addFilter(filter);
            LinkedList<Task> enabledTasks = new LinkedList<Task>();
            while (tasks.next()) {
                enabledTasks.add(tasks.getTask());
            }
            Iterator iterator = enabledTasks.iterator();
            return iterator;
        }
        finally {
            tasks.close();
        }
    }

    public Iterator getFinishedTasks() {
        TaskCollection tasksCollection = this.getTaskCollection();
        Filter filter = tasksCollection.addFilter("taskState = :taskState");
        filter.set("taskState", "finished");
        return new DomainCollectionIterator(tasksCollection);
    }

    public Iterator getOverdueTasks() {
        HashSet<Task> tasksSet = new HashSet<Task>();
        TaskCollection tasksCollection = this.getTaskCollection();
        while (tasksCollection.next()) {
            Task task = (Task)tasksCollection.getDomainObject();
            if (!(task instanceof UserTask) || !((UserTask)task).isOverdue()) continue;
            tasksSet.add(task);
        }
        tasksCollection.close();
        return tasksSet.iterator();
    }

    public OID getObjectOID() {
        return this.m_ACSObjectOID;
    }

    public ACSObject getObject() {
        OID objOID = this.getObjectOID();
        if (objOID == null) {
            return null;
        }
        try {
            return (ACSObject)DomainObjectFactory.newInstance(this.getObjectOID());
        }
        catch (DataObjectNotFoundException de) {
            throw new UncheckedWrapperException("Could not load object with OID " + this.getObjectOID(), de);
        }
    }

    public void removeTask(Task task, Iterator dependentList) {
        while (dependentList.hasNext()) {
            Task dependentTask = (Task)dependentList.next();
            dependentTask.removeFinishedListener(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateState() {
        super.updateState();
        if (this.getState() == 1) {
            TaskCollection tasks = this.getTaskCollection();
            FilterFactory factory = tasks.getFilterFactory();
            CompoundFilter filter = factory.and();
            filter.addFilter(factory.notEquals("taskState", Task.getStateString(2)));
            filter.addFilter(factory.equals("isActive", "1"));
            tasks.addFilter(filter);
            try {
                if (tasks.next()) {
                    return;
                }
            }
            finally {
                tasks.close();
            }
            try {
                this.finish();
            }
            catch (TaskException e) {
                throw new UncheckedWrapperException("failed on calling finished: ", e);
            }
        }
        if (this.getState() == 2) {
            boolean enable = false;
            TaskCollection tasks = this.getTaskCollection();
            FilterFactory factory = tasks.getFilterFactory();
            tasks.addFilter(factory.notEquals("taskState", Task.getStateString(2)));
            try {
                enable = tasks.next();
            }
            finally {
                tasks.close();
            }
            if (enable) {
                this.enable();
            }
        }
    }

    public synchronized Object clone() {
        Workflow workflowClone = new Workflow(this.getLabel(), this.getDescription());
        workflowClone.save();
        this.cloneTasks(workflowClone);
        return workflowClone;
    }

    protected void cloneTasks(Workflow workflowClone) {
        Task taskClone;
        Task task;
        HashMap<Task, Task> taskToCloneMap = new HashMap<Task, Task>();
        Iterator tasks = this.getTasks();
        while (tasks.hasNext()) {
            task = (Task)tasks.next();
            taskClone = null;
            try {
                taskClone = (Task)task.clone();
                taskClone.removeAllFinishedListeners();
                taskClone.save();
                taskClone.removeAllDependencies();
                taskClone.save();
            }
            catch (CloneNotSupportedException c) {
                c.printStackTrace();
                throw new RuntimeException(c.getMessage());
            }
            workflowClone.addTask(taskClone);
            taskToCloneMap.put(task, taskClone);
        }
        tasks = this.getTasks();
        while (tasks.hasNext()) {
            task = (Task)tasks.next();
            taskClone = (Task)taskToCloneMap.get(task);
            Iterator dependencies = task.getDependencies();
            while (dependencies.hasNext()) {
                Task dependOn = (Task)dependencies.next();
                Task dependOnClone = (Task)taskToCloneMap.get(dependOn);
                taskClone.addDependency(dependOnClone);
            }
            Iterator finishedListeners = task.getFinishedListeners();
            while (finishedListeners.hasNext()) {
                Task taskListenerClone;
                Task listener = (Task)finishedListeners.next();
                if (listener.equals(this) || listener.isDependency(task)) continue;
                try {
                    taskListenerClone = (Task)listener.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                taskListenerClone.save();
                taskClone.addFinishedListener(taskListenerClone);
            }
            taskClone.save();
        }
        workflowClone.save();
    }

    public void enable() {
        int taskState = this.getState();
        if (taskState == 1) {
            return;
        }
        super.enable();
    }

    public void disableEvt() {
        Task tempTask = null;
        this.stop(null);
        Iterator itr = this.getTasks();
        while (itr.hasNext()) {
            tempTask = (Task)itr.next();
            tempTask.disable();
        }
        this.setProcessState(3);
        this.save();
    }

    public void setWorkflowTemplate(WorkflowTemplate template) {
        if (template != null) {
            this.set(PROCESS_DEF_ID, template.getID());
        } else {
            this.set(PROCESS_DEF_ID, null);
        }
    }

    public WorkflowTemplate getWorkflowTemplate() {
        BigDecimal templateID = (BigDecimal)this.get(PROCESS_DEF_ID);
        if (templateID != null) {
            try {
                return (WorkflowTemplate)DomainObjectFactory.newInstance(new OID("com.arsdigita.workflow.simple.WorkflowTemplate", (Object)templateID));
            }
            catch (DataObjectNotFoundException de) {
                throw new UncheckedWrapperException("Could not load WorkflowTemplate with ID " + templateID, de);
            }
        }
        return null;
    }

    public static BigDecimal getItemID(Workflow w) {
        return Workflow.getItemID(w.getID());
    }

    public static BigDecimal getItemID(BigDecimal workflowId) {
        BigDecimal objectID = null;
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getProcesses");
        query.addEqualsFilter("id", workflowId);
        if (query.next()) {
            objectID = (BigDecimal)query.get("processObjectID");
            query.close();
        }
        return objectID;
    }

    public static BigDecimal getObjectWorkflowID(BigDecimal id) {
        BigDecimal workflowID = null;
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getProcesses");
        Filter filter = query.addFilter("processObjectID = :object_id");
        filter.set("object_id", id);
        if (query.next()) {
            workflowID = (BigDecimal)query.get("processID");
            query.close();
        }
        return workflowID;
    }

    public static BigDecimal getObjectWorkflowID(ACSObject o) {
        return Workflow.getObjectWorkflowID(o.getID());
    }

    public static Workflow getObjectWorkflow(BigDecimal id) {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.workflow.simple.getProcesses");
        Filter filter = query.addFilter("processObjectID = :object_id");
        filter.set("object_id", id);
        if (query.next()) {
            BigDecimal workflowID = (BigDecimal)query.get("processID");
            query.close();
            if (workflowID != null) {
                return new Workflow(workflowID);
            }
        }
        return null;
    }

    public static Workflow getObjectWorkflow(ACSObject o) {
        return Workflow.getObjectWorkflow(o.getID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

