/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Expression;
import com.redhat.persistence.common.Path;

public abstract class Condition
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Condition.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public abstract void dispatch(Switch var1);

    public void dispatch(Expression.Switch sw) {
        sw.onCondition(this);
    }

    public static final And and(Expression left, Expression right) {
        return new And(left, right);
    }

    public static final Or or(Expression left, Expression right) {
        return new Or(left, right);
    }

    public static final Equals equals(Expression left, Expression right) {
        return new Equals(left, right);
    }

    public static final Equals equals(Path left, Path right) {
        return Condition.equals(Expression.variable(left), Expression.variable(right));
    }

    public static final Contains contains(Expression left, Expression right) {
        return new Contains(left, right);
    }

    public static final Contains contains(Path left, Path right) {
        return Condition.contains(Expression.variable(left), Expression.variable(right));
    }

    public static final In in(Expression left, Expression right) {
        return new In(left, right);
    }

    public static final Not not(Expression expr) {
        return new Not(expr);
    }

    public static class Not
    extends Condition {
        private Expression m_expr;

        private Not(Expression expr) {
            this.m_expr = expr;
        }

        public Expression getExpression() {
            return this.m_expr;
        }

        public void dispatch(Switch sw) {
            sw.onNot(this);
        }

        public String toString() {
            return "not " + this.m_expr;
        }
    }

    public static class In
    extends Binary {
        private In(Expression left, Expression right) {
            super(left, right);
        }

        public void dispatch(Switch sw) {
            sw.onIn(this);
        }

        String getOperator() {
            return " in ";
        }
    }

    public static class Equals
    extends Binary {
        private Equals(Expression left, Expression right) {
            super(left, right);
        }

        public void dispatch(Switch sw) {
            sw.onEquals(this);
        }

        String getOperator() {
            return " = ";
        }
    }

    public static class Contains
    extends Binary {
        private Contains(Expression left, Expression right) {
            super(left, right);
        }

        public void dispatch(Switch sw) {
            sw.onContains(this);
        }

        String getOperator() {
            return " contains ";
        }
    }

    public static class Or
    extends Binary {
        private Or(Expression left, Expression right) {
            super(left, right);
        }

        public void dispatch(Switch sw) {
            sw.onOr(this);
        }

        String getOperator() {
            return "or";
        }
    }

    public static class And
    extends Binary {
        private And(Expression left, Expression right) {
            super(left, right);
        }

        public void dispatch(Switch sw) {
            sw.onAnd(this);
        }

        String getOperator() {
            return "and";
        }
    }

    static abstract class Binary
    extends Condition {
        private Expression m_left;
        private Expression m_right;

        private Binary(Expression left, Expression right) {
            this.m_left = left;
            this.m_right = right;
        }

        public Expression getLeft() {
            return this.m_left;
        }

        public Expression getRight() {
            return this.m_right;
        }

        abstract String getOperator();

        public String toString() {
            return "(" + this.getLeft() + " " + this.getOperator() + " " + this.getRight() + ")";
        }
    }

    public static abstract class Switch {
        public abstract void onAnd(And var1);

        public abstract void onOr(Or var1);

        public abstract void onNot(Not var1);

        public abstract void onEquals(Equals var1);

        public abstract void onIn(In var1);

        public abstract void onContains(Contains var1);
    }
}

