/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.ClosedException;
import com.redhat.persistence.DataSet;
import com.redhat.persistence.NoRowException;
import com.redhat.persistence.NotFetchedException;
import com.redhat.persistence.RecordSet;
import com.redhat.persistence.Session;
import com.redhat.persistence.common.Path;
import java.util.Map;
import org.apache.log4j.Logger;

public class Cursor {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Cursor.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$Cursor == null ? (class$com$redhat$persistence$Cursor = Cursor.class$("com.redhat.persistence.Cursor")) : class$com$redhat$persistence$Cursor));
    private final DataSet m_ds;
    private RecordSet m_rs = null;
    private Map m_values = null;
    private long m_position = 0L;
    private boolean m_closed = false;
    static /* synthetic */ Class class$com$redhat$persistence$Cursor;

    protected Cursor(DataSet ds) {
        this.m_ds = ds;
    }

    public DataSet getDataSet() {
        return this.m_ds;
    }

    public Session getSession() {
        return this.m_ds.getSession();
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    private Object getInternal(Path path) {
        if (this.m_values.containsKey(path)) {
            return this.m_values.get(path);
        }
        Object o = this.getInternal(path.getParent());
        if (o == null) {
            return null;
        }
        return this.getSession().get(o, Path.get(path.getName()));
    }

    public Object get(Path path) {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        if (this.m_position <= 0L) {
            throw new NoRowException(this);
        }
        if (!this.m_rs.isFetched(path)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("path " + path + " is not fetched" + " in signature " + this.m_ds.getSignature()));
            }
            throw new NotFetchedException(this, path);
        }
        return this.getInternal(path);
    }

    public Object get(String path) {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        return this.get(Path.get(path));
    }

    public Object get() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        return this.m_values.get(null);
    }

    public boolean next() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        if (this.m_position == -1L) {
            return false;
        }
        if (this.m_rs == null) {
            this.getSession().flush();
            this.m_rs = this.execute();
        }
        if (this.m_rs.next()) {
            this.m_values = this.m_rs.load(this.getSession());
            ++this.m_position;
            return true;
        }
        this.m_position = -1L;
        this.free();
        return false;
    }

    protected RecordSet execute() {
        return this.getSession().getEngine().execute(this.m_ds.getSignature(), this.m_ds.getExpression());
    }

    public boolean isBeforeFirst() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        return this.m_position == 0L;
    }

    public boolean isFirst() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        return this.m_position == 1L;
    }

    public boolean isAfterLast() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        return this.m_position == -1L;
    }

    public long getPosition() {
        if (this.m_closed) {
            throw new ClosedException(this);
        }
        if (this.m_position > 0L) {
            return this.m_position;
        }
        return 0L;
    }

    public void rewind() {
        this.close();
        this.m_position = 0L;
        this.m_closed = false;
    }

    private void free() {
        if (this.m_rs != null) {
            this.m_rs.close();
            this.m_rs = null;
        }
    }

    public void close() {
        this.free();
        this.m_closed = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

