/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.arsdigita.util.UncheckedWrapperException;
import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.Cursor;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.DuplicateObjectException;
import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.PersistentCollection;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.ProtoException;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.Session;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.TypeException;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Expander
extends Event.Switch {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Expander.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final Session m_ssn;
    private final Collection m_deleting = new HashSet();
    private final List m_deletes = new LinkedList();
    private boolean m_deleted = false;
    private List m_pending = new ArrayList();

    Expander(Session ssn) {
        this.m_ssn = ssn;
    }

    private void addEvent(Event ev) {
        if (this.m_pending == null) {
            throw new IllegalStateException("using expander after call to finish");
        }
        ev.prepare();
        this.m_pending.add(ev);
        ev.log();
        if (ev instanceof DeleteEvent) {
            this.m_deleted = true;
        }
    }

    private void addEvents(List l) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            this.addEvent((Event)it.next());
        }
    }

    final void expand(Event ev) {
        try {
            Session.trace(ev.getName(), new Object[]{ev});
            ev.dispatch(this);
        }
        catch (RuntimeException re) {
            if (re instanceof ProtoException) {
                ProtoException pe = (ProtoException)re;
                if (pe.isInternal()) {
                    throw new UncheckedWrapperException("internal persistence exception", pe);
                }
                pe.setInternal(true);
            }
            throw re;
        }
        finally {
            Session.untrace(ev.getName());
        }
    }

    final List finish() {
        this.addEvents(this.m_deletes);
        List result = this.m_pending;
        this.m_pending = null;
        return result;
    }

    final boolean didDelete() {
        return this.m_deleted;
    }

    public void onCreate(CreateEvent e) {
        Object obj = e.getObject();
        ObjectData od = this.m_ssn.getObjectData(obj);
        if (od == null) {
            od = new ObjectData(this.m_ssn, obj, ObjectData.INFANTILE);
        } else {
            if (!od.isDeleted()) {
                od.dump();
                DuplicateObjectException pe = new DuplicateObjectException(obj);
                pe.setInternal(false);
                throw pe;
            }
            od.setState(ObjectData.INFANTILE);
        }
        Adapter a = this.m_ssn.getAdapter(obj);
        a.setSession(obj, this.m_ssn);
        this.addEvent(e);
        PropertyMap props = a.getProperties(obj);
        Iterator it = props.entrySet().iterator();
        while (it.hasNext()) {
            SetEvent ev;
            Map.Entry me = (Map.Entry)it.next();
            try {
                ev = new SetEvent(this.m_ssn, obj, (Property)me.getKey(), me.getValue());
            }
            catch (TypeException te) {
                te.setInternal(false);
                throw te;
            }
            this.expand(ev);
        }
    }

    public void onDelete(DeleteEvent e) {
        Role role;
        Object obj = e.getObject();
        if (this.m_ssn.isDeleted(obj) || this.isBeingDeleted(obj)) {
            return;
        }
        this.beginDelete(obj);
        ObjectType type = this.m_ssn.getObjectType(obj);
        Iterator it = type.getRoles().iterator();
        while (it.hasNext()) {
            role = (Role)it.next();
            if (!role.isCollection()) continue;
            this.clear(obj, role);
        }
        it = type.getRoles().iterator();
        while (it.hasNext()) {
            role = (Role)it.next();
            if (role.isCollection() || this.m_ssn.get(obj, role) == null) continue;
            SetEvent ev = new SetEvent(this.m_ssn, obj, role, null);
            this.expand(ev);
        }
        this.m_deletes.add(e);
    }

    public void onSet(SetEvent e) {
        Object obj = e.getObject();
        Role role = (Role)e.getProperty();
        Object value = e.getArgument();
        Object old = null;
        if (role.isComponent() || role.isReversable()) {
            old = this.m_ssn.get(obj, role);
        }
        if (role.isReversable()) {
            if (old != null) {
                this.reverseUpdateOld(e, old);
            }
            if (value != null) {
                this.reverseUpdateNew(e);
            }
        }
        this.addEvent(e);
        if (role.isComponent() && old != null && !this.equals(old, value)) {
            this.cascadeDelete(obj, old);
        }
    }

    public void onAdd(AddEvent e) {
        Role role = (Role)e.getProperty();
        if (role.isReversable()) {
            this.reverseUpdateNew(e);
        }
        this.addEvent(e);
    }

    public void onRemove(RemoveEvent e) {
        Role role = (Role)e.getProperty();
        if (role.isReversable()) {
            this.reverseUpdateOld(e, e.getArgument());
        }
        this.addEvent(e);
        if (role.isComponent()) {
            this.cascadeDelete(e.getObject(), e.getArgument());
        }
    }

    private void clear(Object obj, Property prop) {
        PersistentCollection pc = (PersistentCollection)this.m_ssn.get(obj, prop);
        Cursor c = pc.getDataSet().getCursor();
        while (c.next()) {
            this.expand(new RemoveEvent(this.m_ssn, obj, prop, c.get()));
        }
    }

    private void cascadeDelete(Object container, Object containee) {
        boolean me = false;
        if (!this.isBeingDeleted(container)) {
            me = true;
            this.beginDelete(container);
        }
        this.expand(new DeleteEvent(this.m_ssn, containee));
        if (me) {
            this.undelete(container);
        }
    }

    private void reverseUpdateOld(PropertyEvent event, Object target) {
        Object source = event.getObject();
        Role role = (Role)event.getProperty();
        Role rev = role.getReverse();
        if (this.m_ssn.isDeleted(target) || this.isBeingDeleted(target) || role.isComponent()) {
            return;
        }
        if (rev.isCollection()) {
            this.addEvent(new RemoveEvent(this.m_ssn, target, rev, source, event));
        } else {
            this.addEvent(new SetEvent(this.m_ssn, target, rev, null, event));
        }
    }

    private void reverseUpdateNew(PropertyEvent event) {
        Object source = event.getObject();
        Role role = (Role)event.getProperty();
        Object target = event.getArgument();
        Role rev = role.getReverse();
        if (rev.isCollection()) {
            this.addEvent(new AddEvent(this.m_ssn, target, rev, source, event));
        } else {
            Object old = this.m_ssn.get(target, rev);
            if (old != null) {
                if (role.isCollection()) {
                    this.addEvent(new RemoveEvent(this.m_ssn, old, role, target, event));
                } else {
                    this.addEvent(new SetEvent(this.m_ssn, old, role, null, event));
                }
            }
            this.addEvent(new SetEvent(this.m_ssn, target, rev, source, event));
        }
    }

    private void beginDelete(Object obj) {
        this.m_deleting.add(this.m_ssn.getSessionKey(obj));
    }

    private void undelete(Object obj) {
        this.m_deleting.remove(this.m_ssn.getSessionKey(obj));
    }

    private boolean isBeingDeleted(Object obj) {
        return this.m_deleting.contains(this.m_ssn.getSessionKey(obj));
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return this.m_ssn.getSessionKey(o1).equals(this.m_ssn.getSessionKey(o2));
    }
}

