/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.PropertyData;
import com.redhat.persistence.ProtoException;
import com.redhat.persistence.Session;
import com.redhat.persistence.TypeException;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import java.io.PrintWriter;

public abstract class PropertyEvent
extends Event {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/PropertyEvent.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final Property m_prop;
    private final Object m_arg;
    private PropertyData m_pdata;
    private PropertyEvent m_origin;

    PropertyEvent(Session ssn, Object obj, Property prop, Object arg) {
        this(ssn, obj, prop, arg, null);
    }

    PropertyEvent(Session ssn, Object obj, Property prop, Object arg, PropertyEvent origin) {
        super(ssn, obj);
        this.m_prop = prop;
        this.m_arg = arg;
        this.m_origin = origin;
        if (arg != null) {
            ObjectType expected = prop.getType();
            ObjectType actual = this.getSession().getObjectType(arg);
            if (!actual.isSubtypeOf(expected)) {
                throw new TypeException(ProtoException.VALUE, expected, actual, arg);
            }
        }
        if (origin != null) {
            origin.addDependent(this);
            this.addDependent(origin);
        }
    }

    public Property getProperty() {
        return this.m_prop;
    }

    public Object getArgument() {
        return this.m_arg;
    }

    void setPropertyData(PropertyData pdata) {
        this.m_pdata = pdata;
    }

    PropertyData getPropertyData() {
        return this.m_pdata;
    }

    ObjectData getObjectData() {
        if (this.m_pdata == null) {
            return null;
        }
        return this.m_pdata.getObjectData();
    }

    ObjectData getArgumentObjectData() {
        if (this.getArgument() == null) {
            return null;
        }
        return this.getSession().getObjectData(this.getArgument());
    }

    void prepare() {
        PropertyData pd = this.getSession().fetchPropertyData(this.getObject(), this.getProperty());
        if (pd == null) {
            throw new IllegalStateException(this.toString());
        }
        this.setPropertyData(pd);
    }

    void activate() {
        ObjectData arg;
        ObjectData od;
        PropertyEvent prev = this.getSession().getEventStream().getLastEvent(this);
        if (prev != null) {
            prev.addDependent(this);
        }
        this.getSession().getEventStream().add(this);
        if (this.getObjectData().isNubile()) {
            this.getObjectData().setState(ObjectData.AGILE);
        }
        if ((od = this.getObjectData()).isInfantile()) {
            CreateEvent ce = (CreateEvent)this.getSession().getEventStream().getLastEvent(this.getObject());
            ce.addDependent(this);
        }
        if ((arg = this.getArgumentObjectData()) != null && arg.isInfantile()) {
            CreateEvent ce = (CreateEvent)this.getSession().getEventStream().getLastEvent(this.getArgument());
            ce.addDependent(this);
        }
    }

    void sync() {
        this.getSession().getEventStream().remove(this);
    }

    void dump(PrintWriter out) {
        out.print("        ");
        out.print(this.getName());
        out.print("(");
        out.print(this.m_arg);
        out.println(")");
    }

    public String toString() {
        return this.getName() + " " + this.getObject() + "." + this.getProperty().getName() + " " + this.getArgument();
    }
}

