/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.common;

import com.arsdigita.util.ConcurrentDict;

public class Path {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/common/Path.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Path ID_PATH = new Path("id");
    private static final int NO_DOT = -1;
    private static final ConcurrentDict DICT = new ConcurrentDict(new Supplier());
    private Path m_parent;
    private final String m_path;
    private final int m_lastDot;

    private Path(String path) {
        this.m_path = path;
        this.m_lastDot = this.m_path.lastIndexOf(46);
    }

    public static final Path get(String path) {
        if ("id".equals(path)) {
            return ID_PATH;
        }
        return (Path)DICT.get(path);
    }

    public static final Path add(String p1, String p2) {
        return Path.get(Path.concat(p1, p2));
    }

    public static final Path add(Path p1, String p2) {
        return p1 == null ? Path.get(p2) : Path.get(Path.concat(p1.m_path, p2));
    }

    public static final Path add(String p1, Path p2) {
        return p2 == null ? Path.get(p1) : Path.get(Path.concat(p1, p2.m_path));
    }

    public static final Path add(Path p1, Path p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return Path.get(Path.concat(p1.m_path, p2.m_path));
    }

    public static final Path relative(Path base, Path descendent) {
        if (base == null) {
            return descendent;
        }
        return base.getRelative(descendent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getParent() {
        if (this.m_lastDot == -1) {
            return null;
        }
        Path path = this;
        synchronized (path) {
            if (this.m_parent == null) {
                this.m_parent = Path.get(this.m_path.substring(0, this.m_lastDot));
            }
            return this.m_parent;
        }
    }

    public boolean isAncestor(Path path) {
        if (path == null) {
            return false;
        }
        if (this.equals(path)) {
            return true;
        }
        return this.isAncestor(path.getParent());
    }

    private String getRelativeString(Path path) {
        if (path == null) {
            throw new Error("not a child path");
        }
        if (this.equals(path)) {
            return null;
        }
        String parent = this.getRelativeString(path.getParent());
        if (parent == null) {
            return path.getName();
        }
        return Path.concat(parent, path.getName());
    }

    public Path getRelative(Path path) {
        return Path.get(this.getRelativeString(path));
    }

    public String getName() {
        return this.m_path.substring(this.m_lastDot + 1);
    }

    public String getPath() {
        return this.m_path;
    }

    public String toString() {
        return this.m_path;
    }

    private static String concat(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        StringBuffer sb = new StringBuffer(s1.length() + s2.length() + 1);
        sb.append(s1).append(".").append(s2);
        return sb.toString();
    }

    private static class Supplier
    implements ConcurrentDict.EntrySupplier {
        private Supplier() {
        }

        public Object supply(Object key) {
            return new Path((String)key);
        }
    }
}

