/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.Condition;
import com.redhat.persistence.engine.rdbms.CompoundJoin;
import com.redhat.persistence.engine.rdbms.CrossJoin;
import com.redhat.persistence.engine.rdbms.Delete;
import com.redhat.persistence.engine.rdbms.InnerJoin;
import com.redhat.persistence.engine.rdbms.Insert;
import com.redhat.persistence.engine.rdbms.LeftJoin;
import com.redhat.persistence.engine.rdbms.Operation;
import com.redhat.persistence.engine.rdbms.RightJoin;
import com.redhat.persistence.engine.rdbms.SQLWriter;
import com.redhat.persistence.engine.rdbms.Select;
import com.redhat.persistence.engine.rdbms.SimpleJoin;
import com.redhat.persistence.engine.rdbms.StaticJoin;
import com.redhat.persistence.engine.rdbms.Update;
import com.redhat.persistence.metadata.Column;
import java.util.Collection;
import java.util.Iterator;

public class ANSIWriter
extends SQLWriter {
    public void write(Select select) {
        this.write(select.getQuery().generate(this.getEngine().getSession().getRoot()));
    }

    public void write(Insert insert) {
        Column col;
        Collection cols = insert.getColumns();
        this.write("insert into ");
        this.write(insert.getTable().getName());
        this.write("\n(");
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            col = (Column)it.next();
            this.write(col.getName());
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(")\nvalues\n(");
        it = cols.iterator();
        while (it.hasNext()) {
            col = (Column)it.next();
            this.write(insert.get(col));
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(")");
    }

    public void write(Update update) {
        this.write("update ");
        this.write(update.getTable().getName());
        this.write("\nset ");
        Iterator it = update.getColumns().iterator();
        while (it.hasNext()) {
            Column col = (Column)it.next();
            this.write(col.getName());
            this.write(" = ");
            this.write(update.get(col));
            if (!it.hasNext()) continue;
            this.write(",\n    ");
        }
        Condition cond = update.getCondition();
        if (cond != null) {
            this.write("\nwhere ");
            this.write(cond);
        }
    }

    public void write(Delete delete) {
        this.write("delete from ");
        this.write(delete.getTable().getName());
        Condition cond = delete.getCondition();
        if (cond != null) {
            this.write("\nwhere ");
            this.write(cond);
        }
    }

    public void write(StaticJoin join) {
        this.write("(");
        this.write((Operation)join.getStaticOperation());
        this.write(") ");
        this.write(join.getAlias());
    }

    public void write(SimpleJoin join) {
        this.write(join.getTable().getName());
        this.write(" ");
        this.write(join.getAlias());
    }

    void writeCompound(CompoundJoin join) {
        this.write(join.getLeft());
        this.write("\n     ");
        this.write(join.getType().toString());
        this.write(" ");
        this.write(join.getRight());
        Condition cond = join.getCondition();
        if (cond != null) {
            this.write(" on ");
            this.write(cond);
        }
    }

    public void write(InnerJoin join) {
        this.writeCompound(join);
    }

    public void write(LeftJoin join) {
        this.writeCompound(join);
    }

    public void write(RightJoin join) {
        this.writeCompound(join);
    }

    public void write(CrossJoin join) {
        this.writeCompound(join);
    }
}

