/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Qualias;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Value;
import java.util.HashMap;

class Environment {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/Environment.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private RDBMSEngine m_engine;
    private ObjectMap m_om;
    private HashMap m_values = new HashMap();
    private HashMap m_types = new HashMap();

    public Environment(RDBMSEngine engine, ObjectMap om) {
        this.m_engine = engine;
        this.m_om = om;
    }

    RDBMSEngine getEngine() {
        return this.m_engine;
    }

    public boolean contains(Path path) {
        return this.m_values.containsKey(path);
    }

    public void set(Path parameter, Object value) {
        final int[] type = new int[]{RDBMSEngine.getType(this.m_engine.getSession().getRoot(), value)};
        if (this.m_om != null) {
            Mapping m;
            Path path = Path.get(parameter.getPath().substring(1));
            ObjectType ot = this.m_om.getObjectType().getType(path);
            if (ot != null) {
                type[0] = RDBMSEngine.getType(this.m_om.getRoot(), ot.getJavaClass());
            }
            if ((m = this.m_om.getMapping(path)) != null) {
                m.dispatch(new Mapping.Switch(){

                    public void onValue(Value v) {
                        type[0] = v.getColumn().getType();
                    }

                    public void onJoinTo(JoinTo j) {
                    }

                    public void onJoinFrom(JoinFrom j) {
                    }

                    public void onJoinThrough(JoinThrough j) {
                    }

                    public void onStatic(Static s) {
                    }

                    public void onQualias(Qualias q) {
                    }
                });
            }
        }
        this.set(parameter, value, type[0]);
    }

    public void set(Path parameter, Object value, int type) {
        this.m_values.put(parameter, value);
        this.m_types.put(parameter, new Integer(type));
    }

    public Object get(Path parameter) {
        return this.m_values.get(parameter);
    }

    public int getType(Path parameter) {
        return (Integer)this.m_types.get(parameter);
    }

    public String toString() {
        return this.m_values.toString();
    }
}

