/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.arsdigita.util.WrappedError;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

class ResultCycle {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/ResultCycle.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$engine$rdbms$ResultCycle == null ? (class$com$redhat$persistence$engine$rdbms$ResultCycle = ResultCycle.class$("com.redhat.persistence.engine.rdbms.ResultCycle")) : class$com$redhat$persistence$engine$rdbms$ResultCycle));
    private final RDBMSEngine m_engine;
    private ResultSet m_rs;
    private final StatementLifecycle m_cycle;
    private final Throwable m_trace;
    static /* synthetic */ Class class$com$redhat$persistence$engine$rdbms$ResultCycle;

    ResultCycle(RDBMSEngine engine, ResultSet rs, StatementLifecycle cycle) {
        if (rs == null) {
            throw new IllegalArgumentException("null result set");
        }
        this.m_engine = engine;
        this.m_rs = rs;
        this.m_cycle = cycle;
        this.m_trace = LOG.isInfoEnabled() ? new Throwable() : null;
    }

    protected void finalize() {
        if (this.m_rs != null) {
            LOG.warn((Object)("ResultSet  was not closed.  Turn on INFO logging for " + this.getClass() + " to see the stack trace for this ResultSet."));
            if (this.m_trace != null) {
                LOG.info((Object)"The ResultSet was created at: ", this.m_trace);
            }
            this.m_rs = null;
        }
    }

    public ResultSet getResultSet() {
        return this.m_rs;
    }

    public StatementLifecycle getLifecycle() {
        return this.m_cycle;
    }

    public boolean next() {
        if (this.m_rs == null) {
            throw new IllegalStateException("result set closed");
        }
        try {
            if (this.m_cycle != null) {
                this.m_cycle.beginNext();
            }
            boolean result = this.m_rs.next();
            if (this.m_cycle != null) {
                this.m_cycle.endNext(result);
            }
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (SQLException e) {
            if (this.m_cycle != null) {
                this.m_cycle.endNext(e);
            }
            throw new WrappedError(e);
        }
    }

    public void close() {
        if (this.m_rs == null) {
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Closing Statement because resultset was closed.");
            }
            if (this.m_cycle != null) {
                this.m_cycle.beginClose();
            }
            this.m_rs.getStatement().close();
            this.m_rs.close();
            if (this.m_cycle != null) {
                this.m_cycle.endClose();
            }
            this.m_rs = null;
            this.m_engine.release();
        }
        catch (SQLException e) {
            if (this.m_cycle != null) {
                this.m_cycle.endClose(e);
            }
            throw new WrappedError(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

