/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;

public class ForeignKey
extends Constraint {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/ForeignKey.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private UniqueKey m_key;
    private boolean m_cascade;

    public ForeignKey(Table table, String name, Column[] columns, UniqueKey key, boolean cascade) {
        super(table, name, columns);
        Column[] uk;
        if (key == null) {
            throw new IllegalArgumentException("Unique key cannot be null.");
        }
        this.m_key = key;
        this.m_cascade = cascade;
        Column[] fk = this.getColumns();
        if (fk.length != (uk = this.m_key.getColumns()).length) {
            throw new IllegalArgumentException("Foreign columns don't match unique key: fk = " + this.getSQL() + " uk = " + key.getSQL());
        }
        for (int i = 0; i < fk.length; ++i) {
            if (fk[i].getType() == Integer.MIN_VALUE) {
                fk[i].setType(uk[i].getType());
                fk[i].setSize(uk[i].getSize());
                continue;
            }
            if (fk[i].getType() == uk[i].getType() || fk[i].getSize() == uk[i].getSize()) continue;
            throw new IllegalArgumentException("Foreign columns don't match unique key.");
        }
        this.m_key.addForeignKey(this);
    }

    public ForeignKey(Table table, String name, Column[] columns, UniqueKey key) {
        this(table, name, columns, key, false);
    }

    public ForeignKey(String name, Column from, Column to, boolean cascade) {
        this(from.getTable(), name, new Column[]{from}, to.getTable().getUniqueKey(new Column[]{to}), cascade);
    }

    public ForeignKey(String name, Column from, Column to) {
        this(name, from, to, false);
    }

    public UniqueKey getUniqueKey() {
        return this.m_key;
    }

    public boolean isNullable() {
        Column[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public boolean isDeferred() {
        return true;
    }

    String getSuffix() {
        return "_f";
    }

    String getColumnSQL() {
        StringBuffer result = new StringBuffer();
        result.append("        ");
        if (this.getName() != null) {
            result.append("constraint " + this.getName() + "\n          ");
        }
        result.append("references ");
        result.append(this.m_key.getTable().getName());
        result.append(this.m_key.getColumnList());
        if (this.m_cascade) {
            result.append(" on delete cascade");
        }
        return result.toString();
    }

    public String getSQL() {
        StringBuffer result = new StringBuffer();
        result.append("    ");
        if (this.getName() != null) {
            result.append("constraint " + this.getName() + " ");
        }
        result.append("foreign key ");
        result.append(this.getColumnList());
        result.append("\n      references ");
        result.append(this.m_key.getTable().getName());
        result.append(this.m_key.getColumnList());
        if (this.m_cascade) {
            result.append(" on delete cascade");
        }
        return result.toString();
    }
}

