/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Element;
import com.redhat.persistence.metadata.Mist;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.UnionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ObjectType
extends Element {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/ObjectType.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final Model m_model;
    private final String m_name;
    private final String m_qualifiedName;
    private Class m_class;
    private final ObjectType m_super;
    private final Mist m_properties = new Mist(this);
    private final ArrayList m_immediates = new ArrayList();
    private final ArrayList m_roles = new ArrayList();
    private final List m_allProps;
    private final List m_allRoles;
    private List m_allImmediates;

    public ObjectType(Model model, String name, ObjectType supertype) {
        this.m_model = model;
        this.m_name = name;
        this.m_super = supertype;
        this.m_qualifiedName = this.m_model == null ? this.m_name : this.m_model.getQualifiedName() + "." + this.m_name;
        if (this.m_super == null) {
            this.m_allProps = Collections.unmodifiableList(this.m_properties);
            this.m_allRoles = Collections.unmodifiableList(this.m_roles);
        } else {
            this.m_allProps = Collections.unmodifiableList(new UnionList(this.m_properties, this.m_super.m_allProps));
            this.m_allRoles = Collections.unmodifiableList(new UnionList(this.m_roles, this.m_super.m_allRoles));
        }
        this.m_allImmediates = null;
    }

    public Root getRoot() {
        return (Root)this.getParent();
    }

    public Model getModel() {
        return this.m_model;
    }

    public String getName() {
        return this.m_name;
    }

    public void setJavaClass(Class klass) {
        this.m_class = klass;
    }

    public Class getJavaClass() {
        return this.m_class;
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public ObjectType getSupertype() {
        return this.m_super;
    }

    public boolean hasDeclaredProperty(String name) {
        return this.m_properties.containsKey(name);
    }

    public boolean hasProperty(String name) {
        if (this.hasDeclaredProperty(name)) {
            return true;
        }
        if (this.m_super != null) {
            return this.m_super.hasProperty(name);
        }
        return false;
    }

    public boolean isKeyProperty(String name) {
        return this.isKeyProperty(this.getProperty(name));
    }

    public boolean isKeyProperty(Property prop) {
        return this.getKeyProperties().contains(prop);
    }

    public void addProperty(Property prop) {
        this.m_properties.add(prop);
        if (prop instanceof Role) {
            this.m_roles.add(prop);
        }
    }

    public Collection getDeclaredProperties() {
        return this.m_properties;
    }

    public Property getDeclaredProperty(String name) {
        return (Property)this.m_properties.get(name);
    }

    public Collection getProperties() {
        return this.m_allProps;
    }

    public Property getProperty(String name) {
        if (this.hasDeclaredProperty(name)) {
            return this.getDeclaredProperty(name);
        }
        if (this.m_super != null) {
            return this.m_super.getProperty(name);
        }
        return null;
    }

    public Property getProperty(Path path) {
        if (path.getParent() == null) {
            return this.getProperty(path.getName());
        }
        Property prop = this.getProperty(path.getParent());
        if (prop == null) {
            return null;
        }
        ObjectType type = prop.getType();
        return type.getProperty(path.getName());
    }

    public ObjectType getType(Path path) {
        if (path == null) {
            return this;
        }
        Property prop = this.getProperty(path);
        if (prop == null) {
            return null;
        }
        return prop.getType();
    }

    public boolean exists(Path path) {
        return this.getProperty(path) != null;
    }

    public boolean isKey(Path path) {
        Property prop = this.getProperty(path);
        if (this.getRoot() == null) {
            return false;
        }
        ObjectMap map = this.getRoot().getObjectMap(prop.getContainer());
        return map.getKeyProperties().contains(prop);
    }

    public boolean isImmediate(Property prop) {
        return this.getImmediateProperties().contains(prop);
    }

    public boolean isImmediate(Path path) {
        Property prop = this.getProperty(path);
        return prop.getContainer().isImmediate(prop);
    }

    public List getKeyProperties() {
        if (this.getRoot() == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectMap map = this.getRoot().getObjectMap(this);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getKeyProperties();
    }

    public List getImmediateProperties() {
        List keys;
        if (this.m_allImmediates == null && (keys = this.getKeyProperties()).size() > 0) {
            this.m_allImmediates = this.m_super == null ? Collections.unmodifiableList(new UnionList(keys, this.m_immediates)) : this.m_super.getImmediateProperties();
        }
        return this.m_allImmediates == null ? this.m_allProps : this.m_allImmediates;
    }

    public void addImmediateProperty(Property prop) {
        if (prop.getContainer() != this) {
            throw new IllegalArgumentException("property doesn't belong to this type: " + prop);
        }
        if (this.m_super != null) {
            throw new IllegalArgumentException("derived object types cannot have immediate properties");
        }
        if (!this.m_immediates.contains(prop)) {
            this.m_immediates.add(prop);
        }
    }

    public boolean isKeyed() {
        if (this.getRoot() == null) {
            return false;
        }
        ObjectMap map = this.getRoot().getObjectMap(this);
        if (map == null) {
            return false;
        }
        return map.getKeyProperties().size() != 0;
    }

    public boolean hasKey() {
        return this.isKeyed();
    }

    public boolean isCompound() {
        return this.getProperties().size() != 0;
    }

    public Collection getRoles() {
        return this.m_allRoles;
    }

    public ObjectType getBasetype() {
        if (this.m_super == null) {
            return this;
        }
        return this.m_super.getBasetype();
    }

    public boolean isSubtypeOf(String name) {
        return this.isSubtypeOf(this.getRoot().getObjectType(name));
    }

    public boolean isSubtypeOf(ObjectType type) {
        if (this.equals(type)) {
            return true;
        }
        if (this.m_super != null) {
            return this.m_super.isSubtypeOf(type);
        }
        return false;
    }

    Object getElementKey() {
        return this.getQualifiedName();
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

