/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.oql.BinaryCondition;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.QValue;
import java.util.ArrayList;
import java.util.List;

public class Equals
extends BinaryCondition {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Equals.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Equals(Expression left, Expression right) {
        super(left, right);
    }

    void frame(Generator gen) {
        super.frame(gen);
        if (!gen.hasFrame(this.m_left) || !gen.hasFrame(this.m_right)) {
            return;
        }
        QFrame left = gen.getFrame(this.m_left);
        QFrame right = gen.getFrame(this.m_right);
        Equals.equate(gen, this, left, right);
    }

    static void equate(Generator gen, Expression expr, QFrame left, QFrame right) {
        Expression lexpr = left.getExpression();
        Expression rexpr = right.getExpression();
        List lvals = left.getValues();
        List rvals = right.getValues();
        if (lvals.size() != rvals.size()) {
            throw new IllegalStateException("cardinality mismatch\nleft: " + lvals + "\nrvals: " + rvals + "\nleft: " + lexpr + "\nright: " + rexpr);
        }
        List lnull = gen.getNull(lexpr);
        List rnull = gen.getNull(rexpr);
        List lnonnull = gen.getNonNull(lexpr);
        List rnonnull = gen.getNonNull(rexpr);
        for (int i = 0; i < lvals.size(); ++i) {
            QValue lval = (QValue)lvals.get(i);
            QValue rval = (QValue)rvals.get(i);
            gen.addEquality(expr, lval, rval);
            if (lnull.contains(lval)) {
                gen.addNull(expr, rval);
            }
            if (lnonnull.contains(lval)) {
                gen.addNonNull(expr, rval);
            }
            if (rnull.contains(rval)) {
                gen.addNull(expr, lval);
            }
            if (!rnonnull.contains(rval)) continue;
            gen.addNonNull(expr, lval);
        }
        gen.addSufficient(expr);
    }

    Code emit(Generator gen) {
        return Equals.emit(gen, this.m_left, this.m_right);
    }

    static Code emit(Generator gen, Expression lexpr, Expression rexpr) {
        if (gen.hasFrame(lexpr) && gen.hasFrame(rexpr)) {
            QFrame lframe = gen.getFrame(lexpr);
            QFrame rframe = gen.getFrame(rexpr);
            if (!lframe.isSelect() && !rframe.isSelect()) {
                List lvals = lframe.getValues();
                List rvals = rframe.getValues();
                if (lvals.size() != rvals.size()) {
                    throw new IllegalStateException("signature missmatch: " + lvals + ", " + rvals);
                }
                ArrayList<Code> conds = new ArrayList<Code>();
                for (int i = 0; i < lvals.size(); ++i) {
                    QValue l = (QValue)lvals.get(i);
                    QValue r = (QValue)rvals.get(i);
                    Code lsql = l.emit();
                    Code rsql = r.emit();
                    if (lsql.isNull() ? !r.isNullable() : rsql.isNull() && !l.isNullable()) {
                        return Code.FALSE;
                    }
                    if (lsql.equals(rsql)) continue;
                    conds.add(Equals.emit(lsql, rsql));
                }
                if (conds.isEmpty()) {
                    return Code.TRUE;
                }
                return Code.join(conds, " and ");
            }
        }
        Code lsql = lexpr.emit(gen);
        Code rsql = rexpr.emit(gen);
        if (lsql.getBindings().isEmpty() && lsql.equals(rsql)) {
            return Code.TRUE;
        }
        return Equals.emit(lsql, rsql);
    }

    private static Code emit(Code left, Code right) {
        if (left.isNull()) {
            return right.add(" is ").add(left);
        }
        if (right.isNull()) {
            return left.add(" is ").add(right);
        }
        return left.add(" = ").add(right);
    }

    String getOperator() {
        return "==";
    }
}

