/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.pdl.ErrorReport;
import com.redhat.persistence.pdl.nodes.FileNd;
import com.redhat.persistence.pdl.nodes.ImportNd;
import com.redhat.persistence.pdl.nodes.Node;
import com.redhat.persistence.pdl.nodes.ObjectTypeNd;
import com.redhat.persistence.pdl.nodes.TypeNd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class SymbolTable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/SymbolTable.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private HashMap m_types = new HashMap();
    private ArrayList m_order = new ArrayList();
    private HashMap m_resolutions = new HashMap();
    private HashMap m_emitted = new HashMap();
    private ErrorReport m_report;
    private Root m_root;

    public SymbolTable(ErrorReport report, Root root) {
        this.m_report = report;
        this.m_root = root;
    }

    public void define(ObjectTypeNd type) {
        if (this.isDefined(type.getQualifiedName())) {
            ObjectTypeNd original = this.getObjectType(type.getQualifiedName());
            if (original == null) {
                this.m_report.fatal(type, "already loaded");
            } else {
                this.m_report.fatal(type, "duplicate type definition for " + type.getQualifiedName() + ", original definition: " + original.getLocation());
            }
        } else {
            this.m_types.put(type.getQualifiedName(), type);
            this.m_order.add(type);
        }
    }

    public String resolve(TypeNd type) {
        String result = null;
        if (type.isQualified()) {
            result = type.getQualifiedName();
        } else {
            FileNd file = type.getFile();
            Collection imps = file.getImports();
            ArrayList<String> qnames = new ArrayList<String>();
            Iterator it = imps.iterator();
            while (it.hasNext()) {
                ImportNd imp = (ImportNd)it.next();
                String qname = imp.qualify(type);
                if (qname == null || !this.isDefined(qname)) continue;
                qnames.add(qname);
            }
            if (qnames.size() == 0) {
                String[] special = new String[]{file.getModel().getName() + "." + type.getName(), "global." + type.getName()};
                for (int i = 0; i < special.length; ++i) {
                    if (!this.isDefined(special[i])) continue;
                    result = special[i];
                    break;
                }
            } else {
                if (qnames.size() > 1) {
                    this.m_report.fatal(type, "ambiguous symbol, resolves to: " + qnames);
                    return null;
                }
                result = (String)qnames.get(0);
            }
        }
        if (result == null) {
            this.m_report.fatal(type, "unresolved symbol: " + type.getName());
        } else {
            this.m_resolutions.put(type, result);
        }
        return result;
    }

    private boolean isDefined(String qualifiedName) {
        return this.m_types.containsKey(qualifiedName) || this.m_emitted.containsKey(qualifiedName);
    }

    private ObjectTypeNd getObjectType(String qualifiedName) {
        return (ObjectTypeNd)this.m_types.get(qualifiedName);
    }

    public String lookup(TypeNd type) {
        return (String)this.m_resolutions.get(type);
    }

    public boolean sort() {
        Iterator it;
        HashSet<Object> defined = new HashSet<Object>();
        defined.addAll(this.m_emitted.keySet());
        ArrayList undefined = new ArrayList();
        undefined.addAll(this.m_order);
        ArrayList<ObjectTypeNd> nwo = new ArrayList<ObjectTypeNd>();
        HashSet<ObjectTypeNd> circular = new HashSet<ObjectTypeNd>();
        ArrayList<ObjectTypeNd> circOrd = new ArrayList<ObjectTypeNd>();
        while (undefined.size() != 0) {
            int before = defined.size();
            it = undefined.iterator();
            while (it.hasNext()) {
                ObjectTypeNd type = (ObjectTypeNd)it.next();
                if (!circular.contains(type) && this.isCircular(type)) {
                    circular.add(type);
                    circOrd.add(type);
                }
                if (type.getExtends() != null && !defined.contains(this.lookup(type.getExtends()))) continue;
                defined.add(type.getQualifiedName());
                nwo.add(type);
                it.remove();
            }
            if (defined.size() > before) continue;
        }
        it = circOrd.iterator();
        while (it.hasNext()) {
            ObjectTypeNd ot = (ObjectTypeNd)it.next();
            this.m_report.fatal(ot, "circular type dependency: " + ot.getQualifiedName());
        }
        if (undefined.size() > 0) {
            return false;
        }
        this.m_order = nwo;
        return true;
    }

    private boolean isCircular(ObjectTypeNd type) {
        return this.isCircular(type, type, new HashSet());
    }

    private boolean isCircular(ObjectTypeNd type, ObjectTypeNd start, HashSet visited) {
        if (visited.contains(type)) {
            return false;
        }
        if (type.getExtends() == null) {
            return false;
        }
        ObjectTypeNd sup = this.getObjectType(this.lookup(type.getExtends()));
        if (sup == null) {
            return false;
        }
        if (sup.equals(start)) {
            return true;
        }
        visited.add(type);
        return this.isCircular(sup, start, visited);
    }

    public Collection getObjectTypes() {
        return this.m_order;
    }

    public void addEmitted(ObjectType type) {
        this.m_emitted.put(type.getQualifiedName(), type);
    }

    public ObjectType getEmitted(String qname) {
        return (ObjectType)this.m_emitted.get(qname);
    }

    public ObjectType getEmitted(ObjectTypeNd type) {
        return (ObjectType)this.m_emitted.get(type.getQualifiedName());
    }

    public ObjectType getEmitted(TypeNd type) {
        return this.getEmitted(this.lookup(type));
    }

    public void emit() {
        Iterator it = this.m_order.iterator();
        while (it.hasNext()) {
            ObjectTypeNd ot = (ObjectTypeNd)it.next();
            ObjectType sup = null;
            if (ot.getExtends() != null) {
                sup = this.getEmitted(ot.getExtends());
            }
            ObjectType type = new ObjectType(Model.getInstance(ot.getFile().getModel().getName()), ot.getName().getName(), sup);
            this.addEmitted(type);
            this.setLocation(type, ot);
        }
    }

    final void setLocation(Object element, Node nd) {
        this.m_root.setLocation(element, nd.getFile().getName(), nd.getLine(), nd.getColumn());
    }
}

