/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.URLRewriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FormData
implements Map,
Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/FormData.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private HashMap m_parameterDataValues = new HashMap();
    private LinkedList m_formErrors;
    private FormModel m_model;
    private Locale m_locale;
    private boolean m_isTransformed;
    private boolean m_isValid;
    private boolean m_isSubmission;

    private FormData() {
    }

    public FormData(FormModel model, HttpServletRequest request) throws FormProcessException {
        this(model, request, Locale.getDefault());
    }

    public FormData(FormModel model, HttpServletRequest request, boolean isSubmission) throws FormProcessException {
        this(model, request, Locale.getDefault(), isSubmission);
    }

    public FormData(FormModel model, HttpServletRequest request, boolean isSubmission, FormData fallback) throws FormProcessException {
        this(model, request, Locale.getDefault(), isSubmission, fallback);
    }

    public FormData(FormModel model, HttpServletRequest request, Locale locale) throws FormProcessException {
        this(model, request, locale, request.getParameter(model.getMagicTagName()) != null);
    }

    public FormData(FormModel model, HttpServletRequest request, Locale locale, boolean isSubmission) throws FormProcessException {
        this(model, request, locale, isSubmission, null);
    }

    public FormData(FormModel model, HttpServletRequest request, Locale locale, boolean isSubmission, FormData fallback) throws FormProcessException {
        Assert.assertNotNull(model, "FormModel");
        Assert.assertNotNull(request, "HttpServletRequest");
        Assert.assertNotNull(locale, "Locale");
        this.m_locale = locale;
        this.m_model = model;
        this.m_isTransformed = false;
        this.m_isValid = this.m_isSubmission = isSubmission;
        this.createParameterData(request, fallback);
        Iterator params = URLRewriter.getGlobalParams(request).iterator();
        while (params.hasNext()) {
            ParameterData param = (ParameterData)params.next();
            this.setParameter(param.getModel().getName(), param);
        }
    }

    public void validate(PageState state) {
        if (this.isValid()) {
            return;
        }
        this.m_isValid = true;
        if (this.m_formErrors != null) {
            this.m_formErrors.clear();
        }
        this.m_model.validate(state, this);
    }

    public void forceValidate(PageState state) {
        this.invalidate();
        this.validate(state);
    }

    public void addError(String message) {
        this.addError(new GlobalizedMessage(message));
    }

    public void addError(GlobalizedMessage message) {
        if (this.m_formErrors == null) {
            this.m_formErrors = new LinkedList();
        }
        this.m_formErrors.add(message);
        this.m_isValid = false;
    }

    public void addError(String name, String message) {
        if (!this.m_parameterDataValues.containsKey(name)) {
            throw new IllegalArgumentException("Attempt to set Error in Non-Existant ParameterData");
        }
        ParameterData parameter = (ParameterData)this.m_parameterDataValues.get(name);
        parameter.addError(message);
        this.m_isValid = false;
    }

    public void addError(String name, GlobalizedMessage message) {
        if (!this.m_parameterDataValues.containsKey(name)) {
            throw new IllegalArgumentException("Attempt to set Error in Non-Existant ParameterData");
        }
        ParameterData parameter = (ParameterData)this.m_parameterDataValues.get(name);
        parameter.addError(message);
        this.m_isValid = false;
    }

    public Iterator getErrors(String name) {
        ParameterData parameter = (ParameterData)this.m_parameterDataValues.get(name);
        if (parameter == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return parameter.getErrors();
    }

    public Iterator getErrors() {
        if (this.m_formErrors == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.m_formErrors.iterator();
    }

    public Iterator getAllErrors() {
        return new Iterator(){
            private Iterator params;
            private Iterator paramErrors;
            private Iterator formErrors;
            {
                this.params = FormData.this.m_parameterDataValues.values().iterator();
                this.paramErrors = Collections.EMPTY_LIST.iterator();
                this.formErrors = FormData.this.getErrors();
            }

            private void seekToNextError() {
                while (!this.paramErrors.hasNext() && this.params.hasNext()) {
                    this.paramErrors = ((ParameterData)this.params.next()).getErrors();
                }
            }

            public boolean hasNext() {
                this.seekToNextError();
                return this.paramErrors.hasNext() || this.formErrors.hasNext();
            }

            public Object next() throws NoSuchElementException {
                this.seekToNextError();
                if (this.paramErrors.hasNext()) {
                    return this.paramErrors.next();
                }
                return this.formErrors.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ParameterData getParameter(String name) {
        return (ParameterData)this.m_parameterDataValues.get(name);
    }

    public void setParameter(String name, ParameterData value) {
        this.m_parameterDataValues.put(name, value);
    }

    public final Collection getParameters() {
        return this.m_parameterDataValues.values();
    }

    public final boolean isSubmission() {
        return this.m_isSubmission;
    }

    public final boolean isTransformed() {
        return this.m_isTransformed;
    }

    public final boolean isValid() {
        return this.m_isValid;
    }

    public void setInvalid() {
        this.invalidate();
    }

    public final void invalidate() {
        this.m_isValid = false;
    }

    private void setParameterValue(String name, Object value) {
        ParameterData parameter = (ParameterData)this.m_parameterDataValues.get(name);
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter " + name + " does not exist");
        }
        parameter.setValue(value);
    }

    private void createParameterData(HttpServletRequest request, FormData fallback) throws FormProcessException {
        Iterator parameters = this.m_model.getParameters();
        while (parameters.hasNext()) {
            ParameterData parameterData;
            ParameterModel parameterModel = (ParameterModel)parameters.next();
            Object defaultValue = null;
            if (fallback != null && (parameterData = fallback.getParameter(parameterModel.getName())) != null) {
                defaultValue = parameterData.getValue();
            }
            parameterData = parameterModel.createParameterData(request, defaultValue, this.isSubmission());
            Assert.assertNotNull(parameterData);
            this.setParameter(parameterModel.getName(), parameterData);
        }
        this.m_isTransformed = true;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.m_parameterDataValues.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        return this.m_parameterDataValues.entrySet();
    }

    public Object get(Object key) throws IllegalArgumentException {
        ParameterData p = this.getParameter((String)key);
        if (p != null) {
            return p.getValue();
        }
        throw new IllegalArgumentException("parameter " + key + " not part of the form model");
    }

    public Object get(ParameterModel m) {
        ParameterData p = this.getParameter(m.getName());
        return p.getModel() == m ? p : null;
    }

    public Date getDate(Object key) {
        return (Date)this.get(key);
    }

    public Integer getInteger(Object key) {
        return (Integer)this.get(key);
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public boolean isEmpty() {
        return this.m_parameterDataValues.isEmpty();
    }

    public Set keySet() {
        return this.m_parameterDataValues.keySet();
    }

    public Object put(Object key, Object value) {
        Object previousValue = this.get(key);
        this.setParameterValue((String)key, value);
        this.m_isValid = false;
        return previousValue;
    }

    public void putAll(Map t) {
        Iterator i = t.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.setParameterValue(key, t.get(key));
        }
        this.m_isValid = false;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.m_parameterDataValues.size();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        FormData result = (FormData)super.clone();
        result.m_parameterDataValues = new HashMap();
        Iterator i = this.m_parameterDataValues.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            ParameterData val = (ParameterData)this.m_parameterDataValues.get(key);
            result.m_parameterDataValues.put(key, val.clone());
        }
        if (this.m_formErrors != null) {
            result.m_formErrors = (LinkedList)this.m_formErrors.clone();
        }
        return result;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.getAllErrors();
        while (i.hasNext()) {
            s.append(i.next()).append(System.getProperty("line.separator"));
        }
        return s.toString();
    }

    public String asString() {
        String newLine = System.getProperty("line.separator");
        StringBuffer to = new StringBuffer();
        to.append(super.toString() + " = {" + newLine);
        to.append("m_parameterDataValues = ").append(this.m_parameterDataValues).append(",").append(newLine);
        to.append("m_formErrors = " + this.m_formErrors + "," + newLine);
        to.append("m_model = " + this.m_model + "," + newLine);
        to.append("m_locale = " + this.m_locale + "," + newLine);
        to.append("m_isTransformed = " + this.m_isTransformed + "," + newLine);
        to.append("m_isValid = " + this.m_isValid + "," + newLine);
        to.append("m_isSubmission = " + this.m_isSubmission + newLine);
        to.append("}");
        return to.toString();
    }
}

