/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridTableModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.util.LockableImpl;

public class Grid
extends Table {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Grid.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_cols;

    public Grid(ListModelBuilder builder, int numCols) {
        super((TableModelBuilder)new GridModelBuilder(builder, numCols), new DefaultTableColumnModel());
        this.m_cols = numCols;
        this.setHeader(null);
        TableColumnModel cols = this.getColumnModel();
        for (int i = 0; i < numCols; ++i) {
            cols.add(new TableColumn(i));
        }
        this.setClassAttr("grid");
        this.setWidth("100%");
        this.setDefaultCellRenderer(new DefaultTableCellRenderer(true){

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                if (value == null) {
                    return new Label("&nbsp;", false);
                }
                return super.getComponent(table, state, value, isSelected, key, row, column);
            }
        });
    }

    public void setModelBuilder(ListModelBuilder builder) {
        super.setModelBuilder(new GridModelBuilder(builder, this.getColumnCount()));
    }

    public int getColumnCount() {
        return this.m_cols;
    }

    private static class GridModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ListModelBuilder m_builder;
        private int m_cols;

        public GridModelBuilder(ListModelBuilder builder, int cols) {
            this.m_builder = builder;
            this.m_cols = cols;
        }

        public TableModel makeModel(Table t, PageState s) {
            List l = new List();
            ListModel m = this.m_builder.makeModel(l, s);
            return new GridTableModel(m, this.m_cols);
        }

        public void lock() {
            this.m_builder.lock();
            super.lock();
        }
    }
}

