/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.table.TableModel;
import java.util.ArrayList;

public class GridTableModel
implements TableModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/GridTableModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ListModel m_items;
    private int m_colHeight;
    private int m_cols;
    private int m_size;
    private int m_index;
    private Object[] m_elements;
    private Object[] m_keys;

    public GridTableModel(ListModel items, int cols) {
        this.m_items = items;
        this.m_cols = cols;
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        this.m_size = 0;
        while (this.m_items.next()) {
            elements.add(this.m_items.getElement());
            keys.add(this.m_items.getKey());
            ++this.m_size;
        }
        this.m_elements = elements.toArray();
        this.m_keys = keys.toArray();
        this.m_colHeight = this.m_size / this.m_cols;
        if (this.m_colHeight * this.m_cols < this.m_size) {
            ++this.m_colHeight;
        }
        this.m_index = -1;
    }

    public int getColumnCount() {
        return this.m_cols;
    }

    public boolean nextRow() {
        if (this.m_index >= this.m_colHeight - 1) {
            return false;
        }
        ++this.m_index;
        return true;
    }

    private Object safeGet(Object[] a, int columnIndex) {
        int i = this.m_index + this.m_colHeight * columnIndex;
        if (i >= a.length) {
            return null;
        }
        return a[i];
    }

    public Object getElementAt(int columnIndex) {
        return this.safeGet(this.m_elements, columnIndex);
    }

    public Object getKeyAt(int columnIndex) {
        return this.safeGet(this.m_keys, columnIndex);
    }
}

