/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class Label
extends BlockStylable
implements Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Label.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String NO_LABEL = "";
    public static final String BOLD = "b";
    public static final String ITALIC = "i";
    private GlobalizedMessage m_label;
    private RequestLocal m_requestLabel = new RequestLocal();
    private String m_fontWeight;
    private boolean m_escaping;
    private PrintListener m_printListener;

    public Label() {
        this(NO_LABEL);
    }

    public Label(String label) {
        this(label, true);
    }

    public Label(String label, boolean escaping) {
        this.setLabel(label);
        this.setOutputEscaping(escaping);
    }

    public Label(GlobalizedMessage label) {
        this(label, true);
    }

    public Label(GlobalizedMessage label, boolean escaping) {
        this.setLabel(label);
        this.setOutputEscaping(escaping);
    }

    public Label(PrintListener l) {
        this();
        this.addPrintListener(l);
    }

    public Label(String label, String fontWeight) {
        this(label, true);
        this.m_fontWeight = fontWeight;
    }

    public String getLabel(PageState state) {
        return (String)this.getGlobalizedMessage(state).localize(state.getRequest());
    }

    public String getLabel() {
        return this.getGlobalizedMessage().getKey();
    }

    public GlobalizedMessage getGlobalizedMessage() {
        return this.getGlobalizedMessage(null);
    }

    public GlobalizedMessage getGlobalizedMessage(PageState state) {
        GlobalizedMessage dynlabel;
        if (state != null && (dynlabel = (GlobalizedMessage)this.m_requestLabel.get(state)) != null) {
            return dynlabel;
        }
        return this.m_label;
    }

    public void setLabel(String label) {
        this.setLabel(label, null);
    }

    public void setLabel(String label, PageState state) {
        if (label == null || label.length() == 0) {
            label = " ";
        }
        this.setLabel(new GlobalizedMessage(label), state);
    }

    public void setLabel(GlobalizedMessage label, PageState state) {
        if (state == null) {
            Assert.assertNotLocked(this);
            this.m_label = label;
        } else {
            this.m_requestLabel.set(state, (Object)label);
        }
    }

    public void setLabel(GlobalizedMessage label) {
        this.setLabel(label, null);
    }

    public final boolean getOutputEscaping() {
        return this.m_escaping;
    }

    public final void setOutputEscaping(boolean escaping) {
        this.m_escaping = escaping;
    }

    public final String getFontWeight() {
        return this.m_fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        Assert.assertNotLocked(this);
        this.m_fontWeight = fontWeight;
    }

    public void addPrintListener(PrintListener listener) throws IllegalStateException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null");
        }
        if (this.m_printListener != null) {
            throw new IllegalStateException("Too many listeners. Can only have one");
        }
        this.m_printListener = listener;
    }

    public void removePrintListener(PrintListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        if (listener != this.m_printListener) {
            throw new IllegalArgumentException("listener is not registered with this widget");
        }
        this.m_printListener = null;
    }

    public void generateXML(PageState state, Element parent) {
        if (!this.isVisible(state)) {
            return;
        }
        Label target = this.firePrintEvent(state);
        Element label = parent.newChildElement("bebop:label", "http://www.arsdigita.com/bebop/1.0");
        target.exportAttributes(label);
        String weight = target.getFontWeight();
        if (weight != null && weight.length() > 0) {
            label.addAttribute("weight", weight);
        }
        if (!target.m_escaping) {
            label.addAttribute("escape", "yes");
        } else {
            label.addAttribute("escape", "no");
        }
        label.setText(target.getLabel(state));
    }

    protected Label firePrintEvent(PageState state) {
        Label l = this;
        if (this.m_printListener != null) {
            try {
                l = (Label)this.clone();
                this.m_printListener.prepare(new PrintEvent(this, state, l));
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Couldn't clone Label for PrintListener. This probably indicates a serious programming error: " + e.getMessage());
            }
        }
        return l;
    }
}

