/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageErrorDisplay;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BitSetParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

public class Page
extends BlockStylable
implements Container {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Page.java#22 $by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$Page == null ? (class$com$arsdigita$bebop$Page = Page.class$("com.arsdigita.bebop.Page")) : class$com$arsdigita$bebop$Page));
    private static final String DELIMITER = ".";
    private static final String COMPONENT_PREFIX = "bbp.";
    private static final String INTERNAL = "bbp.";
    static final String SELECTED = "bbp.s";
    static final String CONTROL_EVENT = "bbp.e";
    static final String CONTROL_VALUE = "bbp.v";
    static final Collection CONTROL_EVENT_KEYS = new ArrayList(3);
    static final String INVISIBLE = "bbp.i";
    private Map m_componentMap;
    private List m_components;
    private Map m_componentParameterMap = new HashMap();
    private FormModel m_stateModel;
    protected Container m_panel;
    private List m_actionListeners = new LinkedList();
    private List m_requestListeners = new LinkedList();
    private Label m_title;
    private RequestLocal m_currentTitle;
    private List m_clientStylesheets;
    private StringParameter m_selected;
    private StringParameter m_controlEvent;
    private StringParameter m_controlValue;
    protected BitSet m_invisible;
    private Component m_errorDisplay;
    private boolean m_finished = false;
    private boolean m_useHttpSession = false;
    private static String NAME;
    static /* synthetic */ Class class$com$arsdigita$bebop$Page;

    public boolean isUsingHttpSession() {
        return this.m_useHttpSession;
    }

    public void setUsingHttpSession(boolean b) {
        this.m_useHttpSession = b;
    }

    public Page(String title, Container panel) {
        this(new Label(title), panel);
    }

    public Page(Label title, Container panel) {
        this.m_panel = panel;
        this.m_clientStylesheets = new ArrayList();
        this.m_components = new ArrayList();
        this.m_componentMap = new HashMap();
        this.setErrorDisplay(new PageErrorDisplay());
        this.setTitle(title);
        this.m_currentTitle = new RequestLocal(){

            protected Object initialValue(PageState state) {
                return Page.this.m_title.firePrintEvent(state);
            }
        };
        this.m_selected = new StringParameter(SELECTED);
        this.m_controlEvent = new StringParameter(CONTROL_EVENT);
        this.m_controlValue = new StringParameter(CONTROL_VALUE);
        this.m_stateModel = new FormModel("stateModel", true);
        this.m_stateModel.addFormParam(this.m_selected);
        this.m_stateModel.addFormParam(this.m_controlEvent);
        this.m_stateModel.addFormParam(this.m_controlValue);
        this.m_invisible = new BitSet(32);
        BitSetParameter p = new BitSetParameter(INVISIBLE, 1);
        this.m_stateModel.addFormParam(p);
    }

    public Page() {
        this("");
    }

    public Page(Label title) {
        this(title, (Container)new BoxPanel());
        BoxPanel bp = (BoxPanel)this.m_panel;
        bp.setWidth("100%");
    }

    public Page(String title) {
        this(new Label(title));
    }

    public void add(Component c) {
        this.m_panel.add(c);
    }

    public void add(Component c, int constraints) {
        this.m_panel.add(c, constraints);
    }

    public boolean contains(Object o) {
        return this.m_panel.contains(o);
    }

    public Component get(int index) {
        return this.m_panel.get(index);
    }

    public int indexOf(Component c) {
        return this.m_panel.indexOf(c);
    }

    public boolean isEmpty() {
        return this.m_panel.isEmpty();
    }

    public int size() {
        return this.m_panel.size();
    }

    public Iterator children() {
        return Collections.singletonList(this.m_panel).iterator();
    }

    public final Container getPanel() {
        return this.m_panel;
    }

    public void setPanel(Container c) {
        this.m_panel = c;
    }

    public final Label getTitle() {
        return this.m_title;
    }

    public final Label getTitle(PageState state) {
        return (Label)this.m_currentTitle.get(state);
    }

    public void setTitle(String title) {
        Assert.assertNotLocked(this);
        this.setTitle(new Label(title));
    }

    public void setTitle(Label title) {
        Assert.assertNotLocked(this);
        this.m_title = title;
    }

    public final void setErrorDisplay(Component c) {
        Assert.assertNotLocked(this);
        this.m_errorDisplay = c;
    }

    public final Component getErrorDisplay() {
        return this.m_errorDisplay;
    }

    public void setStyleSheet(String styleSheetURI, String styleSheetType) {
        Assert.assertNotLocked(this);
        this.addClientStylesheet(styleSheetURI, styleSheetType);
    }

    public void addClientStylesheet(String styleSheetURI, String mimeType) {
        this.m_clientStylesheets.add(new Stylesheet(styleSheetURI, mimeType));
    }

    public void addGlobalStateParam(ParameterModel p) {
        Assert.assertNotLocked(this);
        p.setName(Page.unmangle(p.getName()));
        this.m_stateModel.addFormParam(p);
    }

    protected Element generateXMLHelper(PageState ps, Document parent) {
        Assert.assertLocked(this);
        Element page = parent.createRootElement("bebop:page", "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(page);
        Element title = page.newChildElement("bebop:title", "http://www.arsdigita.com/bebop/1.0");
        title.setText(this.getTitle(ps).getLabel(ps));
        Iterator i = this.m_clientStylesheets.iterator();
        while (i.hasNext()) {
            ((Stylesheet)i.next()).generateXML(page);
        }
        return page;
    }

    public void generateXML(PageState state, Document parent) {
        if (this.m_useHttpSession) {
            state.stateAsHttpSession();
        }
        Element page = this.generateXMLHelper(state, parent);
        if (state.getErrors().hasNext()) {
            this.m_errorDisplay.generateXML(state, page);
        } else {
            this.m_panel.generateXML(state, page);
        }
        if (Kernel.getConfig().isDebugEnabled() && Page.debugStructure(state.getRequest())) {
            Element structure = page.newChildElement("bebop:structure", "http://www.arsdigita.com/bebop/1.0");
            this.showStructure(state, structure);
        }
    }

    private static boolean debugStructure(HttpServletRequest req) {
        return "transform".equals(req.getParameter("debug"));
    }

    public void generateXML(PageState state, Element elt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageState process(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        PageState result = new PageState(this, request, response);
        try {
            DeveloperSupport.startStage("Bebop Page Process");
            this.process(result);
        }
        finally {
            DeveloperSupport.endStage("Bebop Page Process");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PageState state) throws ServletException {
        Assert.assertLocked(this);
        try {
            DeveloperSupport.startStage("Bebop Request Event");
            this.fireRequestEvent(state);
        }
        finally {
            DeveloperSupport.endStage("Bebop Request Event");
        }
        state.forceValidate();
        if (state.isValid()) {
            try {
                DeveloperSupport.startStage("Bebop Respond");
                state.respond();
            }
            finally {
                DeveloperSupport.endStage("Bebop Respond");
            }
            try {
                DeveloperSupport.startStage("Bebop Action Event");
                this.fireActionEvent(state);
            }
            finally {
                DeveloperSupport.endStage("Bebop Action Event");
            }
        }
    }

    protected PageState prepare(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        Assert.assertLocked(this);
        PageState state = this.process(req, res);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildDocument(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            Document doc = new Document();
            PageState state = this.process(req, res);
            if (!res.isCommitted()) {
                try {
                    DeveloperSupport.startStage("Bebop XML");
                    this.generateXML(state, doc);
                }
                finally {
                    DeveloperSupport.endStage("Bebop XML");
                }
                return doc;
            }
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void finish() {
        if (!this.m_finished) {
            Assert.assertNotLocked(this);
            Traversal componentRegistrar = new Traversal(){

                protected void act(Component c) {
                    Page.this.addComponent(c);
                    c.register(Page.this);
                }
            };
            componentRegistrar.preorder(this.m_panel);
            if (this.m_errorDisplay != null) {
                this.addComponent(this.m_errorDisplay);
                this.m_errorDisplay.register(this);
            }
            this.m_finished = true;
        }
    }

    public void lock() {
        if (!this.m_finished) {
            this.finish();
        }
        this.m_stateModel.lock();
        Traversal componentLocker = new Traversal(){

            protected void act(Component c) {
                c.lock();
            }
        };
        componentLocker.preorder(this.m_panel);
        super.lock();
    }

    public void respond(PageState state) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void addActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_actionListeners.remove(l);
    }

    public void addRequestListener(RequestListener l) {
        Assert.assertNotLocked(this);
        this.m_requestListeners.add(l);
    }

    public void removeRequestListener(RequestListener l) {
        Assert.assertNotLocked(this);
        this.m_requestListeners.remove(l);
    }

    protected void fireActionEvent(PageState state) {
        ActionEvent e = null;
        Iterator i = this.m_actionListeners.iterator();
        while (i.hasNext()) {
            if (e == null) {
                e = new ActionEvent(this, state);
            }
            ActionListener listener = (ActionListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing action listener " + listener));
            }
            listener.actionPerformed(e);
        }
    }

    protected void fireRequestEvent(PageState state) {
        RequestEvent e = null;
        Iterator i = this.m_requestListeners.iterator();
        while (i.hasNext()) {
            if (e == null) {
                e = new RequestEvent(this, state);
            }
            RequestListener listener = (RequestListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing request listener " + listener));
            }
            listener.pageRequested(e);
        }
    }

    public void addComponent(Component c) {
        Assert.assertNotLocked(this);
        if (!this.stateContains(c)) {
            String key = c.getKey();
            if (key == null) {
                key = Integer.toString(this.m_components.size());
            }
            if (this.m_componentMap.get(key) != null) {
                throw new IllegalArgumentException("Component key must not be duplicated.  The key " + key + " is shared by more than one component.");
            }
            this.m_componentMap.put(key, c);
            this.m_components.add(c);
        }
    }

    public void addComponentStateParam(Component c, ParameterModel p) {
        Assert.assertNotLocked(this);
        if (!this.stateContains(c)) {
            throw new IllegalArgumentException("Component must be registered in Page");
        }
        if (!this.m_stateModel.containsFormParam(p)) {
            p.setName(this.parameterName(c, p.getName()));
            this.m_stateModel.addFormParam(p);
            ArrayList<ParameterModel> params = (ArrayList<ParameterModel>)this.m_componentParameterMap.get(c);
            if (params == null) {
                params = new ArrayList<ParameterModel>();
                this.m_componentParameterMap.put(c, params);
            }
            params.add(p);
        }
    }

    public Collection getComponentParameters(Component c) {
        return (Collection)this.m_componentParameterMap.get(c);
    }

    public int stateIndex(Component c) {
        return this.m_components.indexOf(c);
    }

    public int stateSize() {
        return this.m_components.size();
    }

    public boolean stateContains(Component c) {
        return this.m_components.contains(c);
    }

    public Component getComponent(int i) {
        return (Component)this.m_components.get(i);
    }

    Component getComponent(String s) {
        return (Component)this.m_componentMap.get(s);
    }

    public final FormModel getStateModel() {
        return this.m_stateModel;
    }

    public Iterator getParameters() {
        return this.m_stateModel.getParameters();
    }

    public boolean isVisibleDefault(Component c) {
        Assert.assertTrue(this.stateContains(c));
        return !this.m_invisible.get(this.stateIndex(c));
    }

    public void setVisibleDefault(Component c, boolean v) {
        Assert.assertNotLocked(this);
        this.addComponent(c);
        int i = this.stateIndex(c);
        if (v) {
            this.m_invisible.clear(i);
        } else {
            this.m_invisible.set(i);
        }
    }

    public String parameterName(Component c, String name) {
        if (c == null || !this.stateContains(c)) {
            return name;
        }
        return this.componentPrefix(c) + name;
    }

    public String parameterName(String name) {
        return this.parameterName(null, name);
    }

    void reset(final PageState ps, Component cmpnt) {
        Traversal resetter = new Traversal(){

            protected void act(Component c) {
                Collection cp = Page.this.getComponentParameters(c);
                if (cp != null) {
                    Iterator iter = cp.iterator();
                    while (iter.hasNext()) {
                        ParameterModel p = (ParameterModel)iter.next();
                        ps.setValue(p, null);
                    }
                }
                c.setVisible(ps, Page.this.isVisibleDefault(c));
            }
        };
        resetter.preorder(cmpnt);
    }

    private final String componentPrefix(Component c) {
        if (c == null) {
            return "bbp.g.";
        }
        String key = c.getKey();
        if (key == null) {
            if (this.stateContains(c)) {
                key = String.valueOf(this.stateIndex(c));
            } else {
                throw new IllegalArgumentException("Cannot generate prefix for component: key is null and component " + c.toString() + "/" + c.getKey() + " did not register with page.");
            }
        }
        return "bbp." + key + DELIMITER;
    }

    private static final String unmangle(String name) {
        if (!name.startsWith("bbp.")) {
            return name;
        }
        int prefix = name.indexOf(DELIMITER, name.indexOf(DELIMITER) + 1);
        if (prefix >= 0 && prefix < name.length()) {
            return name.substring(prefix + 1);
        }
        return name;
    }

    private void showStructure(PageState s, Element root) {
        HttpServletRequest req = s.getRequest();
        Element state = root.newChildElement("bebop:state", "http://www.arsdigita.com/bebop/1.0");
        String sel = req.getParameter(this.m_selected.getName());
        Element selected = state.newChildElement("bebop:selected", "http://www.arsdigita.com/bebop/1.0");
        selected.addAttribute(NAME, this.m_selected.getName());
        selected.setText(sel);
        Element eventName = state.newChildElement("bebop:eventName", "http://www.arsdigita.com/bebop/1.0");
        eventName.addAttribute(NAME, this.m_controlEvent.getName());
        eventName.setText(req.getParameter(this.m_controlEvent.getName()));
        Element eventValue = state.newChildElement("bebop:eventValue", "http://www.arsdigita.com/bebop/1.0");
        eventValue.addAttribute(NAME, this.m_controlValue.getName());
        eventValue.setText(req.getParameter(this.m_controlValue.getName()));
        Element globalState = root.newChildElement("bebop:params", "http://www.arsdigita.com/bebop/1.0");
        Iterator ii = this.getStateModel().getParameters();
        while (ii.hasNext()) {
            ParameterModel p = (ParameterModel)ii.next();
            if (p.getName().startsWith("bbp.")) continue;
            Element param = globalState.newChildElement("bebop:param", "http://www.arsdigita.com/bebop/1.0");
            param.addAttribute(NAME, p.getName());
            param.setText(String.valueOf(s.getValue(p)));
        }
        this.showVisibility(s, this, root);
    }

    private void showVisibility(PageState s, Component c, Element parent) {
        HttpServletRequest req = s.getRequest();
        Element cmp = parent.newChildElement("bebop:component", "http://www.arsdigita.com/bebop/1.0");
        cmp.addAttribute(NAME, Page.getDebugLabel(c));
        cmp.addAttribute("idx", String.valueOf(this.stateIndex(c)));
        cmp.addAttribute("isVisible", s.isVisible(c) ? "yes" : "no");
        cmp.addAttribute("class", c.getClass().getName());
        if (c.getKey() != null) {
            String prefix = this.componentPrefix(c);
            Iterator i = this.getStateModel().getParameters();
            while (i.hasNext()) {
                ParameterModel p = (ParameterModel)i.next();
                if (!p.getName().startsWith(prefix)) continue;
                Element param = parent.newChildElement("bebop:param", "http://www.arsdigita.com/bebop/1.0");
                param.addAttribute(NAME, Page.unmangle(p.getName()));
                param.addAttribute("defaultValue", String.valueOf(req.getParameter(p.getName())));
                param.addAttribute("currentValue", String.valueOf(s.getValue(p)));
            }
        }
        Iterator i = c.children();
        while (i.hasNext()) {
            this.showVisibility(s, (Component)i.next(), cmp);
        }
    }

    private static String getDebugLabel(Component c) {
        if (c.getKey() != null) {
            return c.getKey();
        }
        String klass = c.getClass().getName();
        return klass.substring(klass.lastIndexOf(DELIMITER) + 1, klass.length());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CONTROL_EVENT_KEYS.add(SELECTED);
        CONTROL_EVENT_KEYS.add(CONTROL_EVENT);
        CONTROL_EVENT_KEYS.add(CONTROL_VALUE);
        NAME = "name";
    }

    private class Stylesheet {
        String m_URI;
        String m_type;

        public Stylesheet(String stylesheetURI, String mimeType) {
            this.m_URI = stylesheetURI;
            this.m_type = mimeType;
        }

        public void generateXML(Element parent) {
            Element style = parent.newChildElement("bebop:stylesheet", "http://www.arsdigita.com/bebop/1.0");
            style.addAttribute("href", this.m_URI);
            if (this.m_type != null) {
                style.addAttribute("type", this.m_type);
            }
        }
    }
}

