/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleContainer
extends BlockStylable
implements Container {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SimpleContainer.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_components = new ArrayList();
    private String m_tag;
    private String m_ns;

    public SimpleContainer() {
        this(null, null);
    }

    public SimpleContainer(String tag, String ns) {
        this.m_tag = tag;
        this.m_ns = ns;
    }

    public void add(Component pc) {
        Assert.assertNotLocked(this);
        Assert.exists(pc);
        this.m_components.add(pc);
    }

    public void add(Component c, int constraints) {
        this.add(c);
    }

    public boolean contains(Object o) {
        return this.m_components.contains(o);
    }

    public boolean isEmpty() {
        return this.m_components.isEmpty();
    }

    public int indexOf(Component pc) {
        return this.m_components.indexOf(pc);
    }

    public int size() {
        return this.m_components.size();
    }

    public Component get(int index) {
        return (Component)this.m_components.get(index);
    }

    public Iterator children() {
        return this.m_components.iterator();
    }

    protected final void setTag(String tag) {
        Assert.assertNotLocked(this);
        this.m_tag = tag;
    }

    protected final void setNamespace(String ns) {
        Assert.assertNotLocked(this);
        this.m_ns = ns;
    }

    public final String getTag() {
        return this.m_tag;
    }

    public final String getNamespace() {
        return this.m_ns;
    }

    protected Element generateParent(Element p) {
        String tag = this.getTag();
        if (tag == null) {
            return p;
        }
        Element parent = p.newChildElement(tag, this.getNamespace());
        this.exportAttributes(parent);
        return parent;
    }

    public void generateChildrenXML(PageState state, Element p) {
        Iterator i = this.children();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (!c.isVisible(state)) continue;
            c.generateXML(state, p);
        }
    }

    public void generateXML(PageState state, Element p) {
        if (this.isVisible(state)) {
            Element parent = this.generateParent(p);
            this.generateChildrenXML(state, parent);
        }
    }
}

