/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ToggleLink
extends ControlLink {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ToggleLink.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$ToggleLink == null ? (class$com$arsdigita$bebop$ToggleLink = ToggleLink.class$("com.arsdigita.bebop.ToggleLink")) : class$com$arsdigita$bebop$ToggleLink));
    protected final String TYPE_TOGGLE = "toggle";
    private final String STATE_NAME = "state";
    private final String TOGGLE_EVENT = "toggle";
    private StringParameter m_state = new StringParameter("state");
    private Component m_selectedComponent;
    static /* synthetic */ Class class$com$arsdigita$bebop$ToggleLink;

    public ToggleLink(Component child) {
        super(child);
        this.m_selectedComponent = child;
        this.setTypeAttr("toggle");
    }

    public ToggleLink(String label) {
        this(new Label(label));
    }

    public void register(Page p) {
        s_log.debug((Object)"Registering with the page");
        super.register(p);
        p.addComponent(this);
        p.addComponentStateParam(this, this.m_state);
    }

    public void respond(PageState s) {
        String event = s.getControlEventName();
        if (!"toggle".equals(event)) {
            throw new IllegalArgumentException("Unknown event '" + event + "'");
        }
        this.setSelected(s, s.getControlEventValue() != null);
        this.fireActionEvent(s);
    }

    public Iterator children() {
        if (this.getSelectedComponent() != this.m_child) {
            return Collections.singletonList(this.getSelectedComponent()).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean isSelected(PageState s) {
        boolean result;
        boolean bl = result = s.getValue(this.m_state) != null;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)(this + " is selected: " + result));
        }
        return result;
    }

    public void setSelected(PageState s, boolean v) {
        if (v) {
            s_log.debug((Object)"Setting the toggle link selected");
            s.setValue(this.m_state, "1");
        } else {
            s_log.debug((Object)"Deselecting the toggle link");
            s.setValue(this.m_state, null);
        }
    }

    public final Component getSelectedComponent() {
        return this.m_selectedComponent;
    }

    public void setSelectedComponent(Component v) {
        Assert.assertNotLocked(this);
        this.m_selectedComponent = v;
    }

    public void generateXML(PageState s, Element e) {
        if (this.isVisible(s)) {
            if (this.isSelected(s)) {
                s.setControlEvent(this, "toggle", null);
                this.m_selectedComponent.generateXML(s, e);
            } else {
                s.setControlEvent(this, "toggle", "1");
                super.generateXML(s, e);
            }
            s.clearControlEvent();
        }
    }

    public void setControlEvent(PageState s) {
        s.setControlEvent(this, "toggle", this.isSelected(s) ? null : "1");
    }

    protected void generateExtraXMLAttributes(PageState s, Element link) {
        link.addAttribute("selected", this.isSelected(s) ? "yes" : "no");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

