/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.TreeExpansionEvent;
import com.arsdigita.bebop.event.TreeExpansionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.tree.DefaultTreeCellRenderer;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class Tree
extends SimpleComponent
implements Resettable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Tree.java#14 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$Tree == null ? (class$com$arsdigita$bebop$Tree = Tree.class$("com.arsdigita.bebop.Tree")) : class$com$arsdigita$bebop$Tree));
    private static final String CURRENT_STATE = "state";
    private static final String EXPAND_EVENT = "expand";
    private static final String COLLAPSE_EVENT = "collapse";
    private static final String SELECT = "sel";
    private static final String SELECT_EVENT = "s";
    private static final boolean EXPANDED = true;
    private static final boolean NOT_EXPANDED = false;
    private static final boolean LEAF = true;
    private static final boolean NOT_LEAF = false;
    protected StringParameter m_currentState = new StringParameter("state");
    protected TreeModelBuilder m_builder;
    private RequestLocal m_model;
    private TreeModel m_tree;
    private EventListenerList m_listeners;
    private SingleSelectionModel m_selection;
    private ChangeListener m_changeListener;
    private Element treeElement;
    private TreeCellRenderer m_renderer;
    static /* synthetic */ Class class$com$arsdigita$bebop$Tree;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$ChangeListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$ActionListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$TreeExpansionListener;

    public Tree(TreeModelBuilder b) {
        this.m_builder = b;
        this.m_renderer = new DefaultTreeCellRenderer();
        this.m_selection = new ParameterSingleSelectionModel(new StringParameter(SELECT));
        this.m_listeners = new EventListenerList();
        this.m_model = new RequestLocal(){

            protected Object initialValue(PageState s) {
                return Tree.this.getModelBuilder().makeModel(Tree.this, s);
            }
        };
        this.m_tree = null;
    }

    public Tree(TreeModel t) {
        this(new WrapperModelBuilder());
        this.m_tree = t;
    }

    public void register(Page p) {
        Assert.assertNotLocked(this);
        p.addComponent(this);
        p.addComponentStateParam(this, this.m_currentState);
        p.addComponentStateParam(this, this.getSelectionModel().getStateParameter());
    }

    public void reset(PageState state) {
        this.clearSelection(state);
        this.clearExpansionState(state);
    }

    public final TreeModel getTreeModel() {
        return this.m_tree;
    }

    public TreeModel getTreeModel(PageState s) {
        return (TreeModel)this.m_model.get(s);
    }

    public final TreeModelBuilder getModelBuilder() {
        return this.m_builder;
    }

    public void setModelBuilder(TreeModelBuilder b) {
        Assert.assertNotLocked(this);
        this.m_builder = b;
    }

    public void setTreeModel(TreeModel m) {
        Assert.assertNotLocked(this);
        this.m_tree = m;
    }

    public void setSelectionModel(SingleSelectionModel m) {
        Assert.assertNotLocked(this);
        this.m_selection = m;
        s_log.debug((Object)("New model: " + m));
    }

    public final SingleSelectionModel getSelectionModel() {
        return this.m_selection;
    }

    public Object getSelectedKey(PageState state) {
        return this.m_selection.getSelectedKey(state);
    }

    public void setSelectedKey(PageState state, Object key) {
        this.m_selection.setSelectedKey(state, key);
    }

    public boolean isSelected(PageState state) {
        return this.m_selection.isSelected(state);
    }

    public void clearSelection(PageState state) {
        this.m_selection.clearSelection(state);
    }

    public final boolean hasExpansionState(PageState state) {
        return state.getValue(this.m_currentState) != null;
    }

    public final void clearExpansionState(PageState state) {
        state.setValue(this.m_currentState, null);
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Tree.this.fireStateChanged(e.getPageState());
            }
        };
    }

    public void addChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        if (this.m_changeListener == null) {
            this.m_changeListener = this.createChangeListener();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Adding listener " + l + " to " + this));
            }
            this.m_selection.addChangeListener(this.m_changeListener);
        }
        this.m_listeners.add(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = Tree.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing listener " + l + " from " + this));
        }
        this.m_listeners.remove(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = Tree.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener, l);
    }

    protected void fireStateChanged(PageState state) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = Tree.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener);
        ChangeEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new ChangeEvent(this, state);
            }
            ((ChangeListener)i.next()).stateChanged(e);
        }
    }

    public void addActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.add(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = Tree.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = Tree.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener, l);
    }

    protected void fireActionEvent(PageState data) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = Tree.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener);
        ActionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new ActionEvent(this, data);
            }
            ((ActionListener)i.next()).actionPerformed(e);
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.add(class$com$arsdigita$bebop$event$TreeExpansionListener == null ? (class$com$arsdigita$bebop$event$TreeExpansionListener = Tree.class$("com.arsdigita.bebop.event.TreeExpansionListener")) : class$com$arsdigita$bebop$event$TreeExpansionListener, l);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$TreeExpansionListener == null ? (class$com$arsdigita$bebop$event$TreeExpansionListener = Tree.class$("com.arsdigita.bebop.event.TreeExpansionListener")) : class$com$arsdigita$bebop$event$TreeExpansionListener, l);
    }

    protected void fireTreeExpanded(PageState state, Object nodeKey) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$TreeExpansionListener == null ? (class$com$arsdigita$bebop$event$TreeExpansionListener = Tree.class$("com.arsdigita.bebop.event.TreeExpansionListener")) : class$com$arsdigita$bebop$event$TreeExpansionListener);
        TreeExpansionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new TreeExpansionEvent(this, state, nodeKey);
            }
            ((TreeExpansionListener)i.next()).treeExpanded(e);
        }
    }

    protected void fireTreeCollapsed(PageState state, Object nodeKey) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$TreeExpansionListener == null ? (class$com$arsdigita$bebop$event$TreeExpansionListener = Tree.class$("com.arsdigita.bebop.event.TreeExpansionListener")) : class$com$arsdigita$bebop$event$TreeExpansionListener);
        TreeExpansionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new TreeExpansionEvent(this, state, nodeKey);
            }
            ((TreeExpansionListener)i.next()).treeCollapsed(e);
        }
    }

    public void respond(PageState data) throws ServletException {
        String action = data.getControlEventName();
        String node = data.getControlEventValue();
        if (EXPAND_EVENT.equals(action)) {
            this.expand(node, data);
        } else if (COLLAPSE_EVENT.equals(action)) {
            this.collapse(node, data);
        } else if (SELECT_EVENT.equals(action)) {
            this.setSelectedKey(data, data.getControlEventValue());
        } else {
            throw new ServletException("Unknown event '" + action + "'");
        }
        this.fireActionEvent(data);
    }

    public boolean isCollapsed(String nodeKey, PageState data) {
        String stateString = (String)data.getValue(this.m_currentState);
        String spaceId = " " + nodeKey + " ";
        if (stateString == null) {
            return true;
        }
        int idIndex = stateString.indexOf(spaceId);
        return idIndex == -1;
    }

    public void collapse(String nodeKey, PageState data) {
        int idIndex;
        Assert.assertNotNull(nodeKey);
        Assert.assertNotNull(data);
        StringBuffer newCurrentState = new StringBuffer("");
        String stateString = (String)data.getValue(this.m_currentState);
        String spaceId = " " + nodeKey + " ";
        int idLength = spaceId.length();
        if (stateString != null && (idIndex = stateString.indexOf(spaceId)) != -1) {
            newCurrentState.append(stateString.substring(0, idIndex)).append(" ");
            if (stateString.length() > idIndex + idLength) {
                newCurrentState.append(stateString.substring(idIndex + idLength));
            }
            data.setValue(this.m_currentState, newCurrentState.toString());
            this.fireTreeCollapsed(data, nodeKey);
        }
    }

    public void expand(String nodeKey, PageState data) {
        Assert.assertNotNull(nodeKey);
        Assert.assertNotNull(data);
        String stateString = (String)data.getValue(this.m_currentState);
        String spaceId = " " + nodeKey + " ";
        StringBuffer newCurrentState = new StringBuffer("");
        if (stateString != null) {
            if (stateString.indexOf(spaceId) == -1) {
                newCurrentState.append(stateString);
                newCurrentState.append(spaceId);
                data.setValue(this.m_currentState, newCurrentState.toString());
                this.fireTreeExpanded(data, nodeKey);
            }
        } else {
            newCurrentState.append(spaceId);
            data.setValue(this.m_currentState, newCurrentState.toString());
            this.fireTreeExpanded(data, nodeKey);
        }
    }

    public final TreeCellRenderer getCellRenderer() {
        return this.m_renderer;
    }

    public void setCellRenderer(TreeCellRenderer r) {
        Assert.assertNotLocked(this);
        this.m_renderer = r;
    }

    protected void generateTree(PageState data, Element parent, TreeNode node, TreeModel tree) {
        boolean isSelected;
        Element t_node = parent.newChildElement("bebop:t_node", "http://www.arsdigita.com/bebop/1.0");
        String nodeKey = (String)node.getKey();
        Object selKey = this.getSelectedKey(data);
        boolean bl = isSelected = selKey != null && (selKey.equals(nodeKey) || selKey.toString().equals(nodeKey));
        if (tree.hasChildren(node, data)) {
            boolean collapsed = this.isCollapsed(nodeKey, data);
            data.setControlEvent(this, collapsed ? EXPAND_EVENT : COLLAPSE_EVENT, nodeKey);
            try {
                t_node.addAttribute("href", data.stateAsURL());
            }
            catch (IOException ioe) {
                // empty catch block
            }
            data.clearControlEvent();
            if (collapsed) {
                t_node.addAttribute("collapsed", "t");
                data.setControlEvent(this, SELECT_EVENT, nodeKey);
                Component c = this.getCellRenderer().getComponent(this, data, node.getElement(), isSelected, false, false, nodeKey);
                c.generateXML(data, t_node);
            } else {
                t_node.addAttribute("expanded", "t");
                data.setControlEvent(this, SELECT_EVENT, nodeKey);
                Component c = this.getCellRenderer().getComponent(this, data, node.getElement(), isSelected, true, false, nodeKey);
                c.generateXML(data, t_node);
                t_node.addAttribute("indentStart", "t");
                Iterator i = tree.getChildren(node, data);
                while (i.hasNext()) {
                    this.generateTree(data, t_node, (TreeNode)i.next(), tree);
                }
                t_node.addAttribute("indentClose", "t");
            }
        } else {
            t_node.addAttribute("childless", "t");
            data.setControlEvent(this, SELECT_EVENT, nodeKey);
            Component c = this.getCellRenderer().getComponent(this, data, node.getElement(), isSelected, false, true, nodeKey);
            c.generateXML(data, t_node);
        }
    }

    public void generateXML(PageState data, Element parent) {
        TreeModel tree = this.getTreeModel(data);
        if (!this.isVisible(data)) {
            return;
        }
        this.treeElement = parent.newChildElement("bebop:tree", "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(this.treeElement);
        TreeNode _rootNode = tree.getRoot(data);
        this.generateTree(data, this.treeElement, _rootNode, tree);
    }

    public void lock() {
        this.getModelBuilder().lock();
        super.lock();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WrapperModelBuilder
    extends LockableImpl
    implements TreeModelBuilder {
        public TreeModel makeModel(Tree t, PageState s) {
            return t.getTreeModel();
        }
    }

    public static class TreeSingleSelectionModel
    extends ParameterSingleSelectionModel {
        public TreeSingleSelectionModel(ParameterModel m) {
            super(m);
        }
    }
}

