/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.StringReader;
import java.math.BigDecimal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class UserList
extends List {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/UserList.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$bebop$demo$UserList == null ? (class$com$arsdigita$bebop$demo$UserList = UserList.class$("com.arsdigita.bebop.demo.UserList")) : class$com$arsdigita$bebop$demo$UserList).getName());
    static /* synthetic */ Class class$com$arsdigita$bebop$demo$UserList;

    public UserList() {
        this.setClassAttr("user-list");
        this.setModelBuilder(new UserListModelBuilder());
        this.setCellRenderer(new UserListCellRenderer());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserListCellRenderer
    implements ListCellRenderer {
        private UserListCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int idx, boolean isSelected) {
            final String[] tuple = (String[])value;
            return new SimpleComponent(){

                public void generateXML(PageState ps, Element parent) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    try {
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        org.w3c.dom.Document domDoc = db.parse(new InputSource(new StringReader(this.getXMLString())));
                        Document doc = new Document(domDoc);
                        parent.addContent(doc.getRootElement());
                    }
                    catch (Exception e) {
                        throw new UncheckedWrapperException(e);
                    }
                }

                public String getXMLString() {
                    return "<demo:user xmlns:demo=\"http://www.arsdigita.com/demo/1.0\" email=\"" + tuple[1] + "\" first-name=\"" + tuple[2] + "\" last-name=\"" + tuple[3] + "\"/>";
                }
            };
        }
    }

    private class UserListModel
    implements ListModel {
        private DataQuery m_dq;

        public UserListModel(DataQuery dq) {
            this.m_dq = dq;
        }

        public boolean next() {
            boolean result = false;
            try {
                result = this.m_dq.next();
            }
            catch (Exception e) {
                s_log.error((Object)e);
            }
            return result;
        }

        public String getKey() {
            try {
                return ((BigDecimal)this.m_dq.get("userID")).toString();
            }
            catch (Exception e) {
                s_log.error((Object)e);
                return null;
            }
        }

        public Object getElement() {
            String[] result = null;
            try {
                String id = ((BigDecimal)this.m_dq.get("userID")).toString();
                String email = (String)this.m_dq.get("primaryEmail");
                String given = (String)this.m_dq.get("firstName");
                String family = (String)this.m_dq.get("lastName");
                result = new String[]{id, email, given, family};
            }
            catch (Exception e) {
                s_log.error((Object)"getElement returning null", (Throwable)e);
            }
            return result;
        }
    }

    private class UserListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private UserListModelBuilder() {
        }

        public ListModel makeModel(List l, PageState ps) {
            UserListModel result = null;
            try {
                DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");
                dq.setParameter("excludeGroupId", new Integer(0));
                result = new UserListModel(dq);
            }
            catch (Exception e) {
                s_log.error((Object)e);
            }
            return result;
        }
    }
}

