/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.DateTimeParameter;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTime
extends Widget
implements BebopConstants {
    private OptionGroup m_year;
    private OptionGroup m_month;
    private TextField m_day;
    private TextField m_hour;
    private TextField m_minute;
    private TextField m_second;
    private OptionGroup m_amOrPm;
    private static final String ZERO = "0";
    private boolean m_showSeconds;

    public DateTime(ParameterModel model) {
        this(model, false);
    }

    public DateTime(ParameterModel model, boolean showSeconds) {
        super(model);
        if (!(model instanceof DateTimeParameter)) {
            throw new IllegalArgumentException("The DateTime widget " + model.getName() + " must be backed by a DateTimeParameter parmeter model");
        }
        String name = model.getName();
        String nameYear = name + ".year";
        String nameMonth = name + ".month";
        String nameDay = name + ".day";
        String nameHour = name + ".hour";
        String nameMinute = name + ".minute";
        String nameSecond = name + ".second";
        String nameAmOrPm = name + ".amOrPm";
        DateFormatSymbols dfs = new DateFormatSymbols();
        Calendar currentTime = GregorianCalendar.getInstance();
        this.m_year = new YearFragment(nameYear, this);
        this.m_month = new MonthFragment(nameMonth, this);
        this.m_day = new DayFragment(nameDay, this);
        this.m_hour = new HourFragment(nameHour, this);
        this.m_minute = new MinuteFragment(nameMinute, this);
        this.m_showSeconds = showSeconds;
        this.m_second = this.m_showSeconds ? new SecondFragment(nameSecond, this) : null;
        this.m_amOrPm = new AmPmFragment(nameAmOrPm, this);
        this.m_day.setMaxLength(2);
        this.m_day.setSize(2);
        this.m_hour.setMaxLength(2);
        this.m_hour.setSize(2);
        this.m_minute.setMaxLength(2);
        this.m_minute.setSize(2);
        if (this.m_showSeconds) {
            this.m_second.setMaxLength(2);
            this.m_second.setSize(2);
        }
        String[] months = dfs.getMonths();
        for (int i = 0; i < months.length; ++i) {
            if (months[i].length() <= 0) continue;
            this.m_month.addOption(new Option(String.valueOf(i), months[i]));
        }
        int currentYear = currentTime.get(1);
        this.setYearRange(currentYear - 1, currentYear + 3);
        String[] amPmStrings = dfs.getAmPmStrings();
        for (int i = 0; i < amPmStrings.length; ++i) {
            this.m_amOrPm.addOption(new Option(String.valueOf(i), amPmStrings[i]));
        }
    }

    public DateTime(String name) {
        this(new DateTimeParameter(name));
    }

    public void setYearRange(int startYear, int endYear) {
        Assert.assertNotLocked(this);
        this.m_year.clearOptions();
        for (int j = startYear; j <= endYear; ++j) {
            this.m_year.addOption(new Option(String.valueOf(j)));
        }
    }

    public String getType() {
        return "dateTime";
    }

    public void setMaxLength(int length) {
        this.setAttribute("MAXLENGTH", String.valueOf(length));
    }

    public boolean isCompound() {
        return true;
    }

    protected String getElementTag() {
        return "bebop:datetime";
    }

    public void generateWidget(PageState ps, Element parent) {
        if (!this.isVisible(ps)) {
            return;
        }
        Element date = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        date.addAttribute("name", this.getParameterModel().getName());
        this.m_month.generateXML(ps, date);
        this.m_day.generateXML(ps, date);
        this.m_year.generateXML(ps, date);
        this.m_hour.generateXML(ps, date);
        this.m_minute.generateXML(ps, date);
        if (this.m_showSeconds) {
            this.m_second.generateXML(ps, date);
        }
        this.m_amOrPm.generateXML(ps, date);
    }

    public void setDisabled() {
        this.m_month.setDisabled();
        this.m_day.setDisabled();
        this.m_year.setDisabled();
        this.m_hour.setDisabled();
        this.m_minute.setDisabled();
        if (this.m_showSeconds) {
            this.m_second.setDisabled();
        }
        this.m_amOrPm.setDisabled();
    }

    public void setReadOnly() {
        this.m_month.setReadOnly();
        this.m_day.setReadOnly();
        this.m_year.setReadOnly();
        this.m_hour.setReadOnly();
        this.m_minute.setReadOnly();
        if (this.m_showSeconds) {
            this.m_second.setReadOnly();
        }
        this.m_amOrPm.setReadOnly();
    }

    public void setForm(Form f) {
        super.setForm(f);
        this.m_year.setForm(f);
        this.m_month.setForm(f);
        this.m_day.setForm(f);
        this.m_hour.setForm(f);
        this.m_minute.setForm(f);
        if (this.m_showSeconds) {
            this.m_second.setForm(f);
        }
        this.m_amOrPm.setForm(f);
    }

    private Object getFragmentValue(PageState ps, int field) {
        Date value;
        Assert.assertNotNull(ps, "PageState");
        FormData f = this.getForm().getFormData(ps);
        if (f != null && (value = (Date)f.get(this.getName())) != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(value);
            return new Integer(c.get(field));
        }
        return null;
    }

    private class AmPmFragment
    extends SingleSelect {
        private DateTime parent;

        public AmPmFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 9);
        }
    }

    private class SecondFragment
    extends TextField {
        private DateTime parent;

        public SecondFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(0L, 59L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Integer sec = (Integer)this.parent.getFragmentValue(ps, 13);
            if (sec == null) {
                return null;
            }
            if (sec < 10) {
                return DateTime.ZERO + sec.toString();
            }
            return sec.toString();
        }
    }

    private class MinuteFragment
    extends TextField {
        private DateTime parent;

        public MinuteFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(0L, 59L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Integer min = (Integer)this.parent.getFragmentValue(ps, 12);
            if (min == null) {
                return null;
            }
            if (min < 10) {
                return DateTime.ZERO + min.toString();
            }
            return min.toString();
        }
    }

    private class HourFragment
    extends TextField {
        private DateTime parent;

        public HourFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(1L, 12L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 10);
        }
    }

    private class DayFragment
    extends TextField {
        private DateTime parent;

        public DayFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 5);
        }
    }

    private class MonthFragment
    extends SingleSelect {
        private DateTime parent;

        public MonthFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 2);
        }
    }

    private class YearFragment
    extends SingleSelect {
        private DateTime parent;

        public YearFragment(String name, DateTime parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Object value = this.parent.getFragmentValue(ps, 1);
            if (value == null) {
                Calendar currentTime = GregorianCalendar.getInstance();
                int currentYear = currentTime.get(1);
                value = new Integer(currentYear);
            }
            return value;
        }
    }
}

