/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class Option
extends BlockStylable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Option.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_value;
    private OptionGroup m_group;
    private Component m_component;
    private boolean m_isSelectOption;

    public Option(String label) {
        this(label, label);
    }

    public Option(String value, String label) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Option(String value, Component component) {
        this.setComponent(component);
        this.setValue(value);
    }

    public String getName() {
        return this.m_group.getName();
    }

    public final String getLabel() {
        return ((Label)this.m_component).getLabel();
    }

    public final void setLabel(String label) {
        this.setComponent(new Label(label));
    }

    public final void setLabel(Label label) {
        this.setComponent(label);
    }

    public final void setComponent(Component component) {
        Assert.assertNotLocked(this);
        this.m_component = component;
    }

    public final Component getComponent() {
        return this.m_component;
    }

    public final void setGroup(OptionGroup group) {
        Assert.assertNotLocked(this);
        Assert.assertNotNull(group);
        this.m_group = group;
        this.m_isSelectOption = "bebop:option".equals(this.m_group.m_xmlElement);
    }

    public final OptionGroup getGroup() {
        return this.m_group;
    }

    public final String getValue() {
        return this.m_value;
    }

    public final void setValue(String value) {
        this.m_value = value;
    }

    public void setOnFocus(String javascriptCode) {
        this.setAttribute("onFocus", javascriptCode);
    }

    public void setOnBlur(String javascriptCode) {
        this.setAttribute("onBlur", javascriptCode);
    }

    public void setOnSelect(String javascriptCode) {
        this.setAttribute("onSelect", javascriptCode);
    }

    public void setOnChange(String javascriptCode) {
        this.setAttribute("onChange", javascriptCode);
    }

    public void setOnKeyUp(String javascriptCode) {
        this.setAttribute("onKeyUp", javascriptCode);
    }

    public void setOnClick(String javascriptCode) {
        this.setAttribute("onclick", javascriptCode);
    }

    private ParameterData getParameterData(PageState s) {
        return this.m_group.getParameterData(s);
    }

    public boolean isSelected(ParameterData data) {
        if (data == null || data.getValue() == null) {
            return false;
        }
        Object value = data.getValue();
        Object[] selectedValues = value instanceof Object[] ? (Object[])value : new Object[]{value};
        String optionValue = this.getValue();
        if (optionValue == null || selectedValues == null) {
            return false;
        }
        for (int i = 0; i < selectedValues.length; ++i) {
            if (selectedValues[i] == null || !optionValue.equalsIgnoreCase(selectedValues[i].toString())) continue;
            return true;
        }
        return false;
    }

    public void generateXML(PageState s, Element e) {
        Element option = e.newChildElement(this.m_group.m_xmlElement, "http://www.arsdigita.com/bebop/1.0");
        if (!this.m_isSelectOption) {
            option.addAttribute("name", this.getName());
        }
        option.addAttribute("value", this.getValue());
        if (this.m_component != null) {
            this.m_component.generateXML(s, option);
        } else {
            new Label().generateXML(s, option);
        }
        this.exportAttributes(option);
        if (this.isSelected(this.getParameterData(s))) {
            if (this.m_isSelectOption) {
                option.addAttribute("selected", "selected");
            } else {
                option.addAttribute("checked", "checked");
            }
        }
    }

    final void generateAttributes(Element target) {
        this.exportAttributes(target);
    }
}

