/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PageEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.SearchAndSelectListener;
import com.arsdigita.bebop.event.SearchAndSelectModel;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.xml.Element;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class SearchAndSelect
extends FormSection
implements BebopConstants,
PrintListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/SearchAndSelect.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((Class)(class$com$arsdigita$bebop$form$SearchAndSelect == null ? (class$com$arsdigita$bebop$form$SearchAndSelect = SearchAndSelect.class$("com.arsdigita.bebop.form.SearchAndSelect")) : class$com$arsdigita$bebop$form$SearchAndSelect));
    protected String m_name;
    protected String m_value = "";
    protected String m_query = "";
    protected int m_maxViewableResults = 10;
    protected SearchAndSelectModel m_results = null;
    protected SearchAndSelectListener m_listener = null;
    protected boolean m_isMultiple = false;
    protected boolean m_useCheckboxes = false;
    protected boolean m_isOptional = true;
    protected Object m_this = this;
    protected TextField m_outputTextWidget;
    protected Widget m_outputSelectWidget;
    protected Hidden m_oldValueWidget;
    protected String m_oldValue = "";
    protected boolean m_isSearchLocked = false;
    static /* synthetic */ Class class$com$arsdigita$bebop$form$SearchAndSelect;

    private void initializeOutputWidget() {
        this.m_oldValueWidget = new Hidden(this.getName() + ".oldvalue");
        this.add(this.m_oldValueWidget);
        this.m_outputTextWidget = new TextField(this.getName() + ".text");
        this.add(this.m_outputTextWidget);
        this.m_outputSelectWidget = this.m_isMultiple ? (this.m_useCheckboxes ? new CheckboxGroup(this.getName() + ".select") : new MultipleSelect(this.getName() + ".select")) : new SingleSelect(this.getName() + ".select");
        this.add(this.m_outputSelectWidget);
        try {
            this.m_outputSelectWidget.addPrintListener(this);
        }
        catch (TooManyListenersException e) {
            s_cat.error((Object)"Could not add print listener", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            s_cat.error((Object)"Could not add print listener", (Throwable)e);
        }
    }

    public void prepare(PrintEvent e) {
        if (this.m_results == null) {
            this.m_results = this.m_listener.getModel(new PageEvent(this, e.getPageState()));
        }
        if (this.m_results == null) {
            return;
        }
        this.m_results.setQuery(this.m_query);
        if (this.m_isSearchLocked || (!this.m_oldValue.equals("") && this.m_oldValue.equals(this.m_value) || this.m_maxViewableResults >= this.m_results.resultsCount()) && this.m_results.resultsCount() > 0) {
            OptionGroup outputWidget = (OptionGroup)e.getTarget();
            if (this.m_isOptional && !this.m_isMultiple) {
                outputWidget.addOption(new Option("", "None"));
            }
            for (int i = 0; i < this.m_results.resultsCount(); ++i) {
                outputWidget.addOption(new Option(this.m_results.getID(i), this.m_results.getLabel(i)));
                s_cat.debug((Object)("    " + this.m_results.getID(i)));
            }
        }
    }

    public SearchAndSelect(String name) {
        this(name, false, false);
    }

    public SearchAndSelect(String name, boolean isMultiple) {
        this(name, isMultiple, false);
    }

    public SearchAndSelect(String name, boolean isMultiple, boolean useCheckboxes) {
        super(new SimpleContainer());
        this.m_isMultiple = isMultiple;
        this.m_useCheckboxes = useCheckboxes;
        this.m_name = name;
        this.initializeOutputWidget();
        super.addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent e) {
                FormData data = e.getFormData();
                SearchAndSelect.this.m_results = SearchAndSelect.this.m_listener.getModel(new PageEvent(SearchAndSelect.this.m_this, e.getPageState()));
                if (SearchAndSelect.this.m_results == null) {
                    return;
                }
                SearchAndSelect.this.m_oldValue = data.getString(SearchAndSelect.this.getName() + ".oldvalue");
                SearchAndSelect.this.m_value = data.getString(SearchAndSelect.this.getName() + ".text");
                if (SearchAndSelect.this.m_value == null) {
                    String[] tmpArray;
                    SearchAndSelect.this.m_isSearchLocked = true;
                    SearchAndSelect.this.m_query = SearchAndSelect.this.m_oldValue;
                    SearchAndSelect.this.m_value = SearchAndSelect.this.m_isMultiple ? ((tmpArray = (String[])data.get(SearchAndSelect.this.getName() + ".select")) == null ? "" : tmpArray[0]) : data.getString(SearchAndSelect.this.getName() + ".select");
                } else {
                    SearchAndSelect.this.m_query = SearchAndSelect.this.m_value;
                }
                if (SearchAndSelect.this.m_value.equals("") && SearchAndSelect.this.m_isOptional) {
                    return;
                }
                String oldQuery = SearchAndSelect.this.m_results.getQuery();
                SearchAndSelect.this.m_results.setQuery(SearchAndSelect.this.m_query);
                if (!SearchAndSelect.this.m_isOptional && !SearchAndSelect.this.m_isMultiple && SearchAndSelect.this.m_results.resultsCount() == 1) {
                    SearchAndSelect.this.m_isSearchLocked = true;
                    SearchAndSelect.this.m_value = SearchAndSelect.this.m_results.getID(0);
                }
                if (SearchAndSelect.this.m_isSearchLocked) {
                    if (!SearchAndSelect.this.m_isMultiple) {
                        StringParameter param = new StringParameter(SearchAndSelect.this.getName());
                        data.setParameter(SearchAndSelect.this.getName(), new ParameterData(param, SearchAndSelect.this.m_value));
                    } else {
                        ArrayParameter param = new ArrayParameter(SearchAndSelect.this.getName());
                        String[] tmpArray = (String[])data.get(SearchAndSelect.this.getName() + ".select");
                        if (tmpArray == null) {
                            tmpArray = new String[]{};
                        }
                        data.setParameter(SearchAndSelect.this.getName(), new ParameterData(param, tmpArray));
                    }
                    return;
                }
                data.addError("Search not complete yet.");
                SearchAndSelect.this.m_results.setQuery(oldQuery);
            }
        });
    }

    public final void setSearchAndSelectListener(SearchAndSelectListener listener) {
        this.m_listener = listener;
    }

    public final String getName() {
        return this.m_name;
    }

    private String getTextValue(PageState state) {
        if (this.m_value != null) {
            return this.m_value;
        }
        if (this.m_isSearchLocked) {
            if (this.m_isMultiple) {
                return ((String[])this.m_outputSelectWidget.getValue(state))[0];
            }
            return (String)this.m_outputSelectWidget.getValue(state);
        }
        return (String)this.m_outputTextWidget.getValue(state);
    }

    public String getType() {
        if (this.m_isSearchLocked) {
            return this.m_outputSelectWidget.getType();
        }
        return "text";
    }

    public final boolean isMultiple() {
        return this.m_isMultiple;
    }

    public final boolean isOptional() {
        return this.m_isOptional;
    }

    public SearchAndSelect setOptional(boolean isOptional) {
        this.m_isOptional = isOptional;
        return this;
    }

    public boolean isCompound() {
        return true;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.m_results == null) {
            this.m_results = this.m_listener.getModel(new PageEvent(this, state));
        }
        if (this.m_results == null) {
            return;
        }
        if (this.m_isSearchLocked || (!this.m_oldValue.equals("") && this.m_oldValue.equals(this.m_value) || this.m_maxViewableResults >= this.m_results.resultsCount()) && this.m_results.resultsCount() > 0) {
            this.m_outputSelectWidget.generateXML(state, parent);
        } else {
            this.m_outputTextWidget.generateXML(state, parent);
        }
        this.m_oldValueWidget.setValue(state, this.m_query);
        this.m_oldValueWidget.generateXML(state, parent);
        this.generateErrors(state, parent);
    }

    protected void generateErrors(PageState state, Element parent) {
        Element error;
        String curValue = this.getTextValue(state);
        if (this.m_results == null) {
            return;
        }
        if (this.m_results.resultsCount() > this.m_maxViewableResults) {
            error = parent.newChildElement("bebop:formErrors", "http://www.arsdigita.com/bebop/1.0");
            if (curValue == null || curValue.equals("")) {
                error.addAttribute("message", "Please enter a comma-delimited search");
            } else if (!this.m_oldValue.equals(curValue) && !this.m_isSearchLocked) {
                error.addAttribute("message", "Your search returned " + this.m_results.resultsCount() + " matches.  " + "Please refine your search or leave the " + "search as it is to see all results.");
            }
        }
        if (this.m_results.resultsCount() == 0) {
            if (!curValue.equals("")) {
                error = parent.newChildElement("bebop:formErrors", "http://www.arsdigita.com/bebop/1.0");
                error.addAttribute("message", "Your search returned no matches.  Please try again");
            } else {
                error = parent.newChildElement("bebop:formErrors", "http://www.arsdigita.com/bebop/1.0");
                error.addAttribute("message", "WARNING -- NO DATA FOUND");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

