/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.util.StringUtils;
import java.math.BigInteger;
import java.util.BitSet;
import javax.servlet.http.HttpServletRequest;

public class BitSetParameter
extends ParameterModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/BitSetParameter.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final int RADIX = 36;
    private static final double QUOTIENT = Math.log(2.0) / Math.log(36.0);
    private static final char SEPARATOR = '.';
    public static final int ENCODE_RAW = 0;
    public static final int ENCODE_DGAP = 1;
    public static final int ENCODE_AUTO = 2;
    private int m_encode = 0;
    private static final String FLAG_RAW = "r";
    private static final String FLAG_DGAP = "d";
    static /* synthetic */ Class class$java$util$BitSet;

    public BitSetParameter(String name, int encode) {
        super(name);
        this.m_encode = encode;
    }

    public BitSetParameter(String name) {
        this(name, 0);
    }

    public Object transformValue(HttpServletRequest request) throws IllegalArgumentException {
        return this.transformSingleValue(request);
    }

    public Object unmarshal(String value) throws IllegalArgumentException {
        if (value.startsWith(FLAG_DGAP)) {
            return this.unmarshalDGap(value.substring(1));
        }
        if (value.startsWith(FLAG_RAW)) {
            return this.unmarshalRaw(value.substring(1));
        }
        throw new IllegalArgumentException(this.getName() + " should start with either '" + FLAG_RAW + "' or '" + FLAG_DGAP + "' : " + value);
    }

    private Object unmarshalRaw(String value) throws IllegalArgumentException {
        BitSet result = new BitSet(32);
        BigInteger n = null;
        try {
            n = new BigInteger(value, 36);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.getName() + " should be a BigInteger: '" + value + "'; " + e.getMessage());
        }
        for (int i = 0; i < n.bitLength(); ++i) {
            if (!n.testBit(i)) continue;
            result.set(i);
        }
        return result;
    }

    private Object unmarshalDGap(String value) throws IllegalArgumentException {
        BitSet result = new BitSet(32);
        String[] bits = StringUtils.split(value, '.');
        boolean state = !"0".equals(bits[0]);
        int current = 0;
        if (state) {
            result.set(1);
        }
        for (int i = 1; i < bits.length; ++i) {
            BigInteger n = null;
            try {
                n = new BigInteger(bits[i], 36);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(this.getName() + " should be a comma separated list of BigInteger: '" + value + "'; " + e.getMessage());
            }
            int length = n.intValue();
            for (int j = 0; j < length; ++j) {
                if (state) {
                    result.set(current);
                }
                ++current;
            }
            state = !state;
        }
        return result;
    }

    public String marshal(Object value) {
        if (value == null) {
            return null;
        }
        BitSet set = (BitSet)value;
        if (this.m_encode == 1) {
            return FLAG_DGAP + BitSetParameter.marshalDGap(set);
        }
        if (this.m_encode == 2) {
            String dgap = BitSetParameter.marshalDGap(set);
            if (BitSetParameter.rawLength(set) > dgap.length()) {
                return FLAG_DGAP + dgap;
            }
            return FLAG_RAW + BitSetParameter.marshalRaw(set);
        }
        return FLAG_RAW + BitSetParameter.marshalRaw(set);
    }

    private static int rawLength(BitSet set) {
        if (set.length() == 0) {
            return 1;
        }
        return (int)Math.ceil((double)set.length() * QUOTIENT);
    }

    private static String marshalRaw(BitSet set) {
        BigInteger n = new BigInteger("0");
        for (int i = 0; i < set.length(); ++i) {
            if (!set.get(i)) continue;
            n = n.setBit(i);
        }
        return n.toString(36);
    }

    private static String marshalDGap(BitSet set) {
        StringBuffer sb = new StringBuffer();
        sb.append(set.get(0) ? "1" : "0");
        boolean current = set.get(0);
        int runLength = 1;
        for (int i = 1; i < set.length(); ++i) {
            if (set.get(i) == current) {
                ++runLength;
                continue;
            }
            sb.append('.');
            BigInteger bi = new BigInteger(String.valueOf(runLength));
            sb.append(bi.toString(36));
            runLength = 1;
            current = set.get(i);
        }
        sb.append('.');
        sb.append(String.valueOf(runLength));
        return sb.toString();
    }

    public Class getValueClass() {
        return class$java$util$BitSet == null ? (class$java$util$BitSet = BitSetParameter.class$("java.util.BitSet")) : class$java$util$BitSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

