/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.globalization.Globalization;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;

public class DateParameter
extends ParameterModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/DateParameter.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$java$util$Date;

    public DateParameter(String name) {
        super(name);
    }

    protected Calendar getCalendar(HttpServletRequest request) {
        return new GregorianCalendar();
    }

    public Object transformValue(HttpServletRequest request) throws IllegalArgumentException {
        Calendar c = null;
        Date outVal = null;
        try {
            c = this.getCalendar(request);
            c.clear();
            c.setLenient(false);
            String year = Globalization.decodeParameter(request, this.getName() + ".year");
            String month = Globalization.decodeParameter(request, this.getName() + ".month");
            String day = Globalization.decodeParameter(request, this.getName() + ".day");
            if (year == null && month == null && day == null) {
                return this.transformSingleValue(request);
            }
            if (day == null || day.length() == 0) {
                return null;
            }
            if (year != null) {
                c.set(1, Integer.parseInt(year));
            }
            if (month != null) {
                c.set(2, Integer.parseInt(month));
            }
            if (day != null) {
                c.set(5, Integer.parseInt(day));
            }
            outVal = c.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Day of Month");
        }
        return outVal;
    }

    public Object unmarshal(String encoded) {
        try {
            return new Date(Long.parseLong(encoded));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot unmarshal date '" + encoded + "': " + e.getMessage());
        }
    }

    public String marshal(Object value) {
        if (value == null) {
            return null;
        }
        return Long.toString(((Date)value).getTime());
    }

    public Class getValueClass() {
        return class$java$util$Date == null ? (class$java$util$Date = DateParameter.class$("java.util.Date")) : class$java$util$Date;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

