/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.portal;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.Portlet;
import com.arsdigita.xml.Element;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractPortletRenderer
extends Portlet {
    private static Map s_cachedXMLMap = Collections.synchronizedMap(new HashMap());
    private static Map s_dateCachedMap = Collections.synchronizedMap(new HashMap());

    void generateXMLBody(PageState ps, Element parentElement) {
        this.generateBodyXML(ps, parentElement);
    }

    protected abstract void generateBodyXML(PageState var1, Element var2);

    private Element makeXML(PageState state) {
        Element holder = new Element("holder");
        this.setDateCached(new Date());
        super.generateXML(state, holder);
        return holder;
    }

    public void generateXML(PageState state, Element parent) {
        Element xml;
        Object key = this.getCacheKey();
        if (this.isDirty()) {
            xml = this.makeXML(state);
            s_cachedXMLMap.put(key, xml);
        }
        if ((xml = (Element)s_cachedXMLMap.get(key)) == null) {
            xml = this.makeXML(state);
            s_cachedXMLMap.put(key, xml);
        }
        Iterator iter = xml.getChildren().iterator();
        while (iter.hasNext()) {
            parent.newChildElement((Element)iter.next());
        }
    }

    public boolean isDirty() {
        return true;
    }

    public Object getCacheKey() {
        return null;
    }

    public Date getDateCached() {
        return (Date)s_dateCachedMap.get(this.getCacheKey());
    }

    private void setDateCached(Date dateCached) {
        s_dateCachedMap.put(this.getCacheKey(), dateCached);
    }
}

