/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.categorization;

import com.arsdigita.categorization.CategorizationException;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryNotFoundException;
import com.arsdigita.categorization.CategoryPurpose;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.util.HierarchyDenormalization;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Category
extends ACSObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$categorization$Category == null ? (class$com$arsdigita$categorization$Category = Category.class$("com.arsdigita.categorization.Category")) : class$com$arsdigita$categorization$Category));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.categorization.Category";
    private static final String BASE_DATA_OBJECT_PACKAGE = "com.arsdigita.categorization";
    public static final PrivilegeDescriptor MAP_DESCRIPTOR = new PrivilegeDescriptor("map_to_category");
    public static final String ROOT_CATEGORY = "rootCategory";
    public static final String USE_CONTEXT = "useContext";
    public static final String CATEGORY_OWNER = "categoryOwner";
    public static final String ROOT_USE_CONTEXT = "rootUseContext";
    public static final String OWNER_USE_CONTEXT = "ownerUseContext";
    public static final String CHILD = "child";
    public static final String PARENTS = "parents";
    public static final String RELATED = "related";
    public static final String REL_TYPE = "relationType";
    public static final String SORT_KEY = "sortKey";
    public static final String IS_DEFAULT = "isDefault";
    public static final String IS_INDEX = "isIndex";
    public static final String PARENT_CATEGORY = "parentCategory";
    public static final String CATEGORY_ID = "categoryID";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";
    public static final String IS_ENABLED = "isEnabled";
    public static final String IS_ABSTRACT = "isAbstract";
    public static final String DEFAULT_ANCESTORS = "defaultAncestors";
    private static final String PURPOSES = "purposes";
    public static final String CHILD_OBJECTS = "childObjects";
    public static final String RELATED_CATEGORIES = "related";
    public static final String CATEGORIES = "categories";
    private static final String CHILD_CATEGORY_IDS = "com.arsdigita.categorization.childCategoryIDs";
    private static final String CURRENT_SORT_KEY = "currentSortKey";
    private HierarchyDenormalization m_hierarchy;
    static /* synthetic */ Class class$com$arsdigita$categorization$Category;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static String getBaseDataObjectPackage() {
        return BASE_DATA_OBJECT_PACKAGE;
    }

    public Category(DataObject categoryObjectData) {
        super(categoryObjectData);
    }

    public Category() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Category(String typeName) {
        super(typeName);
    }

    public Category(ObjectType type) {
        super(type);
    }

    public Category(OID oid) {
        super(oid);
    }

    public Category(BigDecimal id) {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Category(String name, String description) {
        this();
        this.setName(name);
        this.setDescription(description);
    }

    public Category(String name, String description, String url) {
        this();
        this.setName(name);
        this.setDescription(description);
        this.setURL(url);
    }

    public Category(OID categoryID, String name, String description) {
        this(categoryID);
        this.setName(name);
        this.setDescription(description);
    }

    public Category(OID categoryID, String name, String description, String url) {
        this(categoryID);
        this.setName(name);
        this.setDescription(description);
        this.setURL(url);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            if (this.getName() == null) {
                this.setName("name me");
            }
            this.setEnabled(true);
            this.setAbstract(false);
        }
        this.m_hierarchy = new HierarchyDenormalization("com.arsdigita.categorization.updateCategoryDescendants", this, DEFAULT_ANCESTORS){};
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getQualifiedName(String delimeter, boolean includeRoot) {
        if (!includeRoot && this.getDefaultAscendants().size() < 2L) {
            return null;
        }
        CategoryCollection ancestors = this.getDefaultAscendants();
        ancestors.addOrder(DEFAULT_ANCESTORS);
        LinkedList<String> names = new LinkedList<String>();
        if (!includeRoot) {
            ancestors.next();
        }
        while (ancestors.next()) {
            names.add(ancestors.getCategory().getName());
        }
        return StringUtils.join(names, delimeter);
    }

    public String getQualifiedURL(String delimeter, boolean includeRoot) {
        if (!includeRoot && this.getDefaultAscendants().size() < 2L) {
            return null;
        }
        CategoryCollection ancestors = this.getDefaultAscendants();
        ancestors.addOrder(DEFAULT_ANCESTORS);
        LinkedList<String> names = new LinkedList<String>();
        if (!includeRoot) {
            ancestors.next();
        }
        while (ancestors.next()) {
            names.add(ancestors.getCategory().getURL());
        }
        return StringUtils.join(names, delimeter);
    }

    public void setName(String value) {
        this.set(NAME, value);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String value) {
        this.set(DESCRIPTION, value);
    }

    public String getURL() {
        return (String)this.get(URL);
    }

    public void setURL(String url) {
        this.set(URL, url);
    }

    public boolean isEnabled() {
        return (Boolean)this.get(IS_ENABLED);
    }

    public void setEnabled(boolean isEnabled) {
        this.set(IS_ENABLED, new Boolean(isEnabled));
    }

    public boolean isAbstract() {
        return (Boolean)this.get(IS_ABSTRACT);
    }

    public void setAbstract(boolean isAbstract) {
        this.set(IS_ABSTRACT, new Boolean(isAbstract));
    }

    public Collection getPurposes() {
        DataAssociationCursor purposeCur = ((DataAssociation)this.get(PURPOSES)).cursor();
        LinkedList<CategoryPurpose> purposes = new LinkedList<CategoryPurpose>();
        while (purposeCur.next()) {
            CategoryPurpose cp = (CategoryPurpose)DomainObjectFactory.newInstance(purposeCur.getDataObject());
            purposes.add(cp);
        }
        return purposes;
    }

    public void addPurpose(CategoryPurpose purpose) {
        this.add(PURPOSES, purpose);
    }

    public void removePurpose(CategoryPurpose purpose) {
        this.remove(PURPOSES, purpose);
    }

    private void setDefaultAncestors(Category defaultParent) {
        String value = defaultParent == null ? this.getID() + "/" : (String)defaultParent.get(DEFAULT_ANCESTORS) + this.getID().toString() + "/";
        this.set(DEFAULT_ANCESTORS, value);
    }

    protected void beforeSave() {
        super.beforeSave();
        if (this.get(DEFAULT_ANCESTORS) == null) {
            this.setDefaultAncestors(null);
        }
    }

    public static boolean isCategory(ACSObject object) {
        return object.getSpecificObjectType().equals(BASE_DATA_OBJECT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        DataAssociationCursor children = this.getRelatedCategories(CHILD);
        children.addEqualsFilter("link.isDefault", Boolean.TRUE);
        try {
            if (children.next()) {
                throw new CategorizationException("This category is the default parent of another category. You must explicitly delete the child categories first. Child category: " + children.getDataObject());
            }
        }
        finally {
            children.close();
        }
        DataAssociationCursor objects = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        if (objects != null) {
            try {
                if (objects.next()) {
                    throw new CategorizationException("This category has child objects. You must delete  any such objects explicitly, before deleting the  category.  Child object: " + objects.getDataObject());
                }
            }
            finally {
                objects.close();
            }
        }
        this.clearRelations();
        super.delete();
    }

    private void clearRelations() {
        this.clear("related");
        this.clear(PARENTS);
    }

    public void deleteCategorySubtree() {
        DataAssociationCursor cursor = ((DataAssociation)this.get("related")).cursor();
        while (cursor.next()) {
            DataObject link = cursor.getLink();
            if ("related".equals(link.get(REL_TYPE))) {
                this.remove("related", cursor.getDataObject());
                continue;
            }
            if (!Boolean.TRUE.equals(link.get(IS_DEFAULT))) continue;
            new Category(cursor.getDataObject()).deleteCategorySubtree();
        }
        this.delete();
    }

    public void deleteCategoryAndRemap() {
        Category parent;
        try {
            parent = this.getDefaultParentCategory();
        }
        catch (CategoryNotFoundException ce) {
            this.deleteCategoryAndOrphan();
            return;
        }
        if (parent.isAbstract()) {
            this.deleteCategoryAndOrphan();
            return;
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get("related")).cursor();
        while (cursor.next()) {
            DataObject link = cursor.getLink();
            String relationType = (String)link.get(REL_TYPE);
            Boolean isDefault = (Boolean)link.get(IS_DEFAULT);
            this.remove("related", cursor.getDataObject());
            if (!CHILD.equals(relationType)) continue;
            Category category = new Category(cursor.getDataObject());
            parent.addChild(category);
            if (!Boolean.TRUE.equals(isDefault)) continue;
            category.setDefaultParentCategory(parent);
        }
        cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        DataAssociation parentChildren = (DataAssociation)parent.get(CHILD_OBJECTS);
        while (cursor.next()) {
            DataObject link = cursor.getLink();
            DataObject object = cursor.getDataObject();
            DataObject newLink = parentChildren.add(object);
            if (Boolean.TRUE == link.get(IS_DEFAULT)) {
                newLink.set(IS_DEFAULT, Boolean.TRUE);
                continue;
            }
            newLink.set(IS_DEFAULT, Boolean.FALSE);
        }
        this.delete();
    }

    public void deleteCategoryAndOrphan() {
        this.clearRelations();
        super.delete();
    }

    public void addChild(ACSObject object) {
        this.addMapping(object, CHILD);
    }

    public void addRelatedCategory(Category category) {
        this.addMapping(category, "related");
    }

    private void addMapping(ACSObject acsObj, String relationType) {
        if (acsObj instanceof Category) {
            this.addMapping((Category)acsObj, relationType);
            return;
        }
        Assert.falsity(this.isAbstract(), "You cannot categorize an object within an abstract category.  If you are seeing this message then your UI is allowing you to do something that you are not allowed to do and you should email your site administrator.");
        if ("related".equals(relationType)) {
            throw new CategorizationException("related relation type is only appropriate between two categories");
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        cursor.addEqualsFilter("id", acsObj.getID());
        if (cursor.size() == 0L) {
            this.add(CHILD_OBJECTS, acsObj);
        }
    }

    private void addMapping(Category category, String relationType) {
        if (CHILD.equals(relationType) && category.isMemberOfSubtree(this)) {
            throw new CategorizationException("The object that you are trying to add as a child is already a member of the subtree.");
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get("related")).cursor();
        cursor.addEqualsFilter("id", category.getID());
        DataObject link = cursor.next() ? cursor.getLink() : this.add("related", category);
        cursor.close();
        link.set(REL_TYPE, relationType);
        link.set(IS_DEFAULT, Boolean.FALSE);
    }

    public void removeChild(ACSObject acsObj) {
        if (acsObj == null) {
            throw new NullPointerException("acsObj");
        }
        if (acsObj instanceof Category) {
            this.removeChild((Category)acsObj);
        } else {
            this.remove(CHILD_OBJECTS, acsObj);
        }
    }

    public void removeChild(Category category) {
        Assert.exists(category, class$com$arsdigita$categorization$Category == null ? (class$com$arsdigita$categorization$Category = Category.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$categorization$Category);
        try {
            if (this.equals(category.getDefaultParentCategory())) {
                PermissionService.setContext(category, null);
                category.setDefaultAncestors(null);
            }
        }
        catch (CategoryNotFoundException categoryNotFoundException) {
            // empty catch block
        }
        this.remove("related", category);
    }

    public void removeRelatedCategory(Category category) {
        this.removeChild(category);
    }

    public void setIndexObject(ACSObject object) {
        DataAssociationCursor items = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        while (items.next()) {
            DataObject obj = items.getDataObject();
            DataObject link = items.getLink();
            if (object != null && object.getOID().equals(obj.getOID())) {
                link.set(IS_INDEX, Boolean.TRUE);
                continue;
            }
            if (!Boolean.TRUE.equals(link.get(IS_INDEX))) continue;
            link.set(IS_INDEX, Boolean.FALSE);
        }
    }

    public ACSObject getIndexObject() {
        ACSObject item = this.getDirectIndexObject();
        if (item == null) {
            try {
                item = this.getDefaultParentCategory().getIndexObject();
            }
            catch (CategoryNotFoundException ex) {
                s_log.debug((Object)"not found", (Throwable)ex);
            }
        }
        return item;
    }

    public ACSObject getDirectIndexObject() {
        DataAssociationCursor items = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        items.addEqualsFilter("link.isIndex", Boolean.TRUE);
        if (items.next()) {
            DataObject dobj = items.getDataObject();
            items.close();
            return (ACSObject)DomainObjectFactory.newInstance(dobj);
        }
        items.close();
        return null;
    }

    public boolean isLeaf() {
        return !this.hasChildCategories() && !this.hasChildObjects();
    }

    public boolean hasChildObjects() {
        return this.getNumberOfChildObjects() != 0L;
    }

    public boolean hasChildCategories() {
        return this.getNumberOfChildCategories() != 0L;
    }

    public boolean isRoot() {
        return this.getParentCategoryCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParentCategoryCount() {
        DataAssociationCursor cursor = ((DataAssociation)this.get(PARENTS)).cursor();
        try {
            long l = cursor.size();
            return l;
        }
        finally {
            cursor.close();
        }
    }

    public void setDefaultParentCategory(Category parent) {
        PermissionService.setContext(this, parent);
        boolean found = false;
        DataAssociationCursor cursor = ((DataAssociation)this.get(PARENTS)).cursor();
        while (cursor.next()) {
            DataObject category = cursor.getDataObject();
            DataObject link = cursor.getLink();
            if (Boolean.TRUE.equals((Boolean)link.get(IS_DEFAULT))) {
                link.set(IS_DEFAULT, Boolean.FALSE);
                continue;
            }
            if (!parent.getID().equals(category.get("id"))) continue;
            link.set(IS_DEFAULT, Boolean.TRUE);
            found = true;
        }
        if (!found && parent != null) {
            DataObject link = this.add(PARENTS, parent);
            link.set(IS_DEFAULT, Boolean.TRUE);
            link.set(REL_TYPE, CHILD);
        }
        this.setDefaultAncestors(parent);
    }

    public void swapWithNext(ACSObject child) {
        s_log.debug((Object)("swapWithNext: " + child.getOID()));
        if (Category.isCategory(child)) {
            this.swapWithNextCategory((Category)child);
            return;
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            int key = ((BigDecimal)link.get(SORT_KEY)).intValue();
            int previousKey = key + 1;
            DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.minObjectCategorySortKey");
            query.setParameter(CATEGORY_ID, this.getID());
            query.setParameter(CURRENT_SORT_KEY, new Integer(key));
            if (query.next()) {
                previousKey = ((BigDecimal)query.get(SORT_KEY)).intValue();
            }
            query.close();
            this.swapObjectKeys(previousKey, key);
        }
        cursor.close();
    }

    private void swapWithNextCategory(Category child) {
        DataAssociationCursor cursor = this.getRelatedCategories(CHILD);
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            int key = ((BigDecimal)link.get(SORT_KEY)).intValue();
            int previousKey = key + 1;
            DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.minCategoryCategorySortKey");
            query.setParameter(CATEGORY_ID, this.getID());
            query.setParameter(CURRENT_SORT_KEY, new Integer(key));
            if (query.next()) {
                previousKey = ((BigDecimal)query.get(SORT_KEY)).intValue();
            }
            query.close();
            this.swapCategoryKeys(previousKey, key);
        }
        cursor.close();
    }

    public void swapWithPrevious(ACSObject child) {
        if (Category.isCategory(child)) {
            this.swapWithPreviousCategory((Category)child);
            return;
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            int key = ((BigDecimal)link.get(SORT_KEY)).intValue();
            int previousKey = key - 1;
            DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.maxObjectCategorySortKey");
            query.setParameter(CATEGORY_ID, this.getID());
            query.setParameter(CURRENT_SORT_KEY, new Integer(key));
            if (query.next()) {
                previousKey = ((BigDecimal)query.get(SORT_KEY)).intValue();
            }
            query.close();
            this.swapObjectKeys(previousKey, key);
        }
        cursor.close();
    }

    private void swapWithPreviousCategory(Category child) {
        DataAssociationCursor cursor = this.getRelatedCategories(CHILD);
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            int key = ((BigDecimal)link.get(SORT_KEY)).intValue();
            int previousKey = key - 1;
            DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.maxCategoryCategorySortKey");
            query.setParameter(CATEGORY_ID, this.getID());
            query.setParameter(CURRENT_SORT_KEY, new Integer(key));
            if (query.next()) {
                previousKey = ((BigDecimal)query.get(SORT_KEY)).intValue();
                query.close();
            }
            this.swapCategoryKeys(previousKey, key);
        }
        cursor.close();
    }

    private void swapCategoryKeys(int key, int nextKey) {
        this.swapKeys(this.getSession().retrieveDataOperation("com.arsdigita.categorization.swapCategoryWithNextCategory"), key, nextKey);
    }

    private void swapObjectKeys(int key, int nextKey) {
        this.swapKeys(this.getSession().retrieveDataOperation("com.arsdigita.categorization.swapObjectWithNextObject"), key, nextKey);
    }

    private void swapKeys(DataOperation operation, int key, int nextKey) {
        operation.setParameter(SORT_KEY, new BigDecimal((double)key));
        operation.setParameter("nextSortKey", new BigDecimal((double)nextKey));
        operation.setParameter("parentID", this.getID());
        operation.execute();
    }

    public void alphabetizeChildCategories() {
        DataAssociationCursor cursor = this.getRelatedCategories(CHILD);
        cursor.addOrder("lower(name)");
        int count = 0;
        while (cursor.next()) {
            DataObject link = cursor.getLink();
            link.set(SORT_KEY, new Integer(count));
            ++count;
        }
    }

    public void setSortKey(ACSObject child, int key) {
        if (Category.isCategory(child)) {
            this.setSortKey((Category)child, key);
            return;
        }
        DataAssociationCursor cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            link.set(SORT_KEY, new BigDecimal((double)key));
        }
        cursor.close();
    }

    public void swapSortKeys(BigDecimal childID1, BigDecimal childID2) {
        if (childID1 != null && childID2 != null) {
            DataObject link1 = null;
            DataObject link2 = null;
            BigDecimal key1 = null;
            BigDecimal key2 = null;
            DataAssociationCursor cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
            cursor.addEqualsFilter("id", childID1);
            if (cursor.next()) {
                link1 = cursor.getLink();
            }
            cursor.close();
            cursor = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
            cursor.addEqualsFilter("id", childID2);
            if (cursor.next()) {
                link2 = cursor.getLink();
            }
            cursor.close();
            if (link1 != null && link2 != null) {
                key1 = (BigDecimal)link1.get(SORT_KEY);
                key2 = (BigDecimal)link2.get(SORT_KEY);
                link1.set(SORT_KEY, key2);
                link2.set(SORT_KEY, key1);
            }
        }
    }

    private void setSortKey(Category child, int key) {
        DataAssociationCursor cursor = this.getRelatedCategories(CHILD);
        cursor.addEqualsFilter("id", child.getID());
        if (cursor.next()) {
            DataObject link = cursor.getLink();
            link.set(SORT_KEY, new BigDecimal((double)key));
        }
        cursor.close();
    }

    public DataAssociationCursor getRelatedCategories(String relation) {
        Assert.truth(relation.equals(CHILD) || relation.equals("related"), " invalid relation {" + relation + "}");
        DataAssociationCursor cursor = ((DataAssociation)this.get("related")).cursor();
        cursor.addEqualsFilter("link.relationType", relation);
        return cursor;
    }

    public long getNumberOfChildCategories() {
        DataAssociationCursor cursor = this.getRelatedCategories(CHILD);
        return cursor.size();
    }

    public CategoryCollection getChildren() {
        return new CategoryCollection(this.getRelatedCategories(CHILD));
    }

    public CategorizedCollection getObjects(String objectType) {
        return this.getObjects(objectType, null);
    }

    public CategorizedCollection getObjects(String objectType, String path) {
        if (objectType == null) {
            throw new NullPointerException("objectType");
        }
        String sortPath = "categories.link.sortKey";
        if (path != null) {
            sortPath = path + "." + sortPath;
        }
        CategorizedCollection result = new CategorizedCollection(this.getSession().retrieve(objectType), sortPath);
        result.addEqualsFilter(Category.extendPath(path), this.getID());
        return result;
    }

    private static String extendPath(String path) {
        String pathExtension = "categories.id";
        if (path == null) {
            return "categories.id";
        }
        StringBuffer sb = new StringBuffer(path.length() + "categories.id".length() + 1);
        sb.append(path).append(".").append("categories.id");
        return sb.toString();
    }

    public long getNumberOfChildObjects() {
        DataAssociationCursor association = ((DataAssociation)this.get(CHILD_OBJECTS)).cursor();
        if (association == null) {
            return 0L;
        }
        return association.size();
    }

    public CategoryCollection getParents() {
        return new CategoryCollection(((DataAssociation)this.get(PARENTS)).cursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getDefaultParentCategory() {
        DataAssociationCursor cursor = ((DataAssociation)this.get(PARENTS)).cursor();
        cursor.addEqualsFilter("link.isDefault", Boolean.TRUE);
        try {
            if (cursor.next()) {
                Category category = new Category(cursor.getDataObject());
                return category;
            }
        }
        finally {
            cursor.close();
        }
        throw new CategoryNotFoundException("The Category " + this + " does " + "not have a default parent");
    }

    public boolean isMemberOfSubtree(ACSObject acsObject) {
        if (acsObject.getOID() == null || this.getOID() == null) {
            return false;
        }
        if (Category.isCategory(acsObject)) {
            if (this.equals(acsObject)) {
                return true;
            }
            DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.categorySubtree");
            query.setParameter("id", this.getID());
            query.addEqualsFilter("categorySubtree.id", acsObject.getID());
            return query.size() > 0L;
        }
        DataQuery query = this.getSession().retrieveQuery("com.arsdigita.categorization.objectsInSubtree");
        query.setParameter("id", this.getID());
        query.addEqualsFilter("object.id", acsObject.getID());
        return query.size() > 0L;
    }

    public CategoryCollection getDefaultAscendants() {
        DataCollection collection = this.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        String ids = (String)this.get(DEFAULT_ANCESTORS);
        if (ids == null) {
            throw new IllegalStateException("null default ancestors for " + this);
        }
        collection.addFilter("defaultAncestors in :ancestors").set("ancestors", Category.subpaths(ids));
        return new CategoryCollection(collection);
    }

    private static List subpaths(String path) {
        LinkedList<String> result = new LinkedList<String>();
        if (path == null || "".equals(path)) {
            return result;
        }
        String delim = "/";
        if (!path.endsWith("/")) {
            throw new IllegalArgumentException("doesn't end with /: " + path);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuffer subpath = new StringBuffer();
        while (st.hasMoreTokens()) {
            subpath.append(st.nextToken()).append("/");
            result.add(subpath.toString());
        }
        return result;
    }

    public CategoryCollection getDescendants() {
        DataQuery dq = this.getSession().retrieveQuery("com.arsdigita.categorization.categorySubtree");
        dq.setParameter("id", this.getID());
        return new CategoryCollection(new DataQueryDataCollectionAdapter(dq, "categorySubtree"));
    }

    public CategorizedCollection getDescendantObjects() {
        return this.getDescendantObjects("com.arsdigita.kernel.ACSObject", "categories.roTransParents");
    }

    private static String appendID(String path) {
        StringBuffer sb = new StringBuffer(path.length() + 3);
        sb.append(path).append(".").append("id");
        return sb.toString();
    }

    public CategorizedCollection getDescendantObjects(String objectType, String path) {
        s_log.info((Object)("retrieving objectType=" + objectType + "; path=" + path));
        CategorizedCollection result = new CategorizedCollection(this.getSession().retrieve(objectType));
        result.addEqualsFilter(Category.appendID(path), this.getID());
        return result;
    }

    public Category[] getChildrenByURL(String path) {
        LinkedList<Category> children = new LinkedList<Category>();
        TokenizedPath urlParts = new TokenizedPath(path);
        Category current = this;
        children.add(current);
        while (urlParts.next()) {
            CategoryCollection cats = current.getChildren();
            cats.addEqualsFilter(URL, urlParts.getToken());
            if (cats.next()) {
                current = cats.getCategory();
                children.add(current);
                cats.close();
                continue;
            }
            return null;
        }
        return children.toArray(new Category[0]);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append("name=").append(this.getName()).append("; ");
        result.append("oid=").append(this.getOID());
        return result.toString();
    }

    private static DataCollection getRootCategoriesAssoc(ACSObject acsObj) {
        if (acsObj == null) {
            throw new NullPointerException("acsObj");
        }
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.categorization.UseContext");
        dc.addFilter("categoryOwner.id = :ownerID").set("ownerID", acsObj.getID());
        return dc;
    }

    public static Category getRootForObject(ACSObject object) {
        return Category.getRootForObject(object, null);
    }

    public static RootCategoryCollection getRootCategories(ACSObject acsObj) {
        return new RootCategoryCollection(Category.getRootCategoriesAssoc(acsObj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Category getRootForObject(ACSObject object, String context) {
        DataObject triple;
        DataCollection cats;
        block6: {
            Category category;
            cats = Category.getRootCategoriesAssoc(object);
            cats.addEqualsFilter(USE_CONTEXT, context);
            triple = null;
            try {
                if (!cats.next()) break block6;
                triple = cats.getDataObject();
                category = (Category)DomainObjectFactory.newInstance((DataObject)triple.get(ROOT_CATEGORY));
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (cats.next()) {
                    DataObject secondRoot = cats.getDataObject();
                    cats.close();
                    throw new IllegalStateException("there is more than one root for object:\n" + object + "\nfirst root: " + triple + "\nsecond root: " + secondRoot);
                }
                cats.close();
                throw throwable;
            }
            if (cats.next()) {
                DataObject secondRoot = cats.getDataObject();
                cats.close();
                throw new IllegalStateException("there is more than one root for object:\n" + object + "\nfirst root: " + triple + "\nsecond root: " + secondRoot);
            }
            cats.close();
            return category;
        }
        s_log.debug((Object)"no triples, returning null");
        Category category = null;
        Object var6_7 = null;
        if (cats.next()) {
            DataObject secondRoot = cats.getDataObject();
            cats.close();
            throw new IllegalStateException("there is more than one root for object:\n" + object + "\nfirst root: " + triple + "\nsecond root: " + secondRoot);
        }
        cats.close();
        return category;
    }

    public static void setRootForObject(ACSObject acsObj, Category root) {
        Category.setRootForObject(acsObj, root, null);
    }

    public static void setRootForObject(ACSObject acsObj, Category rootCat, String context) {
        DataCollection rootCats = Category.getRootCategoriesAssoc(acsObj);
        rootCats.addEqualsFilter(USE_CONTEXT, context);
        if (rootCats.next()) {
            DataObject triple = rootCats.getDataObject();
            triple.set(ROOT_CATEGORY, DomainServiceInterfaceExposer.getDataObject(rootCat));
            rootCats.close();
            return;
        }
        rootCats.close();
        s_log.debug((Object)"did not find root, creating a new one");
        DataObject triple = SessionManager.getSession().create("com.arsdigita.categorization.UseContext");
        try {
            triple.set("id", Sequences.getNextValue());
        }
        catch (SQLException ex) {
            throw new UncheckedWrapperException(ex);
        }
        triple.set(CATEGORY_OWNER, DomainServiceInterfaceExposer.getDataObject(acsObj));
        triple.set(ROOT_CATEGORY, DomainServiceInterfaceExposer.getDataObject(rootCat));
        triple.set(USE_CONTEXT, context);
    }

    private static boolean equal(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null) {
            return Category.equal(str2, str1);
        }
        return str1.equals(str2);
    }

    public static void clearRootForObject(ACSObject object) {
        Category.clearRootForObject(object, null);
    }

    public static void clearRootForObject(ACSObject object, String context) {
        DataCollection dc = Category.getRootCategoriesAssoc(object);
        dc.addEqualsFilter(USE_CONTEXT, context);
        if (dc.next()) {
            dc.getDataObject().delete();
        }
        dc.close();
    }

    public boolean canEdit() {
        return PermissionService.checkPermission(new PermissionDescriptor(PrivilegeDescriptor.EDIT, this, Kernel.getContext().getParty()));
    }

    public boolean canDelete() {
        return PermissionService.checkPermission(new PermissionDescriptor(PrivilegeDescriptor.DELETE, this, Kernel.getContext().getParty()));
    }

    public boolean canMap() {
        return PermissionService.checkPermission(new PermissionDescriptor(MAP_DESCRIPTOR, this, Kernel.getContext().getParty()));
    }

    public boolean canRead() {
        return PermissionService.checkPermission(new PermissionDescriptor(PrivilegeDescriptor.READ, this, Kernel.getContext().getParty()));
    }

    public boolean canAdmin() {
        return PermissionService.checkPermission(new PermissionDescriptor(PrivilegeDescriptor.ADMIN, this, Kernel.getContext().getParty()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TokenizedPath {
        private StringTokenizer m_strTok;
        private String m_token;

        public TokenizedPath(String path) {
            this.m_strTok = new StringTokenizer(path, "/");
        }

        public boolean next() {
            if (!this.m_strTok.hasMoreTokens()) {
                return false;
            }
            this.m_token = this.m_strTok.nextToken();
            if ("".equals(this.m_token)) {
                this.m_token = null;
                return this.next();
            }
            return true;
        }

        public String getToken() {
            return this.m_token;
        }
    }
}

