/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.db.postgres;

import com.arsdigita.db.SequenceImpl;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PostgresSequenceImpl
extends SequenceImpl {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/db/postgres/PostgresSequenceImpl.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_sequenceName;

    private PostgresSequenceImpl(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public static PostgresSequenceImpl createSequence(String sequenceName) {
        return new PostgresSequenceImpl(sequenceName);
    }

    public BigDecimal getCurrentValue(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("select currval('" + this.m_sequenceName + "')");
        try {
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    BigDecimal bigDecimal = rs.getBigDecimal(1);
                    return bigDecimal;
                }
                throw new SQLException("Sequence " + this.m_sequenceName + " does not exist.");
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    public BigDecimal getNextValue(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("select nextval('" + this.m_sequenceName + "')");
        try {
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    BigDecimal bigDecimal = rs.getBigDecimal(1);
                    return bigDecimal;
                }
                throw new SQLException("Sequence " + this.m_sequenceName + " does not exist.");
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }
}

