/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.developersupport;

import com.arsdigita.developersupport.MutableInteger;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CallTree {
    private static final ThreadLocal s_instances = new ThreadLocal(){

        protected Object initialValue() {
            return new CallTree();
        }
    };
    private static final TreeType UPSIDE_DOWN = new TreeType();
    private static final TreeType RIGHT_SIDE_UP = new TreeType();
    private Map m_callSites;
    private int m_maxDepth;
    private Guard m_guard;

    private CallTree() {
    }

    public static CallTree getThreadLocal() {
        return (CallTree)s_instances.get();
    }

    public Guard start(int maxDepth) {
        if (this.m_guard != null) {
            return new Guard();
        }
        if (maxDepth < 1) {
            throw new IllegalArgumentException("maxDepth<1: " + maxDepth);
        }
        this.m_callSites = new HashMap();
        this.m_maxDepth = maxDepth;
        this.m_guard = new Guard();
        return this.m_guard;
    }

    public void end(Guard guard) {
        if (this.m_guard == guard) {
            this.m_guard = null;
        }
    }

    public void capture(String siteName) {
        List callers;
        if (this.m_guard == null) {
            return;
        }
        if (siteName == null) {
            throw new NullPointerException("siteName");
        }
        Pair pair = (Pair)this.m_callSites.get(siteName);
        if (pair == null) {
            pair = new Pair(new Tree(siteName), new Tree(siteName));
            this.m_callSites.put(siteName, pair);
        }
        if ((callers = StringUtils.getStackList(new Throwable())).size() < 2) {
            throw new IllegalStateException("running a little low on callers: " + callers);
        }
        List trimmedCallers = callers.subList(2, callers.size());
        this.splice(pair.upsideDown, trimmedCallers);
        Collections.reverse(trimmedCallers);
        this.splice(pair.rightSideUp, trimmedCallers);
    }

    private void splice(Tree tree, List callers) {
        List pared = callers.size() <= this.m_maxDepth ? callers : callers.subList(0, this.m_maxDepth);
        CallTree.spliceRecurse(tree, pared);
    }

    private static void spliceRecurse(Tree tree, List callers) {
        int listSize = callers.size();
        if (listSize == 0) {
            return;
        }
        String caller = (String)callers.get(0);
        boolean matchFound = false;
        Iterator subtrees = tree.getSubtrees().iterator();
        Tree subtree = null;
        while (subtrees.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)subtrees.next();
            subtree = pair.getTree();
            Method method = (Method)subtree.getRoot();
            if (!caller.equals(method.getName())) continue;
            method.increment();
            matchFound = true;
            break;
        }
        if (!matchFound) {
            subtree = new Tree(new Method(caller));
            tree.addSubtree(subtree);
        }
        if (listSize > 1) {
            CallTree.spliceRecurse(subtree, callers.subList(1, listSize));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.upsideDown(0, Integer.MAX_VALUE));
        sb.append(this.rightSideUp(0, Integer.MAX_VALUE));
        return sb.toString();
    }

    public String upsideDown(int relativeThreshold, int absoluteThreshold) {
        if (this.m_guard != null) {
            return "ignoring reentrant call";
        }
        return this.printTrees(relativeThreshold, absoluteThreshold, UPSIDE_DOWN);
    }

    public String rightSideUp(int relativeThreshold, int absoluteThreshold) {
        if (this.m_guard != null) {
            return "ignoring reentrant call";
        }
        return this.printTrees(relativeThreshold, absoluteThreshold, RIGHT_SIDE_UP);
    }

    private String printTrees(int relThreshold, int absThreshold, TreeType type) {
        if (relThreshold < 0 || relThreshold > 100) {
            throw new IllegalArgumentException("relThreshold out of range: " + relThreshold);
        }
        if (absThreshold < 1) {
            throw new IllegalArgumentException("absThreshold out of range: " + absThreshold);
        }
        ArrayList callSites = new ArrayList(this.m_callSites.keySet());
        Collections.sort(callSites);
        StringBuffer result = new StringBuffer();
        Iterator ii = callSites.iterator();
        while (ii.hasNext()) {
            String callSite = (String)ii.next();
            Pair pair = (Pair)this.m_callSites.get(callSite);
            if (type == UPSIDE_DOWN) {
                this.printTree(pair.upsideDown, result, relThreshold, absThreshold);
                continue;
            }
            if (type == RIGHT_SIDE_UP) {
                this.printTree(pair.rightSideUp, result, relThreshold, absThreshold);
                continue;
            }
            throw new IllegalArgumentException("unknown type");
        }
        return result.toString();
    }

    private void printTree(Tree root, StringBuffer result, int relThreshold, int absThreshold) {
        result.append(root.getRoot()).append("\n");
        Iterator subtrees = root.getSubtrees().iterator();
        while (subtrees.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)subtrees.next();
            CallTree.printTreeRecurse(pair.getTree(), result, " ", relThreshold, absThreshold);
        }
    }

    private static void printTreeRecurse(Tree tree, StringBuffer result, String indent, int relThreshold, int absThreshold) {
        Method callee = (Method)tree.getRoot();
        if (callee.getCount() < absThreshold) {
            return;
        }
        result.append(indent).append(callee).append("\n");
        Iterator ii = tree.getSubtrees().iterator();
        while (ii.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)ii.next();
            Method caller = (Method)pair.getTree().getRoot();
            if (100 * caller.getCount() / callee.getCount() < relThreshold) continue;
            CallTree.printTreeRecurse(pair.getTree(), result, indent + " ", relThreshold, absThreshold);
        }
    }

    private static class Method {
        private final String m_name;
        private final MutableInteger m_counter;

        public Method(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.m_name = name.intern();
            this.m_counter = new MutableInteger();
            this.m_counter.increment();
        }

        public String getName() {
            return this.m_name;
        }

        public void increment() {
            this.m_counter.increment();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_counter).append(": ").append(this.m_name);
            return sb.toString();
        }

        public int getCount() {
            return this.m_counter.intValue();
        }
    }

    private static class Pair {
        Tree upsideDown;
        Tree rightSideUp;

        Pair(Tree upsideDown, Tree rightSideUp) {
            this.upsideDown = upsideDown;
            this.rightSideUp = rightSideUp;
        }
    }

    private static final class TreeType {
        private TreeType() {
        }
    }

    public static final class Guard {
    }
}

