/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.developersupport;

import com.arsdigita.developersupport.MutableInteger;
import com.arsdigita.util.Tree;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public final class Counter {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$developersupport$Counter == null ? (class$com$arsdigita$developersupport$Counter = Counter.class$("com.arsdigita.developersupport.Counter")) : class$com$arsdigita$developersupport$Counter));
    private static final ThreadLocal s_counters = new ThreadLocal(){

        protected Object initialValue() {
            return new Counter();
        }
    };
    private static final DateFormat DATE_FMT = new SimpleDateFormat("HH:mm:ss.S");
    private static final DecimalFormat DURATION_FMT = new DecimalFormat();
    private Tree m_root;
    private Tree m_current;
    private long m_tStamp;
    private final Stack m_stack = new Stack();
    static /* synthetic */ Class class$com$arsdigita$developersupport$Counter;

    private Counter() {
        StringBuffer rootCtxt = new StringBuffer(128);
        rootCtxt.append("thread: ").append(Thread.currentThread().getName());
        this.m_current = this.m_root = new Tree(this.m_stack.push(new Context(rootCtxt.toString())));
        this.m_tStamp = System.currentTimeMillis();
    }

    public static Counter getCounter() {
        return (Counter)s_counters.get();
    }

    public Context start(String context) {
        ((Context)this.m_current.getRoot()).pause();
        Context result = this.m_stack.push(new Context(context));
        Tree child = new Tree(result);
        this.m_current.addSubtree(child);
        this.m_current = child;
        return result;
    }

    public void end(Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Context current = (Context)this.m_stack.pop();
        if (!current.equals(context)) {
            throw new ContextMismatchException(current, context);
        }
        current.pause();
        this.m_current = this.m_current.getParent();
        ((Context)this.m_current.getRoot()).restart();
    }

    public void increment(String action) {
        this.currentContext().increment(action);
    }

    private Context currentContext() {
        return (Context)this.m_stack.peek();
    }

    public void log(String message) {
        s_log.debug((Object)message);
        s_log.debug((Object)this);
    }

    private static void duration(StringBuffer sb, long start, long end, long total) {
        if (end < start) {
            throw new IllegalArgumentException("end<start: start=" + start + ", end=" + end);
        }
        if (total > end - start) {
            throw new IllegalArgumentException("total>start-end; start=" + start + ", end=" + end + ", total=" + total);
        }
        sb.append("started: ");
        sb.append(DATE_FMT.format(new Date(start)));
        sb.append("; ended: ").append(DATE_FMT.format(new Date(end)));
        sb.append("; duration: ");
        sb.append(DURATION_FMT.format(total)).append(" ms");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Context rootCtxt = (Context)this.m_root.getRoot();
        sb.append(rootCtxt.getContext()).append("\n");
        sb.append("counter ");
        long finish = System.currentTimeMillis();
        Counter.duration(sb, this.m_tStamp, finish, finish - this.m_tStamp);
        sb.append("\n");
        Iterator subtrees = this.m_root.getSubtrees().iterator();
        while (subtrees.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)subtrees.next();
            this.toString(pair.getTree(), sb, "");
        }
        return sb.toString();
    }

    private void toString(Tree tree, StringBuffer result, String indent) {
        Context context = (Context)tree.getRoot();
        result.append(context.toString(indent));
        Iterator subtrees = tree.getSubtrees().iterator();
        while (subtrees.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)subtrees.next();
            this.toString(pair.getTree(), result, indent + "  ");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DURATION_FMT.setGroupingSize(3);
        DURATION_FMT.setGroupingUsed(true);
    }

    public static final class ContextMismatchException
    extends RuntimeException {
        private final Context m_actual;
        private final Context m_expected;

        public ContextMismatchException(Context expected, Context actual) {
            this.m_actual = actual;
            this.m_expected = expected;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected: ").append(this.m_expected.debug());
            sb.append("; Actual: ").append(this.m_actual.debug());
            return sb.toString();
        }
    }

    public static final class Context {
        private final String m_context;
        private final Map m_actions;
        private final long m_started;
        private long m_restarted;
        private long m_runningTotal;
        private long m_finished;
        private boolean m_inContext;

        private Context(String context) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            this.m_context = context;
            this.m_actions = new HashMap();
            this.m_restarted = this.m_started = System.currentTimeMillis();
            this.m_runningTotal = 0L;
            this.m_inContext = true;
        }

        void increment(String action) {
            if (!this.m_inContext) {
                throw new IllegalStateException("not in context: " + this.debug());
            }
            MutableInteger counter = (MutableInteger)this.m_actions.get(action);
            if (counter == null) {
                counter = new MutableInteger();
                this.m_actions.put(action, counter);
            }
            counter.increment();
        }

        public void pause() {
            if (!this.m_inContext) {
                throw new IllegalStateException("not in context: " + this.debug());
            }
            this.m_inContext = false;
            this.m_finished = System.currentTimeMillis();
            this.m_runningTotal += this.m_finished - this.m_restarted;
        }

        public void restart() {
            if (this.m_inContext) {
                throw new IllegalStateException("in context: " + this.debug());
            }
            this.m_inContext = true;
            this.m_restarted = System.currentTimeMillis();
        }

        String debug() {
            StringBuffer sb = new StringBuffer();
            String d = "; ";
            sb.append("context=").append(this.m_context).append("; ");
            sb.append("id=").append(this.hashCode()).append("; ");
            sb.append("actions=").append(this.m_actions).append("; ");
            sb.append("started=").append(this.m_started).append("; ");
            sb.append("restarted=").append(this.m_restarted).append("; ");
            sb.append("finished=").append(this.m_finished).append("; ");
            sb.append("total=").append(this.m_runningTotal).append("; ");
            sb.append("inContext=").append(this.m_inContext);
            return sb.toString();
        }

        public String toString() {
            return this.toString("");
        }

        String toString(String indent) {
            StringBuffer sb = new StringBuffer();
            sb.append(indent).append(this.m_context).append("@");
            sb.append(this.hashCode()).append(": ");
            Counter.duration(sb, this.m_started, this.m_finished, this.m_runningTotal);
            sb.append(":\n");
            ArrayList actions = new ArrayList(this.m_actions.keySet());
            Collections.sort(actions);
            Iterator ii = actions.iterator();
            while (ii.hasNext()) {
                String key = (String)ii.next();
                sb.append(indent).append("  ").append(key).append(": ");
                sb.append(this.m_actions.get(key)).append("\n");
            }
            return sb.toString();
        }

        String getContext() {
            return this.m_context;
        }
    }
}

