/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.developersupport;

import com.arsdigita.developersupport.LoggerConfigurator;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class LoggingProxyFactory
implements LoggerConfigurator {
    private Config m_config = new Config();
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$com$arsdigita$developersupport$LoggingProxy;
    static /* synthetic */ Class class$com$arsdigita$developersupport$LoggingProxyFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$developersupport$LoggerConfigurator;

    public void setLogger(String logger) {
        this.m_config.setLogger(logger);
    }

    public void setLevel(String level) {
        this.m_config.setLevel(level);
    }

    public void enableStackTraces() {
        this.m_config.enableStackTraces();
    }

    public Object newLoggingProxy(Object proxiedObject, Class iface, boolean configurable) {
        Class[] classArray;
        Assert.exists(iface, class$java$lang$Class == null ? (class$java$lang$Class = LoggingProxyFactory.class$("java.lang.Class")) : class$java$lang$Class);
        Assert.truth(iface.isInstance(proxiedObject), "proxiedObject is instance of iface");
        if (configurable) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = iface;
            classArray = classArray2;
            classArray2[1] = class$com$arsdigita$developersupport$LoggingProxy == null ? (class$com$arsdigita$developersupport$LoggingProxy = LoggingProxyFactory.class$("com.arsdigita.developersupport.LoggingProxy")) : class$com$arsdigita$developersupport$LoggingProxy;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = iface;
        }
        Class[] ifaces = classArray;
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces, (InvocationHandler)new Handler(this.m_config, proxiedObject));
    }

    public Object newLoggingProxy(Object proxiedObject, Class iface) {
        return this.newLoggingProxy(proxiedObject, iface, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Handler
    implements InvocationHandler {
        private static final Method s_getProxiedObject;
        private Config m_config;
        private Object m_proxiedObject;
        private boolean m_configCloned;

        public Handler(Config config, Object obj) {
            this.m_config = config;
            this.m_proxiedObject = obj;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(s_getProxiedObject)) {
                return this.m_proxiedObject;
            }
            if ((class$com$arsdigita$developersupport$LoggerConfigurator == null ? (class$com$arsdigita$developersupport$LoggerConfigurator = LoggingProxyFactory.class$("com.arsdigita.developersupport.LoggerConfigurator")) : class$com$arsdigita$developersupport$LoggerConfigurator).equals(method.getDeclaringClass())) {
                if (!this.m_configCloned) {
                    this.m_config = this.m_config.copy();
                    this.m_configCloned = true;
                }
                return method.invoke((Object)this.m_config, args);
            }
            this.m_config.log(method, args);
            return method.invoke(this.m_proxiedObject, args);
        }

        static {
            try {
                s_getProxiedObject = (class$com$arsdigita$developersupport$LoggingProxy == null ? (class$com$arsdigita$developersupport$LoggingProxy = LoggingProxyFactory.class$("com.arsdigita.developersupport.LoggingProxy")) : class$com$arsdigita$developersupport$LoggingProxy).getMethod("getProxiedObject", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new UncheckedWrapperException("failed", ex);
            }
        }
    }

    private static class Config
    implements LoggerConfigurator {
        private Logger m_log = Logger.getLogger((Class)(class$com$arsdigita$developersupport$LoggingProxyFactory == null ? (class$com$arsdigita$developersupport$LoggingProxyFactory = LoggingProxyFactory.class$("com.arsdigita.developersupport.LoggingProxyFactory")) : class$com$arsdigita$developersupport$LoggingProxyFactory));
        private Level m_level = Level.DEBUG;
        private boolean m_logStacks;
        private Throwable m_stack = new Throwable();

        public void setLogger(String log) {
            Assert.exists(log, class$java$lang$String == null ? (class$java$lang$String = LoggingProxyFactory.class$("java.lang.String")) : class$java$lang$String);
            this.m_log = Logger.getLogger((String)log);
        }

        public void setLevel(String level) {
            Assert.exists(level, class$java$lang$String == null ? (class$java$lang$String = LoggingProxyFactory.class$("java.lang.String")) : class$java$lang$String);
            this.m_level = Level.toLevel((String)level);
        }

        public void enableStackTraces() {
            this.m_logStacks = true;
        }

        public Config copy() {
            Config copy = new Config();
            copy.m_log = this.m_log;
            copy.m_level = this.m_level;
            copy.m_logStacks = this.m_logStacks;
            copy.m_stack = new Throwable();
            return copy;
        }

        public void log(Method method, Object[] args) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("invoked ").append(method.getDeclaringClass().getName());
            sb.append(".").append(method.getName());
            if (this.m_logStacks) {
                this.m_stack.fillInStackTrace();
                this.m_log.log((Priority)this.m_level, (Object)sb, this.m_stack);
            } else {
                this.m_log.log((Priority)this.m_level, (Object)sb);
            }
        }

        public void log(Object msg) {
            System.err.println(msg);
            if (this.m_logStacks) {
                this.m_stack.fillInStackTrace();
                this.m_log.log((Priority)this.m_level, msg, this.m_stack);
            } else {
                this.m_log.log((Priority)this.m_level, msg);
            }
        }
    }
}

