/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dispatcher;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.developersupport.DeveloperSupportListener;
import com.arsdigita.dispatcher.AbortRequestSignal;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherConstants;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.InitialRequestContext;
import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.dispatcher.RequestEvent;
import com.arsdigita.dispatcher.RequestListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseDispatcherServlet
extends HttpServlet
implements Dispatcher,
DispatcherConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/BaseDispatcherServlet.java#25 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dispatcher$BaseDispatcherServlet == null ? (class$com$arsdigita$dispatcher$BaseDispatcherServlet = BaseDispatcherServlet.class$("com.arsdigita.dispatcher.BaseDispatcherServlet")) : class$com$arsdigita$dispatcher$BaseDispatcherServlet));
    private static final int NOT_FOUND = 0;
    private static final int STATIC_FILE = 1;
    private static final int JSP_FILE = 2;
    private static final String WEB_XML_22_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    private static final String WEB_XML_23_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private static Vector s_listenerList = new Vector();
    private static Vector s_activeList = new Vector();
    private List m_welcomeFiles = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$dispatcher$BaseDispatcherServlet;

    public synchronized void init() throws ServletException {
        super.init();
        try {
            File file = new File(this.getServletContext().getRealPath("/WEB-INF/web.xml"));
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            SAXParser parser = spf.newSAXParser();
            parser.parse(file, (DefaultHandler)new WebXMLReader());
        }
        catch (SAXException se) {
            s_log.error((Object)"error in init", (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            s_log.error((Object)"error in init", (Throwable)pce);
        }
        catch (IOException ioe) {
            s_log.error((Object)"error in init", (Throwable)ioe);
        }
        if (this.m_welcomeFiles.isEmpty()) {
            this.m_welcomeFiles.add("index.jsp");
            this.m_welcomeFiles.add("index.html");
        }
        this.getServletContext().setAttribute("com.arsdigita.dispatcher.welcomefiles", (Object)this.m_welcomeFiles);
    }

    public static void addRequestListener(RequestListener rl) {
        s_listenerList.add(rl);
    }

    protected abstract RequestContext authenticateUser(HttpServletRequest var1, HttpServletResponse var2, RequestContext var3) throws RedirectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("\n*** *** *** *** *** ***\nServicing request for URL '" + req.getRequestURI() + "'\n" + "*** *** *** *** *** ***"));
        }
        boolean reentrant = true;
        RequestContext reqCtx = DispatcherHelper.getRequestContext(req);
        boolean finishedNormal = false;
        DispatcherHelper.setRequest(req);
        if (this.trailingSlashRedirect(req, resp)) {
            return;
        }
        int concreteFileType = this.concreteFileType(req);
        if (concreteFileType == 1) {
            s_log.debug((Object)"Setting world cache headers on static file");
            DispatcherHelper.cacheForWorld(resp);
            DispatcherHelper.forwardRequestByName("default", req, resp, this.getServletContext());
            return;
        }
        try {
            block28: {
                try {
                    if (req.getAttribute("com.arsdigita.dispatcher.inside_request") == null) {
                        reentrant = false;
                        this.waitForPreviousRequestToFinish(req);
                        String requestId = Thread.currentThread().getName() + "|" + System.currentTimeMillis();
                        req.setAttribute("com.arsdigita.dispatcher.inside_request", (Object)requestId);
                        s_activeList.add(requestId);
                        DeveloperSupport.startStage("BaseDispatcherServlet.service()");
                        try {
                            StartRequestRecord srr = this.startRequest(req, resp);
                            reqCtx = srr.m_reqCtx;
                            req = srr.m_req;
                            s_log.debug((Object)("After startRequest the request is now " + req));
                        }
                        catch (RedirectException re) {
                            String url = re.getRedirectURL();
                            resp.sendRedirect(resp.encodeRedirectURL(url));
                            Object var11_18 = null;
                            if (reentrant) return;
                            DeveloperSupport.endStage("BaseDispatcherServlet.service()");
                            this.fireFinishedListener(new RequestEvent(req, resp, reqCtx, false, finishedNormal));
                            Object requestId2 = req.getAttribute("com.arsdigita.dispatcher.inside_request");
                            Vector vector = s_activeList;
                            synchronized (vector) {
                                s_activeList.remove(requestId2);
                                s_activeList.notifyAll();
                            }
                            req.removeAttribute("com.arsdigita.dispatcher.inside_request");
                            return;
                        }
                    } else if (((req = DispatcherHelper.maybeWrapRequest(req)).getAttribute("javax.servlet.error.request_uri") != null || req.getAttribute("javax.servlet.jsp.jspException") != null) && reqCtx instanceof InitialRequestContext) {
                        ((InitialRequestContext)reqCtx).initializeURLFromRequest(req, true);
                    }
                    finishedNormal = false;
                    if (concreteFileType == 2) {
                        DispatcherHelper.forwardRequestByName("jsp", req, resp);
                    } else {
                        this.dispatch(req, resp, reqCtx);
                    }
                    if (req.getAttribute("javax.servlet.jsp.jspException") != null) break block28;
                    finishedNormal = true;
                }
                catch (AbortRequestSignal ars) {
                    finishedNormal = true;
                    Object var11_20 = null;
                    if (reentrant) return;
                    DeveloperSupport.endStage("BaseDispatcherServlet.service()");
                    this.fireFinishedListener(new RequestEvent(req, resp, reqCtx, false, finishedNormal));
                    Object requestId2 = req.getAttribute("com.arsdigita.dispatcher.inside_request");
                    Vector vector2 = s_activeList;
                    synchronized (vector2) {
                        s_activeList.remove(requestId2);
                        s_activeList.notifyAll();
                    }
                    req.removeAttribute("com.arsdigita.dispatcher.inside_request");
                    return;
                }
                catch (IOException ioe) {
                    s_log.error((Object)"error in BaseDispatcherServlet", (Throwable)ioe);
                    throw ioe;
                }
                catch (ServletException se) {
                    Throwable rootError;
                    Throwable t = se;
                    do {
                        rootError = t;
                    } while ((t = t.getRootCause()) instanceof ServletException);
                    if (t != null) {
                        rootError = t;
                    }
                    if (rootError != null && rootError instanceof AbortRequestSignal) {
                        finishedNormal = true;
                        Object var11_21 = null;
                        if (reentrant) return;
                        DeveloperSupport.endStage("BaseDispatcherServlet.service()");
                        this.fireFinishedListener(new RequestEvent(req, resp, reqCtx, false, finishedNormal));
                        Object requestId2 = req.getAttribute("com.arsdigita.dispatcher.inside_request");
                        Vector vector3 = s_activeList;
                        synchronized (vector3) {
                            s_activeList.remove(requestId2);
                            s_activeList.notifyAll();
                        }
                        req.removeAttribute("com.arsdigita.dispatcher.inside_request");
                        return;
                    }
                    if (rootError != null && rootError instanceof RedirectSignal) {
                        s_log.debug((Object)"rethrowing RedirectSignal", rootError);
                        throw (RedirectSignal)rootError;
                    }
                    s_log.error((Object)"error in BaseDispatcherServlet", rootError);
                    throw new ServletException(rootError);
                }
                catch (RuntimeException re) {
                    s_log.error((Object)"error in BaseDispatcherServlet", (Throwable)re);
                    throw re;
                }
                catch (Error error) {
                    s_log.error((Object)"error in BaseDispatcherServlet", (Throwable)error);
                    throw error;
                }
            }
            Object var11_19 = null;
            if (reentrant) return;
            DeveloperSupport.endStage("BaseDispatcherServlet.service()");
            this.fireFinishedListener(new RequestEvent(req, resp, reqCtx, false, finishedNormal));
            Object requestId2 = req.getAttribute("com.arsdigita.dispatcher.inside_request");
            Vector vector = s_activeList;
            synchronized (vector) {
                s_activeList.remove(requestId2);
                s_activeList.notifyAll();
            }
            req.removeAttribute("com.arsdigita.dispatcher.inside_request");
            return;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            if (reentrant) throw throwable;
            DeveloperSupport.endStage("BaseDispatcherServlet.service()");
            this.fireFinishedListener(new RequestEvent(req, resp, reqCtx, false, finishedNormal));
            Object requestId2 = req.getAttribute("com.arsdigita.dispatcher.inside_request");
            Vector vector = s_activeList;
            synchronized (vector) {
                s_activeList.remove(requestId2);
                s_activeList.notifyAll();
            }
            req.removeAttribute("com.arsdigita.dispatcher.inside_request");
            throw throwable;
        }
    }

    private StartRequestRecord startRequest(HttpServletRequest req, HttpServletResponse resp) throws RedirectException, IOException, ServletException {
        req = DispatcherHelper.maybeWrapRequest(req);
        RequestContext reqCtx = new InitialRequestContext(req, this.getServletContext());
        this.fireStartListener(new RequestEvent(req, resp, reqCtx, true));
        reqCtx = this.authenticateUser(req, resp, reqCtx);
        DispatcherHelper.setRequestContext(req, reqCtx);
        return new StartRequestRecord(reqCtx, req);
    }

    protected void fireFinishedListener(RequestEvent evt) {
        for (int i = 0; i < s_listenerList.size(); ++i) {
            try {
                ((RequestListener)s_listenerList.get(i)).requestFinished(evt);
                continue;
            }
            catch (Exception e) {
                s_log.error((Object)("Error running request finished listener " + s_listenerList.get(i) + " (#" + i + ")"), (Throwable)e);
            }
        }
    }

    protected void fireStartListener(RequestEvent evt) {
        for (int i = 0; i < s_listenerList.size(); ++i) {
            ((RequestListener)s_listenerList.get(i)).requestStarted(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPreviousRequestToFinish(HttpServletRequest req) {
        Object sema;
        HttpSession sess = req.getSession(false);
        if (sess != null && (sema = sess.getAttribute("com.arsdigita.dispatcher.redirect_semaphore")) != null) {
            while (s_activeList.indexOf(sema) != -1) {
                try {
                    Vector vector = s_activeList;
                    synchronized (vector) {
                        s_activeList.wait();
                    }
                }
                catch (InterruptedException ie) {
                }
            }
            sess.removeAttribute("com.arsdigita.dispatcher.redirect_semaphore");
        }
    }

    private int concreteFileType(HttpServletRequest req) throws ServletException, IOException {
        String path = DispatcherHelper.getCurrentResourcePath(req);
        ServletContext sctx = this.getServletContext();
        File realFile = new File(sctx.getRealPath(path));
        if (realFile.exists() && (!realFile.isDirectory() || this.hasWelcomeFile(realFile))) {
            if (realFile.getName().endsWith(".jsp")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean hasWelcomeFile(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir must be a directory");
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (this.m_welcomeFiles.indexOf(files[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean trailingSlashRedirect(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = DispatcherHelper.getCurrentResourcePath(req);
        if (path.lastIndexOf(".") <= path.lastIndexOf("/") && !path.endsWith("/")) {
            String targetURL = req.getContextPath() + path + "/";
            String query = req.getQueryString();
            if (query != null && query.length() > 0) {
                targetURL = targetURL + "?" + query;
            }
            resp.sendRedirect(resp.encodeRedirectURL(targetURL));
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BaseDispatcherServlet.addRequestListener(new RequestListener(){

            public void requestStarted(RequestEvent re) {
                DispatcherHelper.setRequest(re.getRequest());
            }

            public void requestFinished(RequestEvent re) {
            }
        });
        BaseDispatcherServlet.addRequestListener(new RequestListener(){

            public void requestStarted(RequestEvent re) {
                Kernel.getContext().getTransaction().begin();
            }

            public void requestFinished(RequestEvent re) {
                Kernel.getContext().getTransaction().end();
            }
        });
        DeveloperSupport.addListener(new DeveloperSupportListener(){

            public void requestStart(Object request) {
                s_log.debug((Object)("DS: requestStart: " + request));
            }

            public void requestEnd(Object request) {
                s_log.debug((Object)("DS: requestEnd: " + request));
            }
        });
    }

    private class WebXMLReader
    extends DefaultHandler {
        StringBuffer m_buffer = new StringBuffer();

        private WebXMLReader() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (BaseDispatcherServlet.WEB_XML_22_PUBLIC_ID.equals(publicId) || BaseDispatcherServlet.WEB_XML_23_PUBLIC_ID.equals(publicId)) {
                StringReader reader = new StringReader(" ");
                return new InputSource(reader);
            }
            try {
                return super.resolveEntity(publicId, systemId);
            }
            catch (Exception e) {
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                throw new UncheckedWrapperException("Resolve Error", e);
            }
        }

        public void characters(char[] ch, int start, int len) {
            for (int i = 0; i < len; ++i) {
                this.m_buffer.append(ch[start + i]);
            }
        }

        public void endElement(String uri, String localName, String qname) {
            if (qname.equals("welcome-file-list")) {
                String[] welcomeFiles = StringUtils.split(this.m_buffer.toString(), ',');
                for (int i = 0; i < welcomeFiles.length; ++i) {
                    BaseDispatcherServlet.this.m_welcomeFiles.add(welcomeFiles[i].trim());
                }
            }
            this.m_buffer = new StringBuffer();
        }
    }

    private class StartRequestRecord {
        RequestContext m_reqCtx;
        HttpServletRequest m_req;

        public StartRequestRecord(RequestContext rc, HttpServletRequest req) {
            this.m_reqCtx = rc;
            this.m_req = req;
        }
    }
}

