/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dispatcher;

import com.arsdigita.dispatcher.AbortRequestSignal;
import com.arsdigita.dispatcher.DirectoryListingException;
import com.arsdigita.dispatcher.DispatcherConfig;
import com.arsdigita.dispatcher.DispatcherConstants;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.dispatcher.ParameterProvider;
import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.URLRewriter;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import javax.mail.MessagingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public final class DispatcherHelper
implements DispatcherConstants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dispatcher$DispatcherHelper == null ? (class$com$arsdigita$dispatcher$DispatcherHelper = DispatcherHelper.class$("com.arsdigita.dispatcher.DispatcherHelper")) : class$com$arsdigita$dispatcher$DispatcherHelper));
    private static String s_webappCtx;
    private static String s_staticURL;
    private static boolean s_cachingActive;
    private static int s_defaultExpiry;
    private static DispatcherConfig s_config;
    public static final SimpleDateFormat rfc1123_formatter;
    private static ThreadLocal s_request;
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/DispatcherHelper.java#40 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$dispatcher$DispatcherHelper;

    private DispatcherHelper() {
    }

    public static int getDefaultCacheExpiry() {
        return s_defaultExpiry;
    }

    static void setDefaultCacheExpiry(int expiry) {
        s_defaultExpiry = expiry;
    }

    public static boolean isCachingActive() {
        return s_cachingActive;
    }

    static void setCachingActive(boolean status) {
        s_cachingActive = status;
    }

    public static String getCurrentResourcePath(HttpServletRequest req) {
        int startIndex;
        String str;
        String attr = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (attr == null) {
            str = req.getRequestURI();
            if (str.indexOf("?") > -1) {
                str = str.substring(0, str.indexOf("?"));
            }
        } else {
            str = attr;
        }
        if ((str = str.substring(startIndex = req.getContextPath().length())).startsWith("//")) {
            str = str.substring(1);
        }
        return str;
    }

    public static RequestContext getRequestContext(HttpServletRequest req) {
        return (RequestContext)req.getAttribute("com.arsdigita.dispatcher.RequestContext");
    }

    public static RequestContext getRequestContext() {
        return (RequestContext)DispatcherHelper.getRequest().getAttribute("com.arsdigita.dispatcher.RequestContext");
    }

    public static String getDispatcherPrefix(HttpServletRequest req) {
        return (String)req.getAttribute("com.arsdigita.dispatcher.DispatcherPrefix");
    }

    public static void setDispatcherPrefix(HttpServletRequest req, String val) {
        req.setAttribute("com.arsdigita.dispatcher.DispatcherPrefix", (Object)val);
    }

    public static void setRequestContext(HttpServletRequest req, RequestContext ac) {
        req.setAttribute("com.arsdigita.dispatcher.RequestContext", (Object)ac);
    }

    private static void forwardHelper(RequestDispatcher rd, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object attr = req.getAttribute("javax.servlet.include.request_uri");
        req = DispatcherHelper.restoreOriginalRequest(req);
        s_log.debug((Object)("Forwarding the request object " + req));
        if (attr != null) {
            rd.include((ServletRequest)req, (ServletResponse)resp);
            req.setAttribute("javax.servlet.include.request_uri", attr);
        } else {
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (IllegalStateException e) {
                rd.include((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    public static void forwardRequestByPath(String path, HttpServletRequest req, HttpServletResponse resp, ServletContext sctx) throws IOException, ServletException {
        RequestDispatcher rd = sctx.getRequestDispatcher(path);
        DispatcherHelper.forwardHelper(rd, req, resp);
    }

    public static void forwardRequestByPath(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServletContext sctx = DispatcherHelper.getRequestContext(req).getServletContext();
        DispatcherHelper.forwardRequestByPath(path, req, resp, sctx);
    }

    public static void forwardRequestByPath(String path, PageContext pageContext) throws IOException, ServletException {
        ServletRequest req = pageContext.getRequest();
        Object attr = req.getAttribute("javax.servlet.include.request_uri");
        if (attr != null) {
            pageContext.include(path);
            req.setAttribute("javax.servlet.include.request_uri", attr);
        } else {
            try {
                pageContext.forward(path);
            }
            catch (IllegalStateException e) {
                pageContext.include(path);
            }
        }
    }

    public static void forwardRequestByName(String name, HttpServletRequest req, HttpServletResponse resp, ServletContext sctx) throws IOException, ServletException {
        RequestDispatcher rd = sctx.getNamedDispatcher(name);
        DispatcherHelper.forwardHelper(rd, req, resp);
    }

    public static void forwardRequestByName(String name, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServletContext sc = DispatcherHelper.getRequestContext(req).getServletContext();
        DispatcherHelper.forwardRequestByName(name, req, resp, sc);
    }

    public static String resolveAbstractFile(File abstractFile, RequestContext actx) throws RedirectException, DirectoryListingException, FileNotFoundException {
        s_log.debug((Object)"Resolving abstract file");
        File dirToSearch = null;
        String fStr = abstractFile.getAbsolutePath();
        int lastSlash = fStr.lastIndexOf(File.separatorChar);
        String filenameStub = fStr.substring(lastSlash + 1);
        boolean indexPage = false;
        if (abstractFile.isDirectory()) {
            if (!actx.getOriginalURL().endsWith("/")) {
                throw new RedirectException(actx.getOriginalURL() + "/");
            }
            dirToSearch = abstractFile;
            filenameStub = "index";
            indexPage = true;
        } else {
            if (abstractFile.exists()) {
                return "";
            }
            dirToSearch = new File(abstractFile.getParent());
        }
        File[] filesInDir = dirToSearch.listFiles();
        String[] extensionSearchList = new String[]{".jsp"};
        if (filesInDir != null) {
            for (int j = 0; j < extensionSearchList.length; ++j) {
                File possibleFile = new File(dirToSearch, filenameStub + extensionSearchList[j]);
                for (int i = 0; i < filesInDir.length; ++i) {
                    if (!filesInDir[i].equals(possibleFile)) continue;
                    return (indexPage ? File.separator + "index" : "") + extensionSearchList[j];
                }
            }
            File abstractFileIndex = new File(abstractFile, "index");
            for (int i = 0; i < filesInDir.length; ++i) {
                String fidStr = filesInDir[i].getPath();
                int lastDot = fidStr.lastIndexOf(".");
                if (lastDot == -1) continue;
                File possibleStub = new File(fidStr.substring(0, lastDot));
                if (indexPage && abstractFileIndex.equals(possibleStub)) {
                    return "index" + fidStr.substring(lastDot);
                }
                if (!abstractFile.equals(possibleStub)) continue;
                return fidStr.substring(lastDot);
            }
        }
        if (!abstractFile.isDirectory()) {
            throw new FileNotFoundException(abstractFile.getAbsolutePath());
        }
        throw new DirectoryListingException(abstractFile.getAbsolutePath());
    }

    public static HttpServletRequest restoreOriginalRequest(HttpServletRequest req) {
        if (req instanceof MultipartHttpServletRequest) {
            HttpServletRequest oldReq = (HttpServletRequest)req.getAttribute("com.arsdigita.dispatcher.OriginalRequest");
            oldReq.setAttribute("com.arsdigita.dispatcher.WrappedRequest", (Object)req);
            req = oldReq;
        }
        return req;
    }

    public static HttpServletRequest restoreRequestWrapper(HttpServletRequest req) {
        Object maybeWrappedReq = req.getAttribute("com.arsdigita.dispatcher.WrappedRequest");
        if (maybeWrappedReq != null && !(req instanceof MultipartHttpServletRequest)) {
            req = (HttpServletRequest)maybeWrappedReq;
        }
        return req;
    }

    public static HttpServletRequest maybeWrapRequest(HttpServletRequest sreq) throws IOException, ServletException {
        String type = sreq.getContentType();
        if (sreq.getMethod().toUpperCase().equals("POST") && type != null && type.toLowerCase().startsWith("multipart")) {
            HttpServletRequest orig = sreq;
            HttpServletRequest previous = DispatcherHelper.restoreRequestWrapper(orig);
            if (previous instanceof MultipartHttpServletRequest) {
                s_log.debug((Object)("Build new multipart request from previous " + previous + " and current " + orig));
                MultipartHttpServletRequest previousmp = (MultipartHttpServletRequest)previous;
                sreq = new MultipartHttpServletRequest(previousmp, orig);
                DispatcherHelper.saveOriginalRequest(sreq, orig);
                s_log.debug((Object)("The main request is now " + sreq));
            } else {
                s_log.debug((Object)"The request is a new multipart; wrapping the request object");
                try {
                    sreq = new MultipartHttpServletRequest(sreq);
                }
                catch (MessagingException me) {
                    throw new ServletException((Throwable)me);
                }
                DispatcherHelper.saveOriginalRequest(sreq, orig);
            }
        } else {
            s_log.debug((Object)"The request is not multipart; proceeding without wrapping the request");
        }
        return sreq;
    }

    public static void saveOriginalRequest(HttpServletRequest req, HttpServletRequest oldReq) {
        req.setAttribute("com.arsdigita.dispatcher.OriginalRequest", (Object)oldReq);
    }

    public static void sendRedirect(HttpServletResponse resp, String url) throws IOException {
        DispatcherHelper.sendExternalRedirect(resp, url);
    }

    public static void sendRedirect(HttpServletRequest req, HttpServletResponse resp, String url) throws IOException {
        DispatcherHelper.sendExternalRedirect(resp, url);
    }

    public static void sendExternalRedirect(HttpServletResponse resp, String url) throws IOException {
        int start;
        String path;
        Object attr;
        HttpServletRequest req;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Redirecting to URL '" + url + "'"), new Throwable());
        }
        if (StringUtils.emptyString(url)) {
            url = ".";
        }
        if ((req = DispatcherHelper.getRequest()) != null && (attr = req.getAttribute("com.arsdigita.dispatcher.inside_request")) != null) {
            req.getSession(true).setAttribute("com.arsdigita.dispatcher.redirect_semaphore", attr);
        }
        if (url.startsWith("http") && !(path = url.substring(start = url.indexOf("/", url.indexOf("//") + 2))).startsWith(URL.getDispatcherPath())) {
            url = path;
        }
        if (url.startsWith("/")) {
            int sep = url.indexOf(63);
            URL destination = null;
            if (sep == -1) {
                destination = URL.there(req, url);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Setting destination to " + destination));
                }
            } else {
                ParameterMap params = ParameterMap.fromString(url.substring(sep + 1));
                destination = URL.there(req, url.substring(0, sep), params);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Setting destination with map to " + destination));
                }
            }
            throw new RedirectSignal(destination, true);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Redirecting to URL without using URL.there. URL is " + url));
        }
        throw new RedirectSignal(url, true);
    }

    public static void addParameterProvider(ParameterProvider provider) {
        URLRewriter.addParameterProvider(provider);
    }

    public static void clearParameterProviders() {
        URLRewriter.clearParameterProviders();
    }

    public static Set getGlobalModels() {
        return URLRewriter.getGlobalModels();
    }

    public static Set getGlobalParams(HttpServletRequest req) {
        return URLRewriter.getGlobalParams(req);
    }

    public static String prepareURL(String url, HttpServletRequest req) {
        return URLRewriter.prepareURL(url, req);
    }

    public static String encodeURL(HttpServletRequest req, HttpServletResponse resp, String url) {
        return URLRewriter.encodeURL(req, resp, url);
    }

    public static String getStaticURL() {
        return s_staticURL;
    }

    static void setStaticURL(String s) {
        if (s == null) {
            return;
        }
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        s_staticURL = s;
    }

    static void setWebappContext(String webappCtx) {
        if (webappCtx == null) {
            return;
        }
        if (!webappCtx.startsWith("/")) {
            webappCtx = "/" + webappCtx;
        }
        s_webappCtx = webappCtx;
        s_log.warn((Object)("webappContext set to '" + webappCtx + "'"));
    }

    public static String getWebappContext() {
        String webappCtx = null;
        HttpServletRequest request = DispatcherHelper.getRequest();
        if (request != null) {
            webappCtx = request.getContextPath();
            if (s_webappCtx != null) {
                if (s_webappCtx.equals("/")) {
                    s_webappCtx = "";
                }
                if (!s_webappCtx.equals(webappCtx)) {
                    s_log.warn((Object)("webappContext changed. Expected='" + s_webappCtx + "' found='" + webappCtx + "'.\nPerhaps the enterprise.init " + "com.arsdigita.dispatcher.Initializer webappContext " + "parameter is wrong."));
                    s_webappCtx = webappCtx;
                }
            }
        } else {
            if (s_webappCtx != null && s_webappCtx.equals("/")) {
                s_webappCtx = "";
            }
            webappCtx = s_webappCtx;
        }
        return webappCtx;
    }

    public static void abortRequest() {
        throw new AbortRequestSignal();
    }

    public static void setRequest(HttpServletRequest r) {
        s_request.set(r);
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)s_request.get();
    }

    public static void maybeCacheDisable(HttpServletResponse response) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheDisable(response);
        }
    }

    public static void cacheDisable(HttpServletResponse response) {
        if (!s_cachingActive) {
            return;
        }
        if (response.containsHeader("Cache-Control")) {
            s_log.warn((Object)"Cache-Control has already been set. Overwriting.");
        }
        DispatcherHelper.forceCacheDisable(response);
    }

    public static void forceCacheDisable(HttpServletResponse response) {
        if (!s_cachingActive) {
            return;
        }
        s_log.info((Object)"Setting cache control to disable");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "must-revalidate, no-cache");
        response.setHeader("Expires", rfc1123_formatter.format(new Date(0L)));
    }

    public static void maybeCacheForUser(HttpServletResponse response) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForUser(response);
        }
    }

    public static void cacheForUser(HttpServletResponse response) {
        DispatcherHelper.cacheForUser(response, s_defaultExpiry);
    }

    public static void maybeCacheForUser(HttpServletResponse response, int maxage) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForUser(response, maxage);
        }
    }

    public static void maybeCacheForUser(HttpServletResponse response, Date expiry) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForUser(response, expiry);
        }
    }

    public static void cacheForUser(HttpServletResponse response, int maxage) {
        if (!s_cachingActive) {
            return;
        }
        Assert.assertTrue(!response.containsHeader("Cache-Control"), "Caching headers have already been set");
        s_log.info((Object)"Setting cache control to user");
        response.setHeader("Last-Modified", rfc1123_formatter.format(new Date()));
        response.setHeader("Cache-Control", "private, max-age=" + maxage);
        response.setHeader("Expires", rfc1123_formatter.format(new Date(0L)));
    }

    public static void cacheForUser(HttpServletResponse response, Date expiry) {
        DispatcherHelper.cacheForUser(response, (int)((expiry.getTime() - new Date().getTime()) / 1000L));
    }

    public static void maybeCacheForWorld(HttpServletResponse response) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForWorld(response);
        }
    }

    public static void cacheForWorld(HttpServletResponse response) {
        DispatcherHelper.cacheForWorld(response, s_defaultExpiry);
    }

    public static void maybeCacheForWorld(HttpServletResponse response, int maxage) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForWorld(response, maxage);
        }
    }

    public static void maybeCacheForWorld(HttpServletResponse response, Date expiry) {
        if (!response.containsHeader("Cache-Control")) {
            DispatcherHelper.cacheForWorld(response, expiry);
        }
    }

    public static void cacheForWorld(HttpServletResponse response, int maxage) {
        if (!s_cachingActive) {
            return;
        }
        Assert.assertTrue(!response.containsHeader("Cache-Control"), "Caching headers have already been set");
        Calendar expires = Calendar.getInstance();
        expires.add(13, maxage);
        s_log.info((Object)"Setting cache control to world");
        response.setHeader("Cache-Control", "public, max-age=" + maxage);
        response.setHeader("Expires", rfc1123_formatter.format(expires.getTime()));
        response.setHeader("Last-Modified", rfc1123_formatter.format(new Date()));
    }

    public static void cacheForWorld(HttpServletResponse response, Date expiry) {
        DispatcherHelper.cacheForWorld(response, (int)((expiry.getTime() - new Date().getTime()) / 1000L));
    }

    public static DispatcherConfig getConfig() {
        if (s_config == null) {
            s_config = new DispatcherConfig();
            s_config.load();
        }
        return s_config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rfc1123_formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        rfc1123_formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        s_config = DispatcherHelper.getConfig();
        s_staticURL = s_config.getStaticURLPrefix();
        s_defaultExpiry = s_config.getDefaultExpiryTime();
        s_cachingActive = s_config.isCachingActive();
        s_request = new ThreadLocal();
    }
}

