/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dispatcher;

import com.arsdigita.util.UncheckedWrapperException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;

public class MultipartHttpServletRequest
implements HttpServletRequest {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/MultipartHttpServletRequest.java#18 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Category s_log = Category.getInstance((Class)(class$com$arsdigita$dispatcher$MultipartHttpServletRequest == null ? (class$com$arsdigita$dispatcher$MultipartHttpServletRequest = MultipartHttpServletRequest.class$("com.arsdigita.dispatcher.MultipartHttpServletRequest")) : class$com$arsdigita$dispatcher$MultipartHttpServletRequest));
    private HttpServletRequest m_request;
    private Map m_parameters = null;
    static /* synthetic */ Class class$com$arsdigita$dispatcher$MultipartHttpServletRequest;

    public MultipartHttpServletRequest(HttpServletRequest request) throws MessagingException, IOException {
        this.m_request = request;
        this.m_parameters = Collections.synchronizedMap(new HashMap());
        this.parseMultipartRequest(this.m_request);
    }

    public MultipartHttpServletRequest(MultipartHttpServletRequest original, HttpServletRequest current) {
        this.m_request = current;
        this.m_parameters = original.m_parameters;
    }

    public Object getAttribute(String name) {
        return this.m_request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.m_request.getAttributeNames();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.m_parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map getParameterMap() {
        return this.m_parameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.m_parameters.keySet());
    }

    public String getFileName(String name) {
        return this.getParameter(name);
    }

    public File getFile(String name) {
        String path = this.getParameter(name + ".tmpfile");
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public String[] getParameterValues(String name) {
        return (String[])this.m_parameters.get(name);
    }

    public String getAuthType() {
        return this.m_request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.m_request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.m_request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.m_request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.m_request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.m_request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.m_request.getIntHeader(name);
    }

    public String getMethod() {
        return this.m_request.getMethod();
    }

    public String getPathInfo() {
        return this.m_request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.m_request.getPathTranslated();
    }

    public String getContextPath() {
        return this.m_request.getContextPath();
    }

    public String getQueryString() {
        return this.m_request.getQueryString();
    }

    public String getRemoteUser() {
        return this.m_request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.m_request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.m_request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.m_request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.m_request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException("This is a Servlet 2.3 feature that we do not currently support");
    }

    public String getServletPath() {
        return this.m_request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.m_request.getSession(create);
    }

    public HttpSession getSession() {
        return this.m_request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.m_request.isRequestedSessionIdFromUrl();
    }

    public String getCharacterEncoding() {
        return this.m_request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("This is a Servlet 2.3 feature that we do not currently support");
    }

    public int getContentLength() {
        return this.m_request.getContentLength();
    }

    public String getContentType() {
        return this.m_request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.m_request.getInputStream();
    }

    public String getProtocol() {
        return this.m_request.getProtocol();
    }

    public String getScheme() {
        return this.m_request.getScheme();
    }

    public String getServerName() {
        return this.m_request.getServerName();
    }

    public int getServerPort() {
        return this.m_request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.m_request.getReader();
    }

    public String getRemoteAddr() {
        return this.m_request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.m_request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.m_request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.m_request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.m_request.getLocale();
    }

    public Enumeration getLocales() {
        return this.m_request.getLocales();
    }

    public boolean isSecure() {
        return this.m_request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.m_request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.m_request.getRealPath(path);
    }

    private void parseMultipartRequest(HttpServletRequest request) throws MessagingException, IOException {
        ServletRequestDataSource srds = new ServletRequestDataSource(request);
        MimeMultipart multipart = new MimeMultipart((DataSource)srds);
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            this.handlePart((Part)part);
        }
    }

    private void handlePart(Part part) throws MessagingException, IOException {
        String disposition = part.getHeader("Content-Disposition")[0];
        String paramName = this.getParamName(disposition);
        String fileName = part.getFileName();
        if (fileName == null) {
            this.addParameterValue(paramName, part.getContent());
        } else {
            int fnStart = disposition.indexOf("filename=\"");
            int fnEnd = disposition.indexOf(34, fnStart + 10);
            fileName = disposition.substring(fnStart + 10, fnEnd);
            this.addParameterValue(paramName, fileName);
            this.saveUploadedFile(paramName, part.getInputStream());
        }
    }

    private String getParamName(String disposition) throws MessagingException {
        int start = disposition.indexOf("name=\"");
        if (start != -1) {
            start += 6;
        }
        int end = disposition.indexOf(34, start);
        if ((start == -1 || end == -1) && (start = disposition.indexOf("name=")) != -1 && (end = disposition.indexOf(" ", start += 5)) == -1) {
            end = disposition.length();
        }
        if (start == -1 || end == -1) {
            throw new MessagingException("Failed to extract parameter name while parsing multipart form. Disposition was: '" + disposition + "'");
        }
        String paramName = disposition.substring(start, end);
        return paramName;
    }

    private void addParameterValue(String name, Object value) throws IOException {
        String[] newValues;
        String[] values = (String[])this.m_parameters.get(name);
        if (values == null) {
            newValues = new String[1];
        } else {
            newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
        }
        newValues[newValues.length - 1] = this.convertToString(value);
        this.m_parameters.put(name, newValues);
    }

    private String convertToString(Object value) throws IOException {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ByteArrayInputStream) {
            InputStreamReader reader;
            StringBuffer output = new StringBuffer();
            try {
                reader = new InputStreamReader((InputStream)((ByteArrayInputStream)value), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                throw new UncheckedWrapperException(ex);
            }
            int bufSize = 1024;
            char[] buffer = new char[1024];
            int read = 1024;
            while (1024 == read) {
                read = reader.read(buffer, 0, 1024);
                if (read <= 0) continue;
                output.append(buffer, 0, read);
            }
            return output.toString();
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUploadedFile(String paramName, InputStream in) throws IOException {
        File tmpFile = File.createTempFile("acs", null, null);
        tmpFile.deleteOnExit();
        this.addParameterValue(paramName + ".tmpfile", tmpFile.getPath());
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = in.read(buffer, 0, 4096)) != -1) {
                out.write(buffer, 0, length);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                out.close();
            }
            catch (IOException e) {
                s_log.error((Object)"Could not close output stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            s_log.error((Object)"Could not close output stream", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ServletRequestDataSource
    implements DataSource {
        private InputStream m_is;
        private String m_contentType;
        private String m_name = "ServletRequestDataSource";

        public ServletRequestDataSource(HttpServletRequest request) throws IOException {
            this.m_is = request.getInputStream();
            this.m_contentType = request.getContentType();
        }

        public String getName() {
            return this.m_name;
        }

        public InputStream getInputStream() {
            return this.m_is;
        }

        public String getContentType() {
            return this.m_contentType;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("getOutputStream not allowed on a multipart request data source");
        }
    }
}

