/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataObserver;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/DomainObject.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$DomainObject == null ? (class$com$arsdigita$domain$DomainObject = DomainObject.class$("com.arsdigita.domain.DomainObject")) : class$com$arsdigita$domain$DomainObject));
    private final DataObject m_dataObject;
    private boolean m_initialized = false;
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObject;

    public DomainObject(String typeName) {
        Session s = SessionManager.getSession();
        if (s == null) {
            throw new RuntimeException("Could not retrieve a session from the session manager while instantiating a class with ObjectType = " + typeName);
        }
        this.m_dataObject = s.create(typeName);
        this.initialize();
        this.postInitialization();
    }

    public DomainObject(ObjectType type) {
        Session s = SessionManager.getSession();
        if (s == null) {
            throw new RuntimeException("Could not retrieve a session from the session manager while instantiating a class with ObjectType = " + type.getName());
        }
        this.m_dataObject = s.create(type);
        this.initialize();
        this.postInitialization();
    }

    public DomainObject(OID oid) throws DataObjectNotFoundException {
        Session s = SessionManager.getSession();
        if (s == null) {
            throw new RuntimeException("Could not retrieve a session from the session manager while instantiating a class with OID = " + oid.toString());
        }
        this.m_dataObject = s.retrieve(oid);
        if (this.m_dataObject == null) {
            throw new DataObjectNotFoundException("Could not retrieve a DataObject with OID = " + oid.toString());
        }
        this.initialize();
        this.postInitialization();
    }

    public DomainObject(DataObject dataObject) {
        this.m_dataObject = dataObject;
        this.initialize();
        this.postInitialization();
    }

    protected String getBaseDataObjectType() {
        return null;
    }

    protected void initialize() {
        this.m_initialized = true;
        if (this.m_dataObject == null) {
            throw new RuntimeException("Cannot create a DomainObject with a null data object");
        }
        String baseTypeName = this.getBaseDataObjectType();
        if (baseTypeName == null) {
            return;
        }
        ObjectType.verifySubtype(baseTypeName, this.m_dataObject.getObjectType());
    }

    private void postInitialization() {
        if (!this.m_initialized) {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            s_log.fatal((Object)"Some subclass of DomainObject has overriden initialize and failed to call super.initialize() this is a potentially fatal error because DomainObject.initialize() runs code that is necessary for any Domain Object to function properly. Note that it could be any class in the type hierarchy that is responsible for this problem. In order to help you debug this, the stack trace will be logged directly following this message.");
            s_log.fatal((Object)sw.toString());
        }
        this.m_dataObject.addObserver(new SaveObserver());
    }

    public ObjectType getObjectType() {
        return this.m_dataObject.getObjectType();
    }

    public boolean isNew() {
        return this.m_dataObject.isNew();
    }

    public OID getOID() {
        return this.m_dataObject.getOID();
    }

    public boolean isValid() {
        return this.m_dataObject.isValid();
    }

    public boolean isModified() {
        return this.m_dataObject.isModified();
    }

    public boolean isDeleted() {
        return this.m_dataObject.isDeleted();
    }

    public boolean isPropertyModified(String name) {
        return this.m_dataObject.isPropertyModified(name);
    }

    public final void save() throws PersistenceException {
        this.m_dataObject.save();
    }

    public void delete() throws PersistenceException {
        this.m_dataObject.delete();
    }

    protected void set(String attr, Object value) {
        if (value instanceof DomainObject) {
            value = ((DomainObject)value).m_dataObject;
        }
        this.m_dataObject.set(attr, value);
    }

    protected void setAssociation(String attr, DomainObject dobj) {
        this.set(attr, dobj == null ? null : dobj.m_dataObject);
    }

    protected static void setAssociation(DataObject dobj, String attr, DomainObject target) {
        dobj.set(attr, target == null ? null : target.m_dataObject);
    }

    public void removeFromAssociation(DataAssociation da) {
        da.remove(this.m_dataObject);
    }

    public DataObject addToAssociation(DataAssociation da) {
        return da.add(this.m_dataObject);
    }

    protected DataObject add(String propertyName, DataObject dataObject) {
        DataAssociation da = (DataAssociation)this.get(propertyName);
        return da.add(dataObject);
    }

    protected DataObject add(String propertyName, DomainObject dobj) {
        return this.add(propertyName, dobj.m_dataObject);
    }

    protected void remove(String propertyName, DataObject dataObject) {
        DataAssociation da = (DataAssociation)this.get(propertyName);
        da.remove(dataObject);
    }

    protected void remove(String propertyName, DomainObject dobj) {
        this.remove(propertyName, dobj.m_dataObject);
    }

    protected void remove(String propertyName, OID oid) {
        DataAssociation da = (DataAssociation)this.get(propertyName);
        da.remove(oid);
    }

    protected void clear(String propertyName) {
        DataAssociation da = (DataAssociation)this.get(propertyName);
        da.clear();
    }

    protected Object get(String attr) {
        return this.m_dataObject.get(attr);
    }

    public Session getSession() {
        return this.m_dataObject.getSession();
    }

    public boolean equals(Object object) {
        if (object instanceof DomainObject) {
            return this.getDataObject().equals(((DomainObject)object).getDataObject());
        }
        return false;
    }

    public int hashCode() {
        return this.getDataObject().hashCode();
    }

    DataObject getDataObject() {
        return this.m_dataObject;
    }

    protected void specializeDataObject(ObjectType subtype) {
        this.m_dataObject.specialize(subtype);
    }

    protected void specializeDataObject(String subtypeName) {
        this.m_dataObject.specialize(subtypeName);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        OID oid = this.getOID();
        if (oid != null) {
            result.append(oid.toString());
        } else {
            result.append("[");
            result.append(this.getBaseDataObjectType());
            result.append(":---]");
        }
        if (!this.isValid()) {
            result.append('U');
            return result.toString();
        }
        if (this.isNew()) {
            result.append('N');
        }
        if (this.isModified()) {
            result.append('M');
        }
        if (this.isDeleted()) {
            result.append('D');
        }
        return result.toString();
    }

    public void disconnect() {
        this.m_dataObject.disconnect();
    }

    public boolean isDisconnected() {
        return this.m_dataObject.isDisconnected();
    }

    protected void beforeSave() {
    }

    protected void afterSave() {
    }

    protected void beforeDelete() {
    }

    protected void afterDelete() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SaveObserver
    extends DataObserver {
        private SaveObserver() {
        }

        private DomainObject getDomainObject() {
            return DomainObject.this;
        }

        public void set(DataObject object, String property, Object previous, Object value) {
        }

        public void add(DataObject object, String property, DataObject value) {
        }

        public void remove(DataObject object, String property, DataObject value) {
        }

        public void clear(DataObject object, String property) {
        }

        public void beforeSave(DataObject object) {
            this.getDomainObject().beforeSave();
        }

        public void afterSave(DataObject object) {
            this.getDomainObject().afterSave();
        }

        public void beforeDelete(DataObject object) {
            this.getDomainObject().beforeDelete();
        }

        public void afterDelete(DataObject object) {
            this.getDomainObject().afterDelete();
        }

        public int hashCode() {
            return this.getDomainObject().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SaveObserver) {
                return this.getDomainObject().equals(((SaveObserver)other).getDomainObject());
            }
            return false;
        }

        public boolean overrides(DataObserver o) {
            String other;
            ObjectType me = DomainObject.this.getSession().getMetadataRoot().getObjectType(this.getDomainObject().getBaseDataObjectType());
            return me.isSubtypeOf(other = ((SaveObserver)o).getDomainObject().getBaseDataObjectType());
        }

        public String toString() {
            return "Save observer for: " + this.getDomainObject().getOID() + " (" + super.toString() + ")";
        }
    }
}

