/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectObserver;
import com.arsdigita.domain.GlobalObserver;
import com.arsdigita.domain.GlobalObserverManager;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataObserver;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class ObservableDomainObject
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/ObservableDomainObject.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$ObservableDomainObject == null ? (class$com$arsdigita$domain$ObservableDomainObject = ObservableDomainObject.class$("com.arsdigita.domain.ObservableDomainObject")) : class$com$arsdigita$domain$ObservableDomainObject));
    private Collection m_observers;
    static /* synthetic */ Class class$com$arsdigita$domain$ObservableDomainObject;

    protected ObservableDomainObject(DataObject dobj) {
        super(dobj);
        this.initializeGlobalObservers();
    }

    public ObservableDomainObject(String typeName) {
        super(typeName);
        this.initializeGlobalObservers();
    }

    public ObservableDomainObject(ObjectType type) {
        super(type);
        this.initializeGlobalObservers();
    }

    public ObservableDomainObject(OID oid) throws DataObjectNotFoundException {
        super(oid);
        this.initializeGlobalObservers();
    }

    private void initializeGlobalObservers() {
        GlobalObserverManager gom = GlobalObserverManager.getManager();
        Iterator it = gom.getObservers();
        while (it.hasNext()) {
            GlobalObserver go = (GlobalObserver)it.next();
            if (!go.shouldObserve(this)) continue;
            this.addObserver(go);
        }
    }

    public void addObserver(DomainObjectObserver doo) {
        if (this.m_observers == null) {
            this.m_observers = new ArrayList();
        }
        this.m_observers.add(doo);
        this.getDataObject().addObserver(new ProxyObserver(doo));
    }

    public Iterator getObservers() {
        if (this.m_observers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.m_observers.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProxyObserver
    extends DataObserver {
        private boolean m_before = false;
        private boolean m_wasNew = false;
        private DomainObjectObserver m_obs;

        ProxyObserver(DomainObjectObserver obs) {
            this.m_obs = obs;
        }

        public void set(DataObject object, String property, Object previous, Object value) {
            this.m_obs.set(ObservableDomainObject.this, property, previous, value);
        }

        public void add(DataObject object, String property, DataObject value) {
            this.m_obs.add(ObservableDomainObject.this, property, value);
        }

        public void remove(DataObject object, String property, DataObject value) {
            this.m_obs.remove(ObservableDomainObject.this, property, value);
        }

        public void clear(DataObject object, String property) {
            this.m_obs.clear(ObservableDomainObject.this, property);
        }

        public void beforeSave(DataObject object) {
            if (this.m_before && this.m_wasNew && !ObservableDomainObject.this.isNew()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("suppressing duplicate before save: " + ObservableDomainObject.this.getOID()));
                }
                return;
            }
            this.m_before = true;
            this.m_wasNew = ObservableDomainObject.this.isNew();
            this.m_obs.beforeSave(ObservableDomainObject.this);
        }

        public void afterSave(DataObject object) {
            if (!this.m_before) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("suppressing duplicate after save: " + ObservableDomainObject.this.getOID()));
                }
                return;
            }
            this.m_before = false;
            this.m_obs.afterSave(ObservableDomainObject.this);
        }

        public void beforeDelete(DataObject object) {
            if (this.m_before) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("suppressing duplicate before delete: " + ObservableDomainObject.this.getOID()));
                }
                return;
            }
            this.m_before = true;
            this.m_obs.beforeDelete(ObservableDomainObject.this);
        }

        public void afterDelete(DataObject object) {
            if (!this.m_before) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("suppressing duplicate after delete: " + ObservableDomainObject.this.getOID()));
                }
                return;
            }
            this.m_before = false;
            this.m_obs.afterDelete(ObservableDomainObject.this);
        }

        public int hashCode() {
            return this.m_obs.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ProxyObserver) {
                return this.m_obs.equals(((ProxyObserver)other).m_obs);
            }
            return false;
        }

        public String toString() {
            return "proxy for " + this.m_obs;
        }
    }
}

