/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain.xml;

import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.DomainObjectXMLFormatter;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.domain.SimpleDomainObjectTraversalAdapter;
import com.arsdigita.domain.SimpleDomainObjectXMLFormatter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Classes;
import com.arsdigita.xml.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class TraversalHandler
extends DefaultHandler {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/xml/TraversalHandler.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$xml$TraversalHandler == null ? (class$com$arsdigita$domain$xml$TraversalHandler = TraversalHandler.class$("com.arsdigita.domain.xml.TraversalHandler")) : class$com$arsdigita$domain$xml$TraversalHandler));
    private static final String XMLNS = "http://xmlns.redhat.com/schemas/waf/xml-renderer-rules";
    private Map m_adapters = new HashMap();
    private SimpleDomainObjectTraversalAdapter m_adapter;
    private SimpleDomainObjectXMLFormatter m_formatters;
    private String m_objectType;
    private String m_context;
    private String m_typeContext;
    private boolean m_attrs;
    static /* synthetic */ Class class$com$arsdigita$domain$xml$TraversalHandler;
    static /* synthetic */ Class class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter;
    static /* synthetic */ Class class$com$arsdigita$domain$SimpleDomainObjectXMLFormatter;

    public void characters(char[] ch, int start, int len) {
    }

    public void startElement(String uri, String localName, String qn, Attributes attrs) {
        if (!XMLNS.equals(uri)) {
            s_log.warn((Object)("Ignoring attribute " + localName + " " + qn + " " + uri));
            return;
        }
        if (!localName.equals("adapters")) {
            if (localName.equals("context")) {
                this.m_context = attrs.getValue("name");
                if (this.m_context == null) {
                    throw new RuntimeException("the 'name' attribute is compulsory on the <context> element");
                }
            } else if (localName.equals("adapter")) {
                String parentType;
                String traversalClass;
                this.m_objectType = attrs.getValue("objectType");
                if (this.m_objectType == null) {
                    throw new RuntimeException("the 'objectType' attribute is compulsory on the <context> element");
                }
                this.m_typeContext = attrs.getValue("context");
                if (this.m_typeContext != null) {
                    s_log.warn((Object)"The 'context' attribute on the <adapter> element is deprecated. Please group your multiple <adapter> elements in a single <context name=\"foo\">...</context> element instead");
                }
                if ((traversalClass = attrs.getValue("traversalClass")) == null) {
                    traversalClass = (class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter == null ? (class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter = TraversalHandler.class$("com.arsdigita.domain.SimpleDomainObjectTraversalAdapter")) : class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter).getName();
                }
                if ((parentType = attrs.getValue("extends")) == null) {
                    this.m_adapter = (SimpleDomainObjectTraversalAdapter)Classes.newInstance(traversalClass);
                } else {
                    ObjectType ot;
                    Object parent = this.m_adapters.get(parentType);
                    if (parent == null && (ot = SessionManager.getMetadataRoot().getObjectType(parentType)) != null) {
                        parent = DomainObjectTraversal.findAdapter(ot, this.m_typeContext == null ? this.m_context : this.m_typeContext);
                    }
                    if (parent == null) {
                        s_log.error((Object)("Cannot find adapter definition for extends='" + parentType + "' on type " + this.m_objectType + " in context " + this.m_context));
                    }
                    s_log.info((Object)("Setting parent adapter for " + this.m_objectType + " in context " + this.m_context + " to " + parentType));
                    this.m_adapter = (SimpleDomainObjectTraversalAdapter)Classes.newInstance(traversalClass, new Class[]{class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter == null ? (class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter = TraversalHandler.class$("com.arsdigita.domain.SimpleDomainObjectTraversalAdapter")) : class$com$arsdigita$domain$SimpleDomainObjectTraversalAdapter}, new Object[]{parent});
                }
                this.m_adapters.put(this.m_objectType, this.m_adapter);
                String formatter = attrs.getValue("formatter");
                if (formatter == null) {
                    formatter = (class$com$arsdigita$domain$SimpleDomainObjectXMLFormatter == null ? (class$com$arsdigita$domain$SimpleDomainObjectXMLFormatter = TraversalHandler.class$("com.arsdigita.domain.SimpleDomainObjectXMLFormatter")) : class$com$arsdigita$domain$SimpleDomainObjectXMLFormatter).getName();
                }
                this.m_formatters = (SimpleDomainObjectXMLFormatter)Classes.newInstance(formatter);
            } else if (localName.equals("attributes")) {
                this.m_attrs = true;
                String rule = attrs.getValue("rule");
                if (rule == null) {
                    throw new RuntimeException("the 'rule' attribute is compulsory on the <attributes> element");
                }
                s_log.debug((Object)("Set attribute rule " + rule));
                if ("include".equals(rule)) {
                    this.m_adapter.setAttributeRule(0);
                } else {
                    this.m_adapter.setAttributeRule(1);
                }
            } else if (localName.equals("associations")) {
                this.m_attrs = false;
                String rule = attrs.getValue("rule");
                if (rule == null) {
                    throw new RuntimeException("the 'rule' attribute is compulsory on the <associations> element");
                }
                s_log.debug((Object)("Set association rule " + rule));
                if ("exclude".equals(rule)) {
                    this.m_adapter.setAssociationRule(1);
                } else {
                    this.m_adapter.setAssociationRule(0);
                }
            } else if (localName.equals("formatter")) {
                String property = attrs.getValue("property");
                String klass = attrs.getValue("class");
                Formatter formatter = (Formatter)Classes.newInstance(klass);
                this.m_formatters.addFormatter(property, formatter);
            } else if (localName.equals("property")) {
                String prop = attrs.getValue("name");
                if (prop == null) {
                    throw new RuntimeException("the 'name' attribute is compulsory on the <property> element");
                }
                if (this.m_attrs) {
                    s_log.debug((Object)("Adding attribute property " + prop));
                    this.m_adapter.addAttributeProperty(prop);
                } else {
                    s_log.debug((Object)("Adding association property " + prop));
                    this.m_adapter.addAssociationProperty(prop);
                }
            } else {
                s_log.warn((Object)("Unhandled element " + qn));
            }
        }
    }

    public void endElement(String uri, String localName, String qn) {
        if (!XMLNS.equals(uri)) {
            s_log.warn((Object)("Ignoring attribute " + localName + " " + qn + " " + uri));
            return;
        }
        if (!localName.equals("adapters")) {
            if (localName.equals("context")) {
                this.m_context = null;
            } else if (localName.equals("adapter")) {
                s_log.info((Object)("Registering adapter for " + this.m_objectType + " in context " + this.m_context));
                this.registerAdapter(this.m_objectType, this.m_adapter, this.m_typeContext == null ? this.m_context : this.m_typeContext);
                this.registerFormatter(this.m_objectType, this.m_formatters, this.m_typeContext == null ? this.m_context : this.m_typeContext);
                this.m_objectType = null;
                this.m_adapter = null;
                this.m_typeContext = null;
                this.m_formatters = null;
            } else if (!(localName.equals("attributes") || localName.equals("formatter") || localName.equals("associations") || localName.equals("property"))) {
                s_log.warn((Object)("Unhandled element " + qn));
            }
        }
    }

    protected void registerAdapter(String objectType, DomainObjectTraversalAdapter adapter, String context) {
        DomainObjectTraversal.registerAdapter(objectType, adapter, context);
    }

    protected void registerFormatter(String objectType, DomainObjectXMLFormatter formatter, String context) {
        DomainObjectXMLRenderer.registerFormatter(objectType, formatter, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

