/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class BebopObjectType
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.ObjectType";
    public static final String TYPE_ID = "id";
    public static final String CLASS_NAME = "className";
    public static final String APP_NAME = "appName";

    public BebopObjectType() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public BebopObjectType(String type) {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public BebopObjectType(ObjectType type) {
        super(type);
    }

    public BebopObjectType(DataObject obj) {
        super(obj);
    }

    public BebopObjectType(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public BebopObjectType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static BebopObjectType create(String app, Class widget) {
        BebopObjectType type = new BebopObjectType();
        type.setAppName(app);
        type.setType(widget);
        return type;
    }

    public static BebopObjectType create(String app, String widgetClass) {
        BebopObjectType type = new BebopObjectType();
        type.setAppName(app);
        type.setTypeName(widgetClass);
        return type;
    }

    public static BebopObjectType findByClass(String name, Class type) throws DataObjectNotFoundException {
        return BebopObjectType.findByClassName(name, type.getName());
    }

    public static BebopObjectType findByClassName(String app, String name) throws DataObjectNotFoundException {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter(CLASS_NAME, name);
        types.addEqualsFilter(APP_NAME, app);
        if (types.next()) {
            DataObject obj = types.getDataObject();
            BebopObjectType t = new BebopObjectType(obj);
            types.close();
            return t;
        }
        throw new DataObjectNotFoundException("no such object type " + name);
    }

    public static Collection getObjectTypes() {
        Session ssn = SessionManager.getSession();
        DataCollection forms = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        ArrayList<BebopObjectType> l = new ArrayList<BebopObjectType>();
        while (forms.next()) {
            DataObject obj = forms.getDataObject();
            BebopObjectType t = new BebopObjectType(obj);
            l.add(t);
        }
        return l;
    }

    public Class getType() throws ClassNotFoundException {
        return Class.forName((String)this.get(CLASS_NAME));
    }

    public String getTypeName() {
        return (String)this.get(CLASS_NAME);
    }

    public void setType(Class type) {
        this.set(CLASS_NAME, type.getName());
    }

    public void setTypeName(String typeName) {
        this.set(CLASS_NAME, typeName);
    }

    public String getAppName() {
        return (String)this.get(APP_NAME);
    }

    public void setAppName(String name) {
        this.set(APP_NAME, name);
    }
}

