/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.ComponentAddObserver;
import com.arsdigita.formbuilder.CompoundComponent;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentContainer;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.util.PersistentContainerHelper;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PersistentFormSection
extends PersistentComponent
implements PersistentContainer,
CompoundComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentFormSection.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$PersistentFormSection == null ? (class$com$arsdigita$formbuilder$PersistentFormSection = PersistentFormSection.class$("com.arsdigita.formbuilder.PersistentFormSection")) : class$com$arsdigita$formbuilder$PersistentFormSection).getName());
    private PersistentContainerHelper m_container = new PersistentContainerHelper(this);
    private Container m_form_container;
    ComponentAddObserver m_componentAddObserver;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.FormSection";
    ArrayList m_listeners;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentFormSection;

    public PersistentFormSection() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public PersistentFormSection(String objectType) {
        super(objectType);
    }

    public PersistentFormSection(ObjectType type) {
        super(type);
    }

    public PersistentFormSection(DataObject obj) {
        super(obj);
    }

    public PersistentFormSection(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected PersistentFormSection(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public void delete() {
        this.m_container.clearComponents();
        super.delete();
    }

    public void addComponent(PersistentComponentFactory componentFactory) {
        this.m_container.addComponent(componentFactory);
    }

    public void addComponent(PersistentComponentFactory componentFactory, int position) {
        this.m_container.addComponent(componentFactory, position);
    }

    public void removeComponent(PersistentComponentFactory componentFactory) {
        this.m_container.removeComponent(componentFactory);
    }

    public void moveComponent(PersistentComponentFactory componentFactory, int toPosition) {
        this.m_container.moveComponent(componentFactory, toPosition);
    }

    public void clearComponents() {
        this.m_container.clearComponents();
    }

    public Component createComponent() {
        FormSection formSection = this.m_form_container == null ? new FormSection() : new FormSection(this.m_form_container);
        this.addProcessListeners(formSection);
        this.addComponents(formSection);
        return formSection;
    }

    public Collection getComponents() {
        return this.m_container.getComponents();
    }

    protected void addProcessListeners(FormSection formSection) {
        Iterator listeners = this.getProcessListeners();
        while (listeners.hasNext()) {
            PersistentProcessListener l = (PersistentProcessListener)listeners.next();
            formSection.addProcessListener(l.createProcessListener());
        }
    }

    protected void addComponents(FormSection formSection) {
        Iterator componentIter = this.m_container.getComponents().iterator();
        int componentCounter = 1;
        while (componentIter.hasNext()) {
            PersistentComponentFactory factory = (PersistentComponentFactory)componentIter.next();
            if (this.m_componentAddObserver != null) {
                this.m_componentAddObserver.beforeAddingComponent(formSection, factory, componentCounter);
            }
            Component component = factory.createComponent();
            if (this.m_componentAddObserver != null) {
                this.m_componentAddObserver.addingComponent(factory, componentCounter, component);
            }
            formSection.add(component);
            if (this.m_componentAddObserver != null) {
                this.m_componentAddObserver.afterAddingComponent(formSection, factory, componentCounter);
            }
            ++componentCounter;
        }
    }

    public void setComponentAddObserver(ComponentAddObserver observer) {
        this.m_componentAddObserver = observer;
    }

    private void retrieveListeners() {
        this.m_listeners = new ArrayList();
        DataAssociation listeners = (DataAssociation)this.get("listeners");
        DataAssociationCursor cursor = listeners.cursor();
        cursor.addOrder("link.position asc");
        while (cursor.next()) {
            PersistentProcessListener l = (PersistentProcessListener)DomainObjectFactory.newInstance(cursor.getDataObject());
            this.m_listeners.add(l);
        }
    }

    public void addProcessListener(PersistentProcessListener listener) {
        if (listener.isNew()) {
            listener.save();
        }
        if (this.m_listeners == null) {
            this.retrieveListeners();
        }
        int position = this.m_listeners.size();
        DataObject link = this.add("listeners", listener);
        link.set("position", new BigDecimal((double)position));
        this.m_listeners.add(listener);
    }

    public void removeProcessListener(PersistentProcessListener listener) {
        if (this.m_listeners == null) {
            this.retrieveListeners();
        }
        int position = this.m_listeners.indexOf(listener);
        this.remove("listeners", listener);
        this.m_listeners.remove(position);
        DataAssociation listeners = (DataAssociation)this.get("listeners");
        DataAssociationCursor cursor = listeners.cursor();
        cursor.addOrder("link.position asc");
        while (cursor.next()) {
            DataObject link = cursor.getLink();
            BigDecimal current = (BigDecimal)link.get("position");
            if (current.intValue() <= position) continue;
            link.set("position", new BigDecimal((double)(current.intValue() - 1)));
        }
    }

    public void clearProcessListeners() {
        if (this.m_listeners == null) {
            this.retrieveListeners();
        }
        this.clear("listeners");
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            PersistentProcessListener l = (PersistentProcessListener)i.next();
            l.delete();
        }
        this.m_listeners = null;
    }

    public Iterator getProcessListeners() {
        if (this.m_listeners == null) {
            this.retrieveListeners();
        }
        return this.m_listeners.iterator();
    }

    public void setFormContainer(Container container) {
        this.m_form_container = container;
    }

    public Container getFormContainer() {
        return this.m_form_container;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

