/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;

public class PersistentProcessListener
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.ProcessListener";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String LISTENER_CLASS = "listenerClass";

    public PersistentProcessListener(String typeName) {
        super(typeName);
    }

    public PersistentProcessListener(ObjectType type) {
        super(type);
    }

    public PersistentProcessListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PersistentProcessListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public PersistentProcessListener(DataObject obj) {
        super(obj);
    }

    public static PersistentProcessListener create(String name, String className) {
        PersistentProcessListener listener = new PersistentProcessListener(BASE_DATA_OBJECT_TYPE);
        listener.setName(name);
        listener.setProcessListenerClass(className);
        return listener;
    }

    protected void setup(String name, String description) {
        this.set(NAME, name);
        this.set(DESCRIPTION, description);
    }

    public FormProcessListener createProcessListener() {
        return (FormProcessListener)FormBuilderUtil.instantiateObject((String)this.get(LISTENER_CLASS));
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setProcessListenerClass(String className) {
        this.set(LISTENER_CLASS, className);
    }

    public String getPrcoessListenerClass() {
        return (String)this.get(LISTENER_CLASS);
    }

    public void setDescription(String desc) {
        this.set(DESCRIPTION, desc);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }
}

