/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;

public class WidgetLabel
extends PersistentLabel {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.WidgetLabel";
    public static String WIDGET_ID = "widgetId";

    public WidgetLabel() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public WidgetLabel(String typeName) {
        super(typeName);
    }

    public WidgetLabel(ObjectType type) {
        super(type);
    }

    public WidgetLabel(DataObject obj) {
        super(obj);
    }

    public WidgetLabel(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public WidgetLabel(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static WidgetLabel create(PersistentWidget widget, String label) {
        WidgetLabel l = new WidgetLabel();
        l.setLabel(label);
        l.setWidget(widget);
        return l;
    }

    public static WidgetLabel findByWidget(PersistentWidget widget) throws DataObjectNotFoundException {
        Session ssn = SessionManager.getSession();
        DataCollection labels = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        labels.addEqualsFilter(WIDGET_ID, widget.getID());
        if (labels.next()) {
            DataObject obj = labels.getDataObject();
            WidgetLabel l = new WidgetLabel(obj);
            labels.close();
            return l;
        }
        throw new DataObjectNotFoundException("cannot find widget label");
    }

    public void setWidget(PersistentWidget widget) {
        this.set(WIDGET_ID, widget.getID());
    }

    public void setWidgetID(BigDecimal id) {
        this.set(WIDGET_ID, id);
    }

    public PersistentWidget getWidget() throws DataObjectNotFoundException {
        BigDecimal id = (BigDecimal)this.get(WIDGET_ID);
        OID oid = new OID("com.arsdigita.kernel.ACSObject", (Object)id);
        Session s = SessionManager.getSession();
        DataObject o = s.retrieve(oid);
        return (PersistentWidget)FormBuilderUtil.instantiateObjectOneArg((String)o.get("defaultDomainClass"), id);
    }

    public BigDecimal getWidgetID() {
        return (BigDecimal)this.get(WIDGET_ID);
    }
}

