/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;

public class ConfirmRedirectListener
extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.actions.ConfirmRedirectListener";
    public static final String URL = "url";

    public ConfirmRedirectListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ConfirmRedirectListener(String typeName) {
        super(typeName);
    }

    public ConfirmRedirectListener(ObjectType type) {
        super(type);
    }

    public ConfirmRedirectListener(DataObject obj) {
        super(obj);
    }

    public ConfirmRedirectListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ConfirmRedirectListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static ConfirmRedirectListener create(String name, String description, String url) {
        ConfirmRedirectListener l = new ConfirmRedirectListener();
        l.setup(name, description, url);
        return l;
    }

    protected void setup(String name, String description, String url) {
        super.setup(name, description);
        this.set(URL, url);
    }

    public boolean isContainerModified() {
        return false;
    }

    public String getUrl() {
        return (String)this.get(URL);
    }

    public void setUrl(String url) {
        this.set(URL, url);
    }

    public FormProcessListener createProcessListener() {
        return new ConfirmRedirectProcessListener(this.getUrl());
    }

    private class ConfirmRedirectProcessListener
    implements FormProcessListener {
        String m_url;

        public ConfirmRedirectProcessListener(String url) {
            this.m_url = url;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            try {
                DispatcherHelper.sendExternalRedirect(e.getPageState().getResponse(), this.m_url);
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("Cannot do redirect", ex);
            }
        }
    }
}

