/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RemoteServerPostListener
extends PersistentProcessListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$actions$RemoteServerPostListener == null ? (class$com$arsdigita$formbuilder$actions$RemoteServerPostListener = RemoteServerPostListener.class$("com.arsdigita.formbuilder.actions.RemoteServerPostListener")) : class$com$arsdigita$formbuilder$actions$RemoteServerPostListener));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.actions.RemoteServerPostListener";
    public static final String REMOTE_URL = "remoteURL";
    static /* synthetic */ Class class$com$arsdigita$formbuilder$actions$RemoteServerPostListener;

    public RemoteServerPostListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public RemoteServerPostListener(String typeName) {
        super(typeName);
    }

    public RemoteServerPostListener(ObjectType type) {
        super(type);
    }

    public RemoteServerPostListener(DataObject obj) {
        super(obj);
    }

    public RemoteServerPostListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public RemoteServerPostListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static RemoteServerPostListener create(String name, String description, String remoteURL) {
        RemoteServerPostListener l = new RemoteServerPostListener();
        l.setup(name, description, remoteURL);
        return l;
    }

    protected void setup(String name, String description, String remoteURL) {
        super.setup(name, description);
        this.setRemoteURL(remoteURL);
    }

    public boolean isContainerModified() {
        return false;
    }

    public String getRemoteURL() {
        return (String)this.get(REMOTE_URL);
    }

    public void setRemoteURL(String remoteURL) {
        this.set(REMOTE_URL, remoteURL);
    }

    public FormProcessListener createProcessListener() {
        return new RemoteServerPostProcessListener(this.getRemoteURL());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RemoteServerPostProcessListener
    implements FormProcessListener {
        URL m_remoteURL;

        public RemoteServerPostProcessListener(String remoteURL) {
            try {
                this.m_remoteURL = new URL(remoteURL);
            }
            catch (MalformedURLException murle) {
                throw new UncheckedWrapperException("malformed URL " + remoteURL, murle);
            }
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            Iterator params = data.getParameters().iterator();
            StringBuffer paramBuffer = new StringBuffer();
            while (params.hasNext()) {
                ParameterData paramData = (ParameterData)params.next();
                paramBuffer.append(paramData.getKey()).append("=").append(paramData.getValue()).append("&");
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Sending the values [" + paramBuffer.toString() + "] to the URL " + this.m_remoteURL.toString()));
            }
            try {
                URLConnection connection = this.m_remoteURL.openConnection();
                connection.setDoOutput(true);
                DataOutputStream stream = new DataOutputStream(connection.getOutputStream());
                stream.writeBytes(paramBuffer.toString());
                stream.close();
                if (s_log.isDebugEnabled()) {
                    DataInputStream fromStream = new DataInputStream(connection.getInputStream());
                    String currentLine = fromStream.readLine();
                    StringBuffer outputBuffer = new StringBuffer();
                    while (currentLine != null) {
                        outputBuffer.append(currentLine);
                        currentLine = fromStream.readLine();
                    }
                    s_log.debug((Object)("Output from page " + this.m_remoteURL + " is: \n" + outputBuffer.toString()));
                    fromStream.close();
                }
            }
            catch (IOException ioe) {
                s_log.error((Object)("Unable to open a connection to " + this.m_remoteURL + " with parameters " + paramBuffer.toString()), (Throwable)ioe);
            }
        }
    }
}

