/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.util.Placeholders;
import com.arsdigita.mail.Mail;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import javax.mail.MessagingException;

public class TemplateEmailListener
extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.actions.TemplateEmailListener";
    public static final String TO = "recipient";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public TemplateEmailListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public TemplateEmailListener(String typeName) {
        super(typeName);
    }

    public TemplateEmailListener(ObjectType type) {
        super(type);
    }

    public TemplateEmailListener(DataObject obj) {
        super(obj);
    }

    public TemplateEmailListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public TemplateEmailListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static TemplateEmailListener create(String name, String description, String to, String subject, String body) {
        TemplateEmailListener l = new TemplateEmailListener();
        l.setup(name, description, to, subject, body);
        return l;
    }

    protected void setup(String name, String description, String to, String subject, String body) {
        super.setup(name, description);
        this.set(TO, to);
        this.set(SUBJECT, subject);
        this.set(BODY, body);
    }

    public boolean isContainerModified() {
        return false;
    }

    public String getTo() {
        return (String)this.get(TO);
    }

    public void setTo(String to) {
        this.set(TO, to);
    }

    public String getSubject() {
        return (String)this.get(SUBJECT);
    }

    public void setSubject(String subject) {
        this.set(SUBJECT, subject);
    }

    public String getBody() {
        return (String)this.get(BODY);
    }

    public void setBody(String body) {
        this.set(BODY, body);
    }

    public FormProcessListener createProcessListener() {
        return new TemplateEmailProcessListener(this.getTo(), this.getSubject(), this.getBody());
    }

    private class TemplateEmailProcessListener
    implements FormProcessListener {
        String m_to;
        String m_subject;
        String m_body;

        public TemplateEmailProcessListener(String to, String subject, String body) {
            this.m_to = to;
            this.m_subject = subject;
            this.m_body = body;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            Placeholders p = new Placeholders(e.getPageState(), e.getFormData());
            String to = p.interpolate(this.m_to);
            String subject = p.interpolate(this.m_subject);
            String body = p.interpolate(this.m_body);
            String from = p.interpolate("::user.email::");
            try {
                Mail message = new Mail(to, from, subject, body);
                message.send();
            }
            catch (MessagingException ex) {
                throw new UncheckedWrapperException("cannot send message", ex);
            }
        }
    }
}

