/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.AttributeMetaData;
import com.arsdigita.formbuilder.FormBuilderDispatcher;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.SimpleQuestionnaire;
import com.arsdigita.formbuilder.ui.OptionGroupPage;
import com.arsdigita.formbuilder.ui.PreviewForm;
import com.arsdigita.formbuilder.ui.PreviewFormPageConnector;
import com.arsdigita.formbuilder.ui.QuestionPropertiesForm;
import com.arsdigita.formbuilder.ui.TemplatePage;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormBuildingPage
extends TemplatePage {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormBuildingPage.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$ui$FormBuildingPage == null ? (class$com$arsdigita$formbuilder$ui$FormBuildingPage = FormBuildingPage.class$("com.arsdigita.formbuilder.ui.FormBuildingPage")) : class$com$arsdigita$formbuilder$ui$FormBuildingPage).getName());
    private static FormBuildingPage s_instance;
    private Link m_indexLink;
    private ColumnPanel m_questionPanel;
    private ColumnPanel m_widgetListPanel;
    private List m_widgetList;
    private QuestionPropertiesForm m_questionForm;
    private MetaForm m_previewForm;
    private Form m_moveForm;
    private Form m_deleteForm;
    public BigDecimalParameter m_formID;
    public StringParameter m_pageMode;
    public IntegerParameter m_questionPosition;
    public BigDecimalParameter m_widgetID;
    public StringParameter m_parameterName;
    private static HashMap s_singleValueWidgetMap;
    private static HashMap s_multipleValueWidgetMap;
    private RequestLocal m_widgetSelectionMap = new RequestLocal(){

        public Object initialValue(PageState pageState) {
            if (FormBuildingPage.this.getQuestionnaire(pageState).listenerHasMetaData()) {
                AttributeMetaData parameterMetaData = FormBuildingPage.this.getQuestionForm().getParameterMetaData(pageState);
                if (parameterMetaData.isMultiple()) {
                    return s_multipleValueWidgetMap;
                }
                return s_singleValueWidgetMap;
            }
            HashMap widgetMap = new HashMap();
            widgetMap.putAll(s_singleValueWidgetMap);
            widgetMap.putAll(s_multipleValueWidgetMap);
            return widgetMap;
        }
    };
    private RequestLocal m_simpleQuestionnaire = new RequestLocal(){

        public Object initialValue(PageState pageState) {
            SimpleQuestionnaire questionnaire;
            BigDecimal formID = FormBuildingPage.this.getFormID(pageState);
            try {
                questionnaire = new SimpleQuestionnaire(formID);
            }
            catch (DataObjectNotFoundException e) {
                throw new UncheckedWrapperException(e);
            }
            return questionnaire;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$formbuilder$ui$FormBuildingPage;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentTextField;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentTextArea;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentSingleSelect;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentMultipleSelect;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentCheckboxGroup;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentRadioGroup;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentDate;

    private FormBuildingPage() {
        super(FormBuildingPage.getStaticTitle());
    }

    public static FormBuildingPage instance() {
        if (s_instance == null) {
            s_instance = new FormBuildingPage();
        }
        return s_instance;
    }

    public static String getStaticTitle() {
        return "Manage Questions of a Questionnaire";
    }

    public String getRelativeURL() {
        return "build-form" + FormBuilderDispatcher.getURLEnding();
    }

    protected void buildPage() {
        this.setDynamicTitle();
        this.setupGlobalPageState();
        this.addPageComponents();
        this.addActionListener(this.getDisplayListener());
        this.addActionListener(this.getActionListener());
    }

    private void addPageComponents() {
        this.add(this.getIndexLink());
        this.add(this.getQuestionPanel());
        this.add(this.getPreviewForm());
        this.add(this.getIndexLink());
    }

    private void setDynamicTitle() {
        Label titleLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.manage_questions_of_a_form"));
        titleLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label inner_titleLabel = (Label)e.getTarget();
                String adminName = FormBuildingPage.this.getQuestionnaire(e.getPageState()).getAdminName();
                inner_titleLabel.setLabel("Manage Questions of Form \"" + adminName + "\"");
            }
        });
        this.setTitle(titleLabel);
    }

    private void setupGlobalPageState() {
        this.m_formID = new BigDecimalParameter("form_id");
        this.m_pageMode = new StringParameter("page_mode");
        this.m_questionPosition = new IntegerParameter("question_position");
        this.m_widgetID = new BigDecimalParameter("widget_id");
        this.m_parameterName = new StringParameter("parameter_name");
        this.addGlobalStateParam(this.m_formID);
        this.addGlobalStateParam(this.m_pageMode);
        this.addGlobalStateParam(this.m_questionPosition);
        this.addGlobalStateParam(this.m_widgetID);
        this.addGlobalStateParam(this.m_parameterName);
    }

    private ActionListener getDisplayListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState pageState = e.getPageState();
                String pageMode = FormBuildingPage.this.getPageMode(pageState);
                if (pageMode == null || pageMode.equals("view") || FormBuildingPage.this.isSuccessfulSubmission(pageState)) {
                    this.displayPreviewForm(pageState);
                } else {
                    this.displayQuestionPanel(pageState);
                    this.hideQuestionPanelComponents(pageState);
                    if (pageMode.equals("add") || pageMode.equals("parameter")) {
                        FormBuildingPage.this.getWidgetListPanel().setVisible(pageState, true);
                        FormBuildingPage.this.getQuestionForm().setVisible(pageState, true);
                        List widgetList = FormBuildingPage.this.getWidgetList();
                        if (!widgetList.isSelected(pageState)) {
                            String defaultKey = FormBuildingPage.this.getDefaultWidgetKey(pageState);
                            widgetList.setSelectedKey(pageState, defaultKey);
                        }
                    } else if (pageMode.equals("edit")) {
                        this.selectWidget(pageState);
                        FormBuildingPage.this.getQuestionForm().setVisible(pageState, true);
                    } else if (pageMode.equals("move")) {
                        FormBuildingPage.this.getMoveForm().setVisible(pageState, true);
                    } else if (pageMode.equals("delete")) {
                        FormBuildingPage.this.getDeleteForm().setVisible(pageState, true);
                    }
                }
            }

            private void selectWidget(PageState pageState) {
                Integer position = FormBuildingPage.this.getQuestionPosition(pageState);
                if (position == null) {
                    return;
                }
            }

            private void displayPreviewForm(PageState pageState) {
                FormBuildingPage.this.getQuestionPanel().setVisible(pageState, false);
                FormBuildingPage.this.getPreviewForm().setVisible(pageState, true);
            }

            private void displayQuestionPanel(PageState pageState) {
                FormBuildingPage.this.getQuestionPanel().setVisible(pageState, true);
                FormBuildingPage.this.getPreviewForm().setVisible(pageState, false);
            }

            private void hideQuestionPanelComponents(PageState pageState) {
                FormBuildingPage.this.getWidgetListPanel().setVisible(pageState, false);
                FormBuildingPage.this.getQuestionForm().setVisible(pageState, false);
                FormBuildingPage.this.getMoveForm().setVisible(pageState, false);
                FormBuildingPage.this.getDeleteForm().setVisible(pageState, false);
            }
        };
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersistentWidget widget;
                PageState pageState = e.getPageState();
                if ((FormBuildingPage.this.getPageMode(pageState).equals("add") || FormBuildingPage.this.getPageMode(pageState).equals("parameter") || FormBuildingPage.this.getPageMode(pageState).equals("edit")) && FormBuildingPage.this.isSuccessfulSubmission(pageState) && (widget = FormBuildingPage.this.getQuestionForm().getPersistentWidget(pageState)) instanceof PersistentOptionGroup) {
                    Link redirectLink = new Link((Component)new Label(GlobalizationUtil.globalize("formbuilder.ui.label_to_be_ignored")), "url ignored");
                    redirectLink.setVar(OptionGroupPage.instance().m_formID.getName(), FormBuildingPage.this.getFormID(pageState).toString());
                    redirectLink.setVar(OptionGroupPage.instance().m_widgetID.getName(), widget.getID().toString());
                    redirectLink.setVar(OptionGroupPage.instance().m_widgetClass.getName(), widget.getClass().getName());
                    redirectLink.setVar(OptionGroupPage.instance().m_nOptions.getName(), FormBuildingPage.this.getQuestionForm().getNumberOfOptions(pageState));
                    redirectLink.setVar(OptionGroupPage.instance().m_pageMode.getName(), FormBuildingPage.this.getPageMode(pageState));
                    FormBuilderUtil.redirect(pageState, OptionGroupPage.instance().getRelativeURL() + redirectLink.getURLVarString());
                }
                if (FormBuildingPage.this.isSuccessfulSubmission(pageState)) {
                    pageState.setValue(FormBuildingPage.this.m_pageMode, "view");
                }
            }
        };
    }

    public Link getIndexLink() {
        if (this.m_indexLink == null) {
            this.m_indexLink = FormBuilderUtil.createIndexLink();
        }
        return this.m_indexLink;
    }

    public ColumnPanel getQuestionPanel() {
        if (this.m_questionPanel == null) {
            this.m_questionPanel = new ColumnPanel(2);
            Label actionLabel = new Label("");
            actionLabel.setFontWeight("b");
            this.setDynamicActionLabel(actionLabel);
            this.m_questionPanel.add(actionLabel, 64);
            this.m_questionPanel.add(this.getWidgetListPanel(), 8);
            this.m_questionPanel.add(this.getQuestionForm(), 8);
            this.m_questionPanel.add(this.getMoveForm(), 64);
            this.m_questionPanel.add(this.getDeleteForm(), 64);
        }
        return this.m_questionPanel;
    }

    private void setDynamicActionLabel(Label actionLabel) {
        actionLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label label = (Label)e.getTarget();
                PageState pageState = e.getPageState();
                if (FormBuildingPage.this.getPageMode(pageState).equals("add")) {
                    if (FormBuildingPage.this.getQuestionPosition(pageState) != null) {
                        label.setLabel((String)GlobalizationUtil.globalize("formbuilder.ui.add_a_question_at_position").localize() + FormBuildingPage.this.getQuestionPosition(pageState));
                    } else {
                        label.setLabel((String)GlobalizationUtil.globalize("formbuilder.ui.add_a_question").localize());
                    }
                } else if (FormBuildingPage.this.getPageMode(pageState).equals("parameter")) {
                    label.setLabel((String)GlobalizationUtil.globalize("formbuilder.ui.add_a_question_for_parameter").localize() + FormBuildingPage.this.getParameterName(pageState));
                } else if (FormBuildingPage.this.getPageMode(pageState).equals("edit")) {
                    label.setLabel("Edit question \"" + FormBuildingPage.this.getQuestionName(pageState) + "\"");
                } else if (FormBuildingPage.this.getPageMode(pageState).equals("move")) {
                    label.setLabel("Move Question \"" + FormBuildingPage.this.getQuestionName(pageState) + "\"");
                } else if (FormBuildingPage.this.getPageMode(pageState).equals("delete")) {
                    label.setLabel("Delete Question \"" + FormBuildingPage.this.getQuestionName(pageState) + "\"");
                }
            }
        });
    }

    public ColumnPanel getWidgetListPanel() {
        if (this.m_widgetListPanel == null) {
            this.m_widgetListPanel = new ColumnPanel(1);
            Label widgetLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.select_widget"));
            widgetLabel.setFontWeight("b");
            this.m_widgetListPanel.add(widgetLabel);
            this.m_widgetListPanel.add(this.getWidgetList());
        }
        return this.m_widgetListPanel;
    }

    public List getWidgetList() {
        if (this.m_widgetList == null) {
            ListModelBuilder listModelBuilder = new ListModelBuilder(){

                public ListModel makeModel(List list, PageState pageState) {
                    Map widgetMap = FormBuildingPage.this.getWidgetSelectionMap(pageState);
                    return new WidgetSelectionListModel(widgetMap);
                }

                public boolean isLocked() {
                    return true;
                }

                public void lock() {
                }
            };
            this.m_widgetList = new List(listModelBuilder);
        }
        return this.m_widgetList;
    }

    public QuestionPropertiesForm getQuestionForm() {
        if (this.m_questionForm == null) {
            this.m_questionForm = new QuestionPropertiesForm("question_properties");
        }
        return this.m_questionForm;
    }

    public MetaForm getPreviewForm() {
        if (this.m_previewForm == null) {
            this.m_previewForm = new PreviewForm(true, new PreviewFormConnector());
        }
        return this.m_previewForm;
    }

    public Form getMoveForm() {
        if (this.m_moveForm == null) {
            this.m_moveForm = new Form("move_form");
            Label moveLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.move_question_to_position"));
            moveLabel.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    PageState pageState = event.getPageState();
                    int nQuestions = FormBuildingPage.this.getQuestionnaire(pageState).getNumberOfQuestions();
                    Label label = (Label)event.getTarget();
                    label.setLabel((String)GlobalizationUtil.globalize("formbuilder.ui.move_question_to_position_1").localize() + nQuestions + ")");
                }
            });
            this.m_moveForm.add(moveLabel);
            TextField moveField = new TextField(new IntegerParameter("move_to_position"));
            moveField.addValidationListener(new NotEmptyValidationListener());
            this.m_moveForm.add(moveField);
            this.m_moveForm.add(new Submit("move"), 66);
            this.m_moveForm.addValidationListener(new FormValidationListener(){

                public void validate(FormSectionEvent e) {
                    PageState pageState = e.getPageState();
                    FormData data = e.getFormData();
                    if (data == null) {
                        return;
                    }
                    String parameterName = "move_to_position";
                    Integer value = (Integer)data.get(parameterName);
                    if (value == null) {
                        return;
                    }
                    if (value < 1) {
                        data.addError(parameterName, "Position must be greater than 1");
                        return;
                    }
                    int nQuestions = FormBuildingPage.this.getQuestionnaire(pageState).getNumberOfQuestions();
                    if (value > nQuestions) {
                        data.addError(parameterName, "Position must be less than or equal to " + nQuestions);
                        return;
                    }
                }
            });
            this.m_moveForm.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent e) {
                    FormData formData = e.getFormData();
                    PageState pageState = e.getPageState();
                    SimpleQuestionnaire questionnaire = FormBuildingPage.this.getQuestionnaire(pageState);
                    int fromPosition = FormBuildingPage.this.getQuestionPosition(pageState);
                    int toPosition = (Integer)formData.get("move_to_position");
                    questionnaire.moveQuestion(fromPosition, toPosition);
                }
            });
        }
        return this.m_moveForm;
    }

    public Form getDeleteForm() {
        if (this.m_deleteForm == null) {
            this.m_deleteForm = new Form("delete_form");
            this.m_deleteForm.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.you_are_about_to_delete_a_question")), 64);
            this.m_deleteForm.add(new Submit("ok", "Ok"));
            this.m_deleteForm.add(new Submit("cancel", "Cancel"));
            this.m_deleteForm.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent e) {
                    FormData formData = e.getFormData();
                    PageState pageState = e.getPageState();
                    String okSubmit = formData.getString("ok");
                    if (okSubmit != null) {
                        SimpleQuestionnaire questionnaire = FormBuildingPage.this.getQuestionnaire(pageState);
                        int questionPosition = FormBuildingPage.this.getQuestionPosition(pageState);
                        questionnaire.removeQuestion(questionPosition);
                    }
                }
            });
        }
        return this.m_deleteForm;
    }

    private PersistentLabel getQuestionLabel(PageState pageState) {
        SimpleQuestionnaire questionnaire = this.getQuestionnaire(pageState);
        return questionnaire.getQuestionLabel(this.getQuestionPosition(pageState));
    }

    private PersistentWidget getQuestionWidget(PageState pageState) {
        SimpleQuestionnaire questionnaire = this.getQuestionnaire(pageState);
        return questionnaire.getQuestionWidget(this.getQuestionPosition(pageState));
    }

    public BigDecimal getFormID(PageState pageState) {
        return (BigDecimal)pageState.getValue(this.m_formID);
    }

    public String getPageMode(PageState pageState) {
        String value = (String)pageState.getValue(this.m_pageMode);
        return value == null ? "view" : value;
    }

    public Integer getQuestionPosition(PageState pageState) {
        return (Integer)pageState.getValue(this.m_questionPosition);
    }

    public String getQuestionName(PageState pageState) {
        return this.getQuestionLabel(pageState).getLabel();
    }

    public BigDecimal getWidgetID(PageState pageState) {
        return (BigDecimal)pageState.getValue(this.m_widgetID);
    }

    public String getParameterName(PageState pageState) {
        String parameterName = (String)pageState.getValue(this.m_parameterName);
        if (parameterName == null && this.getPageMode(pageState).equals("edit")) {
            PersistentWidget widget = this.getQuestionnaire(pageState).getQuestionWidget(this.getQuestionPosition(pageState));
            parameterName = widget.getParameterName();
        }
        return parameterName;
    }

    public String getWidgetSelection(PageState pageState) {
        String className = null;
        if (this.getPageMode(pageState).equals("add") || this.getPageMode(pageState).equals("parameter")) {
            className = (String)this.m_widgetList.getSelectedKey(pageState);
            if (className == null) {
                className = this.getDefaultWidgetKey(pageState);
            }
        } else if (this.getPageMode(pageState).equals("edit")) {
            return this.getQuestionForm().getPersistentWidget(pageState).getClass().getName();
        }
        return className;
    }

    public String getWidgetSelectionName(PageState pageState) {
        return (String)this.getWidgetSelectionMap(pageState).get(this.getWidgetList().getSelectedKey(pageState));
    }

    public SimpleQuestionnaire getQuestionnaire(PageState pageState) {
        return (SimpleQuestionnaire)this.m_simpleQuestionnaire.get(pageState);
    }

    public boolean isSuccessfulSubmission(PageState pageState) {
        FormData formData = null;
        formData = this.getPageMode(pageState).equals("move") ? this.getMoveForm().getFormData(pageState) : (this.getPageMode(pageState).equals("delete") ? this.getDeleteForm().getFormData(pageState) : this.getQuestionForm().getFormData(pageState));
        return FormBuilderUtil.isSuccessfulSubmission(formData);
    }

    private Map getWidgetSelectionMap(PageState pageState) {
        return (Map)this.m_widgetSelectionMap.get(pageState);
    }

    private String getDefaultWidgetKey(PageState pageState) {
        String key = null;
        AttributeMetaData parameterData = this.getQuestionForm().getParameterMetaData(pageState);
        if (parameterData == null || !parameterData.isMultiple()) {
            key = (class$com$arsdigita$formbuilder$PersistentTextField == null ? (class$com$arsdigita$formbuilder$PersistentTextField = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentTextField")) : class$com$arsdigita$formbuilder$PersistentTextField).getName();
        } else if (parameterData.isMultiple()) {
            key = (class$com$arsdigita$formbuilder$PersistentCheckboxGroup == null ? (class$com$arsdigita$formbuilder$PersistentCheckboxGroup = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentCheckboxGroup")) : class$com$arsdigita$formbuilder$PersistentCheckboxGroup).getName();
        }
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_singleValueWidgetMap = new HashMap();
        s_multipleValueWidgetMap = new HashMap();
        s_singleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentTextField == null ? (class$com$arsdigita$formbuilder$PersistentTextField = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentTextField")) : class$com$arsdigita$formbuilder$PersistentTextField).getName(), "Text Field");
        s_singleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentTextArea == null ? (class$com$arsdigita$formbuilder$PersistentTextArea = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentTextArea")) : class$com$arsdigita$formbuilder$PersistentTextArea).getName(), "Text Area");
        s_multipleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentSingleSelect == null ? (class$com$arsdigita$formbuilder$PersistentSingleSelect = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentSingleSelect")) : class$com$arsdigita$formbuilder$PersistentSingleSelect).getName(), "Single Option Select Box");
        s_multipleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentMultipleSelect == null ? (class$com$arsdigita$formbuilder$PersistentMultipleSelect = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentMultipleSelect")) : class$com$arsdigita$formbuilder$PersistentMultipleSelect).getName(), "Multiple Option Select Box");
        s_multipleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentCheckboxGroup == null ? (class$com$arsdigita$formbuilder$PersistentCheckboxGroup = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentCheckboxGroup")) : class$com$arsdigita$formbuilder$PersistentCheckboxGroup).getName(), "Checkbox Group");
        s_multipleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentRadioGroup == null ? (class$com$arsdigita$formbuilder$PersistentRadioGroup = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentRadioGroup")) : class$com$arsdigita$formbuilder$PersistentRadioGroup).getName(), "Radio Group");
        s_singleValueWidgetMap.put((class$com$arsdigita$formbuilder$PersistentDate == null ? (class$com$arsdigita$formbuilder$PersistentDate = FormBuildingPage.class$("com.arsdigita.formbuilder.PersistentDate")) : class$com$arsdigita$formbuilder$PersistentDate).getName(), "Date Widget");
    }

    private class PreviewFormConnector
    implements PreviewFormPageConnector {
        private PreviewFormConnector() {
        }

        public SimpleQuestionnaire getQuestionnaire(PageState pageState) {
            return FormBuildingPage.this.getQuestionnaire(pageState);
        }
    }

    private class WidgetSelectionListModel
    implements ListModel {
        private Map m_map;
        private Iterator m_keyIterator;
        private String m_currentKey;

        public WidgetSelectionListModel(Map map) {
            this.m_map = map;
            this.m_keyIterator = map.keySet().iterator();
        }

        public Object getElement() {
            return (String)this.m_map.get(this.m_currentKey);
        }

        public String getKey() {
            return this.m_currentKey;
        }

        public boolean next() {
            boolean hasNext = this.m_keyIterator.hasNext();
            if (hasNext) {
                this.m_currentKey = (String)this.m_keyIterator.next();
            }
            return hasNext;
        }
    }
}

