/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.FormBuilderDispatcher;
import com.arsdigita.formbuilder.SimpleQuestionnaire;
import com.arsdigita.formbuilder.ui.PreviewForm;
import com.arsdigita.formbuilder.ui.PreviewFormPageConnector;
import com.arsdigita.formbuilder.ui.TemplatePage;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class FormViewPage
extends TemplatePage {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormViewPage.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static FormViewPage s_instance;
    private BigDecimalParameter m_formID;
    private RequestLocal m_questionnaire = new RequestLocal(){

        public Object initialValue(PageState pageState) {
            SimpleQuestionnaire questionnaire;
            try {
                questionnaire = new SimpleQuestionnaire(FormViewPage.this.getFormID(pageState));
            }
            catch (DataObjectNotFoundException notFoundException) {
                throw new UncheckedWrapperException(notFoundException);
            }
            return questionnaire;
        }
    };

    private FormViewPage() {
        super(FormViewPage.getStaticTitle());
    }

    public static FormViewPage instance() {
        if (s_instance == null) {
            s_instance = new FormViewPage();
        }
        return s_instance;
    }

    protected void buildPage() {
        this.m_formID = new BigDecimalParameter("form_id");
        this.addGlobalStateParam(this.m_formID);
        this.add(FormBuilderUtil.createIndexLink());
        this.setDynamicTitle();
        this.add(new PreviewForm(false, new FormConnector()));
        this.add(FormBuilderUtil.createIndexLink());
    }

    private void setDynamicTitle() {
        Label titleLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.view_persisted_form"));
        titleLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label inner_titleLabel = (Label)e.getTarget();
                PageState pageState = e.getPageState();
                SimpleQuestionnaire questionnaire = FormViewPage.this.getQuestionnaire(pageState);
                String adminName = questionnaire.getAdminName();
                inner_titleLabel.setLabel("View Persisted Form \"" + adminName + "\"");
            }
        });
        this.setTitle(titleLabel);
    }

    public BigDecimal getFormID(PageState pageState) {
        return (BigDecimal)pageState.getValue(this.m_formID);
    }

    public static String getStaticTitle() {
        return "View a Persisted Form";
    }

    public String getRelativeURL() {
        return "view-form" + FormBuilderDispatcher.getURLEnding();
    }

    private SimpleQuestionnaire getQuestionnaire(PageState pageState) {
        return (SimpleQuestionnaire)this.m_questionnaire.get(pageState);
    }

    private class FormConnector
    implements PreviewFormPageConnector {
        private FormConnector() {
        }

        public SimpleQuestionnaire getQuestionnaire(PageState pageState) {
            return FormViewPage.this.getQuestionnaire(pageState);
        }
    }
}

