/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.ui.DecimalSingleSelectionModel;
import com.arsdigita.formbuilder.ui.FormCompletionListener;
import com.arsdigita.formbuilder.ui.NewAction;
import com.arsdigita.formbuilder.ui.ProcessListenerProperties;
import com.arsdigita.formbuilder.ui.ProcessListenerTableModelBuilder;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class ProcessListenerEditor
extends SimpleContainer {
    SingleSelectionModel m_form;
    SingleSelectionModel m_action;
    BoxPanel m_list_actions;
    ProcessListenerProperties m_edit_action;

    public ProcessListenerEditor(String app, SingleSelectionModel form) {
        this.m_form = form;
        String helpURL = FormBuilderUtil.getConfig().getActionsHelpLink();
        if (helpURL != null) {
            this.add(new Link((Component)new Label(GlobalizationUtil.globalize("formbuilder.ui.help")), helpURL));
            this.add(new Label(""));
        }
        NewAction a = new NewAction(app);
        Table t = new Table((TableModelBuilder)new ProcessListenerTableModelBuilder(this.m_form), (Object[])new String[]{"Form action", "", ""});
        this.m_action = new DecimalSingleSelectionModel(t.getRowSelectionModel());
        t.setDefaultCellRenderer(new TableCellRenderer(){

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                PersistentProcessListener l = (PersistentProcessListener)value;
                if (column == 0) {
                    return new Label(l.getDescription());
                }
                if (column == 1) {
                    ControlLink lk = new ControlLink((String)GlobalizationUtil.globalize("formbuilder.ui.edit").localize());
                    return lk;
                }
                if (column == 2) {
                    ControlLink lk = new ControlLink((String)GlobalizationUtil.globalize("formbuilder.ui.delete").localize());
                    lk.setConfirmation("Are you sure you wish to delete this action?");
                    return lk;
                }
                return null;
            }
        });
        t.addTableActionListener(new FormItemActionListener());
        this.m_list_actions = new BoxPanel(2);
        this.m_edit_action = new ProcessListenerProperties(this.m_form, a.getSelection(), this.m_action, app);
        a.addProcessListener(new FormItemProcessListener(this.m_edit_action, this.m_list_actions));
        this.m_edit_action.addCompletionListener(new FormItemCompletionListener(this.m_list_actions, this.m_edit_action));
        this.m_list_actions.add(a);
        this.m_list_actions.add(t);
        this.add(this.m_list_actions);
        this.add(this.m_edit_action);
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam(this, this.m_action.getStateParameter());
        page.setVisibleDefault(this.m_list_actions, true);
        page.setVisibleDefault(this.m_edit_action, false);
    }

    private class FormItemActionListener
    implements TableActionListener {
        private FormItemActionListener() {
        }

        public void headSelected(TableActionEvent e) {
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            Integer type = e.getColumn();
            if (type == 1) {
                ProcessListenerEditor.this.m_edit_action.setVisible(state, true);
                ProcessListenerEditor.this.m_list_actions.setVisible(state, false);
            } else {
                BigDecimal action_id = (BigDecimal)ProcessListenerEditor.this.m_action.getSelectedKey(state);
                try {
                    PersistentProcessListener l = (PersistentProcessListener)DomainObjectFactory.newInstance(new OID("com.arsdigita.formbuilder.ProcessListener", (Object)action_id));
                    l.delete();
                }
                catch (DataObjectNotFoundException ex) {
                    throw new UncheckedWrapperException("cannot find listener", ex);
                }
            }
        }
    }

    private class FormItemCompletionListener
    implements FormCompletionListener {
        Component m_show;
        Component m_hide;

        public FormItemCompletionListener(Component show, Component hide) {
            this.m_show = show;
            this.m_hide = hide;
        }

        public void complete(FormSectionEvent e) throws FormProcessException {
            ProcessListenerEditor.this.m_action.clearSelection(e.getPageState());
            this.m_show.setVisible(e.getPageState(), true);
            this.m_hide.setVisible(e.getPageState(), false);
        }
    }

    private class FormItemProcessListener
    implements FormProcessListener {
        Component m_show;
        Component m_hide;

        public FormItemProcessListener(Component show, Component hide) {
            this.m_show = show;
            this.m_hide = hide;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            ProcessListenerEditor.this.m_action.clearSelection(e.getPageState());
            this.m_show.setVisible(e.getPageState(), true);
            this.m_hide.setVisible(e.getPageState(), false);
        }
    }
}

